#ifndef QRK_TCPIP_ACCEPTER_H
#define QRK_TCPIP_ACCEPTER_H

/*!
  \file
  \brief 接続の受付

  \author Satofumi KAMIMURA

  $Id: TcpipAccepter.h 1811 2010-04-30 16:12:05Z satofumi $
*/

#include <memory>


namespace qrk
{
    class TcpipSocket;


    //! 接続の受付
    class TcpipAccepter
    {
    public:
        enum {
            NoTimeout = -1,
        };
        TcpipAccepter(void);
        ~TcpipAccepter(void);


        /*!
          \brief 内部状態を返す

          \return 内部状態を示す文字列
        */
        const char* what(void) const;


        /*!
          \brief 有効化

          \param[in] port ポート番号
        */
        bool activate(long port);


        /*!
          \brief 無効化
        */
        void deactivate(void);


        /*!
          \brief 接続の受け付け

          \param[in] timeout タイムアウト [msec]
        */
        TcpipSocket* accept(int timeout = NoTimeout);


        /*!
          \brief サーバ名の取得

          \retval サーバ名

          \attention この関数を呼び出す前に activate() が成功していなければならない
          \see activate
        */
        const char* name(void);

    private:
        TcpipAccepter(const TcpipAccepter& rhs);
        TcpipAccepter& operator = (const TcpipAccepter& rhs);

        struct pImpl;
        const std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_TCPIP_ACCEPTER_H */
