/*!
  \file
  \brief ring_buffer のテスト

  \author Satofumi KAMIMURA

  $Id: Test_ring_buffer.cpp 1562 2009-12-01 22:37:19Z satofumi $
*/

#include "Test_ring_buffer.h"
extern "C" {
#include "ring_buffer.h"
}

using namespace std;


CPPUNIT_TEST_SUITE_REGISTRATION(RingBufferTest);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(RingBufferTest, "RingBufferTest");


void RingBufferTest::capacityTest(void)
{
  ringBuffer_t ring;
  char buffer[] = { '\0', '\0' };
  ring_initialize(&ring, buffer, 1);

  CPPUNIT_ASSERT_EQUAL(1, ring_capacity(&ring));
}


void RingBufferTest::putTest(void) {

  ringBuffer_t ring;
  char buffer[] = { '\0', '\0' };
  char ch;
  int n;

  ring_initialize(&ring, buffer, 1);
  CPPUNIT_ASSERT_EQUAL(0, ring_size(&ring));
  CPPUNIT_ASSERT_EQUAL(1, ring_capacity(&ring));

  ring_write(&ring, "0", 1);
  CPPUNIT_ASSERT_EQUAL(1, ring_size(&ring));

  n = ring_read(&ring, &ch, 1);
  CPPUNIT_ASSERT_EQUAL('0', buffer[0]);
  CPPUNIT_ASSERT_EQUAL(1, n);
  CPPUNIT_ASSERT_EQUAL(1, ring_capacity(&ring));

  ring_clear(&ring);
  CPPUNIT_ASSERT_EQUAL(0, ring_size(&ring));
  CPPUNIT_ASSERT_EQUAL(1, ring_capacity(&ring));
}


void RingBufferTest::rotateTest(void) {

  ringBuffer_t ring;
  char buffer[] = { '\0', '\0', '\0', '\0', };
  char recv_buffer[] = { '\0', '\0', '\0', '\0', };
  int n;

  ring_initialize(&ring, buffer, 2);

  for (int i = 0; i < 3; ++i) {
    char ch = '0' + i;
    n = ring_write(&ring, &ch, 1);
    CPPUNIT_ASSERT_EQUAL(1, n);
  }

  n = ring_size(&ring);
  CPPUNIT_ASSERT_EQUAL(3, n);

  n = ring_read(&ring, recv_buffer, 3);
  CPPUNIT_ASSERT_EQUAL(3, n);
  CPPUNIT_ASSERT_EQUAL(string("012"), string(recv_buffer));

  ring_write(&ring, "abc", 3);
  n = ring_read(&ring, recv_buffer, 3);
  CPPUNIT_ASSERT_EQUAL(3, n);
  CPPUNIT_ASSERT_EQUAL(string("abc"), string(recv_buffer));
}
