#ifndef TEST_RING_BUFFER_H
#define TEST_RING_BUFFER_H

/*!
  \file
  \brief RingBuffer のテスト

  \author Satofumi KAMIMURA

  $Id: TestRingBuffer.h 1811 2010-04-30 16:12:05Z satofumi $
*/

#include <cppunit/extensions/HelperMacros.h>


//! RingBuffer のテストクラス
class TestRingBuffer : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE(TestRingBuffer);
    CPPUNIT_TEST(compileTest);
    CPPUNIT_TEST(putTest);
    CPPUNIT_TEST(extendTest);
    CPPUNIT_TEST(rotateTest);
    CPPUNIT_TEST(ungetcTest);
    CPPUNIT_TEST_SUITE_END();

public:
    void compileTest(void);
    void putTest(void);
    void extendTest(void);
    void rotateTest(void);
    void ungetcTest(void);
};

#endif /* !TEST_RING_BUFFER_H */
