#ifndef QRK_SDL_MIXER_INIT_H
#define QRK_SDL_MIXER_INIT_H

/*!
  \file
  \brief SDL_mixer の初期化

  \author Satofumi KAMIMURA

  $Id: SdlMixerInit.h 1957 2011-07-27 23:13:30Z satofumi $
*/

#include <memory>


namespace qrk
{
    //! SDL_ttf の初期化クラス
    class SdlMixerInit
    {
        SdlMixerInit(const SdlMixerInit& rhs);
        SdlMixerInit& operator = (const SdlMixerInit& rhs);

        struct pImpl;
        const std::auto_ptr<pImpl> pimpl;

    public:
        SdlMixerInit(void);
        ~SdlMixerInit(void);

        //! システムの初期化
        bool initialize(void);

        bool isInitialized(void);
    };
}

#endif /* !QRK_SDL_MIXER_INIT_H */
