/*!
  \file
  \brief 音楽まわりの初期化

  \author Satofumi KAMIMURA

  $Id: Audio.cpp 1964 2011-08-12 19:16:24Z satofumi $
*/

#include "Audio.h"
#include "SdlMixerInit.h"
#include <SDL_mixer.h>
#include <string>

using namespace qrk;
using namespace std;


struct Audio::pImpl : private SdlMixerInit
{
    string error_message_;


    pImpl(void) : error_message_(Mix_GetError())
    {
    }


    static pImpl* singleton_object(void)
    {
        static pImpl object_;
        return &object_;
    }


    bool initialize(void)
    {
        return SdlMixerInit::initialize();
    }


    bool isInitialized(void)
    {
        return SdlMixerInit::isInitialized();
    }
};


Audio::Audio(void) : pimpl(pImpl::singleton_object())
{
}


Audio::~Audio(void)
{
}


const char* Audio::what(void) const
{
    return pimpl->error_message_.c_str();
}


bool Audio::initialize(void)
{
    return pimpl->initialize();
}


bool Audio::isInitialized(void)
{
    return pimpl->isInitialized();
}
