#ifndef QRK_BACK_MUSIC_H
#define QRK_BACK_MUSIC_H

/*!
  \file
  \brief 背景曲の再生

  \author Satofumi KAMIMURA

  $Id: BackMusic.h 1964 2011-08-12 19:16:24Z satofumi $
*/

#include <cstddef>


namespace qrk
{
    class BackMusic
    {
    public:
        enum {
            Instantly = -1,
            Infinity = -1,
        };

        BackMusic(void);
        ~BackMusic(void);

        void setMute(bool is_mute);
        bool isMute(void) const;

        void free_music_resource(const char* file_path);

        void setVolume(size_t percent);

        /*!
          \brief 曲を再生する

          他の曲を再生中の場合、再生中の曲を fade_out_msec の時間をかけて fade out してから指定した曲の再生を開始する。
        */
        bool play(const char* file_path, int fade_in_msec = Instantly,
                  int play_times = Infinity, int fade_out_msec = Instantly);
        void stop(int fade_out_msec = Instantly);
        bool isPlaying(void) const;

    private:
        BackMusic(const BackMusic& rhs);
        BackMusic& operator = (const BackMusic& rhs);

        struct pImpl;
        pImpl* pimpl;
    };
}

#endif /* !QRK_BACK_MUSIC_H */
