-- シミュレーションの設定ファイル
-- Satofumi KAMIMURA
-- $Id: simulation_settings.lua 1367 2009-10-03 10:00:29Z satofumi $


-- 利用デバイスの初期化
DeviceManager():createDevice("/dev/ttyUSB0", "BeegoDrive", "run")
DeviceManager():createDevice("/dev/ttyACM0", "UrgDevice", "urg")


-- デバイスを起動
DeviceManager():device("run"):activate()
DeviceManager():device("urg"):activate()


-- デバイス位置を設定
-- !!! urg がロボットとの相対指定でないのを修正する
local angle = -10
local run = DeviceManager():model("run")
run:setPosition(Position(0, 200, deg(angle)), nil, false)

local urg = DeviceManager():model("urg")
urg:setPosition3d(Point3d(70, 0, 100), 0.0, 0.0, 1.0, deg(angle), run, true)


-- カメラ視点を設定
CameraViewManager():setInitialView(1.0, -0.55, 3.0, deg(0), deg(0), deg(0))
CameraViewManager():setScale(0.3)


-- 壁を配置
local w = 10
local box = Box(5000, w, 300, 1.0)
box:setPosition(Position(500, 1000 + w/2, deg(0)), nil, false)

local box = Box(1500, w, 300, 1.0)
box:setPosition(Position(-1250, -2500 + w/2, deg(0)), nil, false)

local box = Box(5000, w, 300, 1.0)
box:setPosition(Position(3000 + w/2, -1500, deg(-90)), nil, false)

local box = Box(1500, w, 300, 1.0)
box:setPosition(Position(-500 + w/2, -3250, deg(-90)), nil, false)
