#ifndef PLOT_OBJECTS_H
#define PLOT_OBJECTS_H

/*!
  \file
  \brief 描画

  \author Satofumi KAMIMURA

  $Id: plot_objects.h 1520 2009-11-16 12:35:30Z satofumi $
*/

#include <vector>
#include <pole_t.h>
#include <line_t.h>
#include <Position.h>


namespace qrk
{
  class MarkerManager;
  class RangeFinder;
  class Angle;
}


extern void plotLrfData(qrk::MarkerManager& marker,
                        const qrk::RangeFinder& range_finder,
                        const std::vector<long>& data,
                        const char* name = "lrf_data");
extern void plotOriginDirection(qrk::MarkerManager& marker,
                                const qrk::Angle& direction);
extern void plotPoles(qrk::MarkerManager& marker,
                      const std::vector<qrk::pole_t>& poles,
                      const qrk::Position<long>& position,
                      const char* name = "poles");
extern void plotLines(qrk::MarkerManager& marker,
                      const std::vector<qrk::line_t>& lines,
                      const char* name = "lines");

#endif /* !PLOT_OBJECTS_H */
