/*!
  \file
  \brief シミュレーション環境の生成

  \author Satofumi KAMIMURA

  $Id: simulation_environment.cpp 1568 2009-12-06 13:49:56Z satofumi $
*/

#include "loadData.h"
#include "MathUtils.h"
#include <fstream>

using namespace qrk;
using namespace std;


namespace
{
  bool convertLines(ofstream& fout, const char* lines_file)
  {
    vector<line_t> lines;
    if (! loadLines(lines, lines_file)) {
      return false;
    }

    for (vector<line_t>::const_iterator it = lines.begin();
         it != lines.end(); ++it) {
      double radian = it->direction.to_rad();
      long x_offset = static_cast<long>(it->length * cos(radian) / 2);
      long y_offset = static_cast<long>(it->length * sin(radian) / 2);
      fout << "local box = Box(" << it->length * 0.98
           << ", 10, 300, 1.0)" << endl
           << "box:setPosition(Position("
           << it->begin.x + x_offset << ", "
           << it->begin.y + y_offset << ", deg("
           << it->direction.to_deg() << ")), nil, false)" << endl
           << endl;
    }

    return true;
  }


  bool convertPoles(ofstream& fout, const char* poles_file)
  {
    vector<pole_t> poles;
    if (! loadPoles(poles, poles_file)) {
      return false;
    }

    for (vector<pole_t>::const_iterator it = poles.begin();
         it != poles.end(); ++it) {
      fout << "local cylinder = Cylinder(120, 1000, 1.0)" << endl
           << "cylinder:setPosition(Position("
           << it->center.x << ", " << it->center.y
           << ", deg(0)), nil, false)" << endl
           << endl;
    }

    return true;
  }
}


int main(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  ofstream fout("environment.lua");
  if (! fout.is_open()) {
    perror("environment.lua");
    return 1;
  }

  // データ読み出しと Lua スクリプトの出力
  if ((! convertLines(fout, "lines.txt")) ||
      (! convertPoles(fout, "poles.txt"))) {
    return 1;
  }

  return 0;
}
