/*!
  \file
  \brief データのロード

  \author Satofumi KAMIMURA

  $Id: loadData.cpp 1546 2009-11-24 03:42:05Z satofumi $
*/

#include "loadData.h"
#include "MathUtils.h"
#include "PointUtils.h"
#include "split.h"
#include <fstream>
#include <cstdlib>

using namespace qrk;
using namespace std;


bool loadPath(std::vector<qrk::Point<long> >& path, const char* file)
{
  ifstream fin(file);
  if (! fin.is_open()) {
    perror(file);
    return false;
  }

  string line;
  while (getline(fin, line)) {
    vector<string> tokens;
    int n = split(tokens, line);
    if (n == 2) {
      int x = atoi(tokens[0].c_str());
      int y = atoi(tokens[1].c_str());

      path.push_back(Point<long>(x, y));
    }
  }
  return true;
}


bool loadLines(std::vector<qrk::line_t>& lines, const char* file)
{
  ifstream fin(file);
  if (! fin.is_open()) {
    perror(file);
    return false;
  }

  string line;
  while (getline(fin, line)) {
    vector<string> tokens;
    int n = split(tokens, line);
    if (n == 4) {
      int x0 = atoi(tokens[0].c_str());
      int y0 = atoi(tokens[1].c_str());
      int x1 = atoi(tokens[2].c_str());
      int y1 = atoi(tokens[3].c_str());

      line_t line;
      line.begin = Point<long>(x0, y0);
      line.direction = rad(atan2(y1 - y0, x1 - x0));
      line.length = length<long>(line.begin, Point<long>(x1, y1));
      lines.push_back(line);
    }
  }
  return true;
}


bool loadPoles(std::vector<qrk::pole_t>& poles, const char* file)
{
  ifstream fin(file);
  if (! fin.is_open()) {
    perror(file);
    return false;
  }

  string line;
  while (getline(fin, line)) {
    vector<string> tokens;
    int n = split(tokens, line);
    if (n == 2) {
      int x = atoi(tokens[0].c_str());
      int y = atoi(tokens[1].c_str());

      pole_t pole;
      pole.center = Point<long>(x, y);
      pole.radius = 300;
      poles.push_back(pole);
    }
  }
  return true;
}
