#ifndef PIXEL_MAP_H
#define PIXEL_MAP_H

/*!
  \file
  \brief 画像の生成

  \author Satofumi KAMIMURA

  $Id: PixelMap.h 1535 2009-11-18 14:58:34Z satofumi $
*/

#include "map_grid.h"
#include "Rect.h"
#include <memory>


namespace qrk
{
  class Color;
}


class PixelMap
{
public:
  PixelMap(const qrk::Rect<long>& rect);
  ~PixelMap(void);

  void addPoints(const Grid& grid, const qrk::Color& color, int max_score);
  void generate(void);

private:
  PixelMap(const PixelMap& rhs);
  PixelMap& operator = (const PixelMap& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;
};

#endif /* !PIXEL_MAP_H */
