#pragma once

class yamain
{
public:
	yamain(TCHAR* filename, TCHAR* dbfilename);
	virtual ~yamain(void);
	
	virtual boolean deleteData(void);
	virtual boolean createHash(void);
	virtual boolean checkHash(boolean update_db = false);
	
	virtual std::string getUUIDFromDB(void);
	virtual std::string getUUIDFromDisk(void);
	virtual boolean setUUIDToDB(std::string uuid);
	virtual boolean setUUIDToDisk(std::string uuid);
	
	virtual boolean checkUUIDonDB(std::string uuid);
	virtual boolean updateFilepathonDBByUUID(TCHAR* filename, std::string diskuuid);

private:
	boost::filesystem::path filepath;
	boost::filesystem::path dbpath;
	TCHAR* filename;
	TCHAR* dbfilename;
	std::string uuid;
	yantfsstream* yafs;
	yasqlite3db* yadb;
	yahash* hash;

	std::map<int, std::string> yahashtype_string;
	
	std::map<int, std::string> file_hash; // results from file
	std::map<int, std::string> db_hash; // results from db
};
