//---------------------------------------------------------
// Samplefile for qclibmpi
// usage:
// % make
// % mpirun -np [2|4|8] ./ap
//---------------------------------------------------------
#include <stdio.h>
#include <mpi.h>
#include "QC_all.h"

//---------------------------------------------------------
int main(int argc, char *argv[])
{
    int ierr, myid, numprocs;
    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &myid);
    MPI_Comm_size(MPI_COMM_WORLD, &numprocs);
    const int NQUBITS = 8;
    int mdata = QCalcUnit::initmpi(NQUBITS,myid,numprocs);

    double *R = new double[mdata];
    double *I = new double[mdata];
    //init:
    QCalcUnit::initdata(R, I);
    QC_hadamard::calcmpi(0,R,I,NQUBITS);
//    QCalcUnit::showdata(R, I);
    if(0==myid){
      for(int i=0;i<mdata;i++){
        printf("%02i: %f %f\n",i,R[i],I[i]);
      }
    }
    delete I;
    delete R;
    MPI_Finalize();
    return 0;
}
//---------------------------------------------------------
