//----------------------------------------------------------------------------
//  CompilerCode.h
//  Compile intermediate code into native C++ code
//  $Date: 2003/02/20 00:24:16 $
//  $Revision: 1.3 $
//----------------------------------------------------------------------------
#ifndef QCOMPILERCODE_H
#define QCOMPILERCODE_H

#include <iostream>
#include <string>
#include <vector>
#include "QCompiler.h"
#include "QParseInfo.h"

class QCompilerCode : public QCompiler {
public:
  QCompilerCode(const char * const = "qcpp_result.qdt");
  QCompilerCode(std::istream &is, const char * const = "qcpp_result.qdt");
  virtual ~QCompilerCode();
  void SaveToStream(std::ostream &os);
  void SaveToFile(const char * const filename);

protected:
  virtual bool CompileOneLine(const QParseInfo &pinfo);
  virtual void CatchError(const QParseInfo &pinfo, const int at);

  // Utility functions
  void WriteHeader(std::ostream &os);
  void WriteQBits(std::ostream &os, const int &t1);
  void WriteFooter(std::ostream &os);
  void WriteCNot  (std::ostream &os, const int &t1, const int &c1);
  void WriteCCNot (std::ostream &os, const int &t1, const int &c1, const int &c2);
  void WriteCRot  (std::ostream &os, const int &t1, const int &c1, const double rad);
  void WriteHadam (std::ostream &os, const int &t1);
  //TODO: additional controls

  // Member valuables
  std::string mTargetName;
  std::vector<QParseInfo> mQParseInfo;
};

#endif //QCOMPILERCODE_H
