//---------------------------------------------------------------------------
#ifndef QPauliXH
#define QPauliXH
//---------------------------------------------------------------------------
#include "QCircuit.h"
//---------------------------------------------------------------------------
class QPauliX : public QCircuit {

public:
  QPauliX(int x, int y);

  virtual int        GetType(void)    { return QC_PAULIX; }
  virtual string GetTypeStr(void) { return "QPauliX"; }

  void Draw(QDraw * qDraw);
  void DrawPS(QPSDraw * psDraw);
  string GetCalcText(void);
  string GetSaveText(void);
  void Reverse(int y);
  TRect GetOccupiedRect();
  QCircuit *Clone() {QPauliX *qx = new QPauliX(X, Y); return (QCircuit*)qx;};
};
//---------------------------------------------------------------------------
#endif
