//---------------------------------------------------------------------------
// PostScript
//---------------------------------------------------------------------------
#ifndef QPSDrawH
#define QPSDrawH
#include "QAbstractDraw.h"
//---------------------------------------------------------------------------
class QPSDraw : public QAbstractDraw {

private:
  int FontSize;
  int Width;
  int Height;
  std::ostringstream osEPS;
  void AddText(const char* str);

  //---------------------------------------------------------------------------
public:
  QPSDraw(void);
  ~QPSDraw(void);

  void SetWidth(int w) {Width = w;};
  void SetHeight(int h) {Height = h;};
  std::string GetText(void);

  //---------------------------------------------------------------------------
  // Drawing Methods (inherited)
  //---------------------------------------------------------------------------
  void DrawLine(int x1,int y1,int x2,int y2);
  void TextOut(int x,int y,std::string Text);
  void FrameRect(int x1,int y1,int x2,int y2);
  void FillRect(int x1,int y1,int x2,int y2);
  void DrawMeasure(int x1,int y1);
  void DrawCircle(int x1,int y1,int r);
  void DrawFillCircle(int x1,int y1,int r);
  //---------------------------------------------------------------------------
  // DrawingMethod (other)
  //---------------------------------------------------------------------------
  void DrawDashedLine(int x1,int y1,int x2,int y2);
  void DrawGrid(int line, bool enabled);
};
//---------------------------------------------------------------------------
#endif
