//---------------------------------------------------------------------------
#ifndef QAbstractDrawH
#define QAbstractDrawH
//---------------------------------------------------------------------------
#include <string>
//---------------------------------------------------------------------------
class QAbstractDraw {

protected:
  int GridSize;
  int UnitSize;
  int TopMargin;
  int LeftMargin;

public:
  QAbstractDraw(void);

  int GetGridSize(void) {return GridSize;};
  int GetUnitSize(void) {return UnitSize;};
  int GetTopMargin(void) {return TopMargin;};
  int GetLeftMargin(void) {return LeftMargin;};

  virtual void DrawLine(int x1,int y1,int x2,int y2) {};
  virtual void DrawCircle(int x1,int y1,int r) {};
  virtual void DrawFillCircle(int x1,int y1,int r) {};

  virtual void TextOut(int x,int y,std::string Text) {};
  virtual void FrameRect(int x1, int y1, int x2, int y2) {};
  virtual void FillRect(int x1, int y1, int x2, int y2) {};
  virtual void DrawMeasure(int x1,int y1) {};
};
//---------------------------------------------------------------------------
#endif
