//---------------------------------------------------------------------------
#include "QPauliZ.h"
//---------------------------------------------------------------------------
QPauliZ::QPauliZ(int x, int y) : QCircuit(x,y) {
  Name = GetTypeStr();
}
//---------------------------------------------------------------------------
void
QPauliZ::Draw(QDraw* qDraw) {

  int GridSize = qDraw->GetGridSize();
  int UnitSize = qDraw->GetUnitSize();
  int d = (GridSize-UnitSize)/2;
  int x1 = X * GridSize+d;
  int y1 = Y * GridSize+d;
  int x2 = x1 + UnitSize;
  int y2 = y1 + UnitSize;

  qDraw->SetBrushColor(clWhite);
  qDraw->FillRect(x1,y1,x2,y2);
  qDraw->SetBrushColor(clLime);
  qDraw->FrameRect(x1,y1,x2,y2);

  qDraw->SetBrushColor(clWhite);
  qDraw->TextOut(x1+UnitSize/2,y1+UnitSize/2,"Z");

}
//---------------------------------------------------------------------------
void
QPauliZ::DrawPS(QPSDraw * psDraw) {
  int GridSize = psDraw->GetGridSize();
  int UnitSize = psDraw->GetUnitSize();
  int d = (GridSize-UnitSize)/2;
  int x1 = X * GridSize+d;
  int y1 = Y * GridSize+d;
  int x2 = x1 + UnitSize;
  int y2 = y1 + UnitSize;

  psDraw->FillRect(x1,y1,x2,y2);
  psDraw->FrameRect(x1,y1,x2,y2);

  psDraw->TextOut(x1+UnitSize/2,y1+UnitSize/2,"Z");
}
//---------------------------------------------------------------------------
string
QPauliZ::GetCalcText(void) {
  ostringstream os;
  os << "PAULIZ(q[" << Y << "])";
  return os.str();
}
//---------------------------------------------------------------------------
string
QPauliZ::GetSaveText(void) {
  ostringstream os;
  os << X << "," << Y << "," << Name << ",\"\"";
  return os.str();
}
//--------------------------------------------------------------------------
void
QPauliZ::Reverse(int y) {
  Y = y - Y;
}
//--------------------------------------------------------------------------
TRect
QPauliZ::GetOccupiedRect() {
  return TRect(X, Y, X + 1, Y + 1);
}
//--------------------------------------------------------------------------
