//---------------------------------------------------------------------------
#include "QNot.h"
//---------------------------------------------------------------------------
QNot::QNot(int x,int y) :QCircuit(x,y) {
  Name = GetTypeStr();
}
//---------------------------------------------------------------------------
void
QNot::Draw(QDraw *qDraw) {

  int GridSize = qDraw->GetGridSize();
  int UnitSize = qDraw->GetUnitSize();
  int d = (GridSize-UnitSize)/2;
  int x1 = X * GridSize+d;
  int y1 = Y * GridSize+d;
  int x2 = x1 + UnitSize;
  int y2 = y1 + UnitSize;

  qDraw->SetBrushColor(clWhite);
  qDraw->FillRect(x1,y1,x2,y2);
  qDraw->SetPenColor(clBlack);
  qDraw->SetBrushColor(clWhite);
  qDraw->Ellipse(x1,y1,x2,y2);
  qDraw->DrawLine(x1+UnitSize/2,y1,x1+UnitSize/2,y2);
  qDraw->DrawLine(x1,y1+UnitSize/2,x2,y1+UnitSize/2);
}
//---------------------------------------------------------------------------
string
QNot::GetCalcText(void) {
  ostringstream os;
  os << "NOT(q[" << Y << "])";
  return os.str();
}
//---------------------------------------------------------------------------
void
QNot::DrawPS(QPSDraw *psDraw) {
  int GridSize = psDraw->GetGridSize();
  int UnitSize = psDraw->GetUnitSize();
  int d = (GridSize-UnitSize)/2;
  int x1 = X * GridSize+d;
  int y1 = Y * GridSize+d;
  int x2 = x1 + UnitSize;
  int y2 = y1 + UnitSize;

  psDraw->FillRect(x1,y1,x2,y2);
  psDraw->DrawCircle(X*GridSize + GridSize/2,Y*GridSize + GridSize/2,UnitSize/2);
  psDraw->DrawLine(x1+UnitSize/2,y1,x1+UnitSize/2,y2);
  psDraw->DrawLine(x1,y1+UnitSize/2,x2,y1+UnitSize/2);
}
//---------------------------------------------------------------------------
void
QNot::Reverse(int y) {
  Y = y - Y;
}
//---------------------------------------------------------------------------
TRect
QNot::GetOccupiedRect() {
  return TRect(X, Y, X + 1, Y + 1);
}
//---------------------------------------------------------------------------
/**
* Construct clone object
**/
QCircuit *
QNot::Clone() {
  QNot *qn = new QNot(X, Y);
  return (QCircuit*)qn;
}
//---------------------------------------------------------------------------
