//---------------------------------------------------------------------------
// Class for Circuits
//---------------------------------------------------------------------------
#include "QCircuit.h"
#include "QCircuitAll.h"

//---------------------------------------------------------------------------
QCircuit::QCircuit(int x,int y) {
  X = x;
  Y = y;
}
//---------------------------------------------------------------------------
int
QCircuit::GetType(string Type) {

  if (Type =="QBitBox") {
    return QC_BITBOX;
  } else if (Type =="QWalsh") {
    return QC_WALSH;
  } else if (Type == "QCNot") {
    return QC_CNOT;
  } else if (Type == "QCCNot") {
    return QC_CCNOT;
  } else if (Type == "QMeasure") {
    return QC_MEASURE;
  } else if (Type == "QTextBox") {
    return QC_TEXTBOX;
  } else if (Type == "QPauliX") {
    return QC_PAULIX;
  } else if (Type == "QPauliY") {
    return QC_PAULIY;
  } else if (Type == "QPauliZ") {
    return QC_PAULIZ;
  } else if (Type == "QSwap") {
    return QC_SWAP;
  } else if (Type == "QCRot") {
    return QC_CROT;
  } else if (Type == "QNOT") {
    return QC_NOT;
  } else if (Type == "QRot") {
    return QC_ROT;
  }
  return -1;
}
//---------------------------------------------------------------------------
const char*
QCircuit::GetTypeStr(int Type) {
  switch (Type) {
  case QC_BITBOX:
    return "QBitbox";

  case QC_WALSH:
    return "QWalsh";

  case QC_CNOT:
    return "QCNot";

  case QC_CCNOT:
    return "QCCNot";

  case QC_MEASURE:
    return "QMesure";

  case QC_TEXTBOX:
    return "QTextBox";

  case QC_PAULIX:
    return "QPauliX";

  case QC_PAULIY:
    return "QPauliY";

  case QC_PAULIZ:
    return "QPauliZ";

  case QC_SWAP:
    return "QSwap";

  case QC_CROT:
    return "QCRot";
  }
  return "";
}
//---------------------------------------------------------------------------
QCircuit*
QCircuit::Create(string TypeStr, int x, int y, string Param) {

  QCircuit *qc;
  int Type = GetType(TypeStr);
  switch (Type) {

  case QC_BITBOX:
    return new QBitbox(x,y,Param);

  case QC_WALSH:
    return new QWalsh(x,y);

  case QC_MEASURE:
    return new QMeasure(x,y);

  case QC_PAULIX:
    return new QPauliX(x,y);

  case QC_PAULIY:
    return new QPauliY(x,y);

  case QC_PAULIZ:
    return new QPauliZ(x,y);

  case QC_ROT:
    return new QRot(x,y,Param);

  case QC_NOT:
    return new QNot(x, y);

  case QC_CNOT:
    return new QCNot(x,y,Param);

  case QC_CCNOT:
    return new QCCNot(x,y,Param);

  case QC_SWAP:
    return new QSwap(x,y, Param);

  case QC_CROT:
    return new QCRot(x,y, Param);
  }
  return NULL;
}
//---------------------------------------------------------------------------
string
QCircuit::GetSaveText(void) {
  ostringstream os;
  os << X << "," << Y << "," << Name << ",\""<< GetParam() << "\"";
  return os.str();
}
//---------------------------------------------------------------------------

