//---------------------------------------------------------------------------
#include "QCRot.h"
#include "StrUtils.h"
//---------------------------------------------------------------------------
QCRot::QCRot(int x,int y) :QCircuit(x,y) {
  Name = GetTypeStr();
  Target = Y;
  Phase = 0;
}
//---------------------------------------------------------------------------
QCRot::QCRot(int x,int y, string param) :QCircuit(x,y) {
  Name = GetTypeStr();
  Target = Y;
  Phase = 0;
  vector<string> v = StrUtils::split_str(param);
  Target = atoi(v[0].c_str());
  Phase = atof(v[1].c_str());
}
//---------------------------------------------------------------------------
void
QCRot::Draw(QDraw *qDraw) {
  int GridSize = qDraw->GetGridSize();
  int UnitSize = qDraw->GetUnitSize();


  int tx = X;
  int ty = Target;

  int tx1 = tx*GridSize + GridSize/2;
  int ty1 = ty*GridSize + GridSize/2;
  int tx2 = X*GridSize + GridSize/2;
  int ty2 = Y*GridSize + GridSize/2;
  qDraw->SetPenColor(clBlack);
  qDraw->DrawLine(tx1,ty1,tx2,ty2);
  qDraw->SetBrushColor(clBlack);

  qDraw->Ellipse(tx1-4,ty1-4,tx1+5,ty1+5);


  int d = (GridSize-UnitSize)/2;
  int x1 = X * GridSize+d;
  int y1 = Y * GridSize+d;
  int x2 = x1 + UnitSize;
  int y2 = y1 + UnitSize;

  qDraw->SetBrushColor(clWhite);
  qDraw->FillRect(x1,y1,x2,y2);
  qDraw->SetBrushColor(clPurple);
  qDraw->FrameRect(x1,y1,x2,y2);
  qDraw->SetPenColor(clBlack);
  qDraw->SetBrushColor(clWhite);
  ostringstream os;
  os << Phase;
  qDraw->TextOut(x1+UnitSize/2,y1+UnitSize/2, os.str());
}
//---------------------------------------------------------------------------
void
QCRot::Reverse(int y) {
  Y = y-Y;
  Target = y - Target;
}
//---------------------------------------------------------------------------
string
QCRot::GetCalcText(void) {
  ostringstream os;
  os << "CROT(";
  os << "q[" << Y << "],";
  os << "q[" << Target << "],";
  os << Phase << ")";
  return os.str();
}

//---------------------------------------------------------------------------
void
QCRot::DrawPS(QPSDraw *psDraw) {
  int GridSize = psDraw->GetGridSize();
  int UnitSize = psDraw->GetUnitSize();

  int tx = X;
  int ty = Target;

  int tx1 = tx*GridSize + GridSize/2;
  int ty1 = ty*GridSize + GridSize/2;
  int tx2 = X*GridSize + GridSize/2;
  int ty2 = Y*GridSize + GridSize/2;
  psDraw->DrawLine(tx1,ty1,tx2,ty2);
  psDraw->DrawFillCircle(tx1,ty1,4);

  int d = (GridSize-UnitSize)/2;
  int x1 = X * GridSize+d;
  int y1 = Y * GridSize+d;
  int x2 = x1 + UnitSize;
  int y2 = y1 + UnitSize;

  psDraw->FillRect(x1,y1,x2,y2);


  psDraw->FillRect(x1,y1,x2,y2);
  psDraw->FrameRect(x1,y1,x2,y2);
  ostringstream os;
  os << Phase;
  psDraw->TextOut(x1+UnitSize/2,y1+UnitSize/2,os.str());
}
//---------------------------------------------------------------------------
string
QCRot::GetParam(void) {
  ostringstream os;
  os << Target << "," << Phase;
  return os.str();
}
//---------------------------------------------------------------------------
TRect
QCRot::GetOccupiedRect() {
  TRect rc;
  rc.left = X;
  rc.right = X + 1;
  rc.top = Y;
  rc.bottom = Y + 1;
  if (Target < Y) {
    rc.top = Target;
  } else {
    rc.bottom = Target + 1;
  }
  return rc;
}
//--------------------------------------------------------------------------
QCircuit *
QCRot::Clone() {
  QCRot * qc = new QCRot(X, Y);
  qc->SetTarget(GetTarget());
  qc->SetPhase(GetPhase());
  return (QCircuit*)qc;
}
//---------------------------------------------------------------------------

