//---------------------------------------------------------------------------
//  Not gate
//---------------------------------------------------------------------------
#include "QC_not.h"
//---------------------------------------------------------------------------
/**
 * Constructor
 */
QC_not::QC_not(const int _Target) : QCalcUnit() {
    Target = _Target;
}
//---------------------------------------------------------------------------
/**
 * Calculation
 */
void QC_not::calc(int target, double BitsR[], double BitsI[], int NumberOfBits) {
    unsigned int states = (1 << (NumberOfBits - 1));
    for (unsigned int i = 0; i < states; i++) {
        unsigned int ix0 = QCalcUnit::insert1(i, target);
        unsigned int ix1 = QCalcUnit::insert0(i, target);
        swap(BitsR[ix0], BitsR[ix1]);
        swap(BitsI[ix0], BitsI[ix1]);
    }
}
//---------------------------------------------------------------------------
void
QC_not::Calc(QBits *qBits) {
    double *R = qBits->GetBitsR();//Real Part
    double *I = qBits->GetBitsI();//Imaginary Part
    int N = qBits->GetNumberOfQBits();

    QC_not::calc(Target, R, I, N);
}
//---------------------------------------------------------------------------
#ifdef __USE__MPI
void
QC_not::calcmpi(int t1, double R[], double I[], int N) {
    double r0 = 0.0;
    double i0 = 0.0;
    double r1 = 0.0;
    double i1 = 0.0;
    unsigned int ix0, ix1;

    for (int i = 0; i < (1 << (N - 1)); i++) {
        // Obtain indices of state:
        ix0 = QCalcUnit::insert0(i, t1);
        ix1 = QCalcUnit::insert1(i, t1);

        bool bstore = setup(R, I, ix0, ix1, r0, i0, r1, i1);
        if (bstore) {
            // Calc:
            swap(r0, r1);
            swap(i0, i1);
            // Store:
            store(R, I, ix0, ix1, r0, i0, r1, i1);
        }
    }
}
#endif
//---------------------------------------------------------------------------
