//---------------------------------------------------------------------------
// Controlled Rotate Gate
//---------------------------------------------------------------------------
#ifndef QC_crotH
#define QC_crotH
//---------------------------------------------------------------------------
#include "QCalcUnit.h"
#include "QBits.h"
//---------------------------------------------------------------------------

class QC_crot : public QCalcUnit
{
private:
    int ControlBit;
    int TargetBit;
    double Theta;// Degree of rotation(Radian)
public:

    QC_crot(int _TargetBit,int _ControllBit,double degree);
    static void calc(int t, int c, double theta, double R[], double I[], int N);
    virtual void Calc(QBits *QBits);
    virtual std::string GetName(void) const {
        return "Controlled Rot";
    }

#ifdef __USE__MPI
    static void calcmpi(int t1, int c1, double theta, double R[], double I[], int N);
#endif

};
//---------------------------------------------------------------------------
#endif
