// q2chwmTabView.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmTabView.h"
#include "q2chwmConfig.h"

// Cq2chwmTabView

IMPLEMENT_DYNCREATE(Cq2chwmTabView, CView)

Cq2chwmTabView::Cq2chwmTabView()
{
	m_pFont = NULL;
}

Cq2chwmTabView::~Cq2chwmTabView()
{
	if (m_pFont != NULL) delete m_pFont;
}

BEGIN_MESSAGE_MAP(Cq2chwmTabView, CView)
	ON_MESSAGE(WM_USER_TABCLICKED, OnTabClicked)
	ON_WM_SIZE()
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_NEXTTAB, &Cq2chwmTabView::OnNextTab)
	ON_COMMAND(ID_PREVTAB, &Cq2chwmTabView::OnPrevTab)
	ON_WM_SHOWWINDOW()
END_MESSAGE_MAP()


// Cq2chwmTabView `

void Cq2chwmTabView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: `R[hɒǉĂB
}


// Cq2chwmTabView ff

#ifdef _DEBUG
void Cq2chwmTabView::AssertValid() const
{
	CView::AssertValid();
}

#ifndef _WIN32_WCE
void Cq2chwmTabView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}
#endif
#endif //_DEBUG


// Cq2chwmTabView bZ[W nh

void Cq2chwmTabView::OnSize(UINT nType, int cx, int cy)
{
	CView::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	if (m_cTab.m_hWnd != NULL && m_cTab.GetItemCount() > 0) {
		hideView();
		resizeView();
	}
}

void Cq2chwmTabView::OnInitialUpdate()
{
	CView::OnInitialUpdate();

	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	m_cTab.Create(WS_BORDER|TCS_FIXEDWIDTH|TCS_BUTTONS|TCS_FLATBUTTONS, CRect(0, 0, 0, 0), this, 0);
	m_cTab.ShowWindow(SW_SHOW);
	SetFont();

	// IMEIt
	SipOff(m_hWnd);
}

void Cq2chwmTabView::SetFont()
{
	// ^ũtHgݒ
	CString cstr_name;
	cstr_name = Cq2chwmConfig::GetInstance()->GetFontNameTab();
	LOGFONT lf;
	memset(&lf, 0x00, sizeof(lf));
	_tcscpy_s(lf.lfFaceName, LF_FACESIZE, cstr_name);
	lf.lfHeight = Cq2chwmConfig::GetInstance()->GetFontSizeTab() * 10;
	lf.lfWeight = Cq2chwmConfig::GetInstance()->GetFontBoldTab() == TRUE ? FW_BOLD : FW_NORMAL;
	lf.lfCharSet = DEFAULT_CHARSET;

	if (m_pFont != NULL) delete m_pFont;
	m_pFont = new CFont();
	m_pFont->CreatePointFontIndirect(&lf);
	m_cTab.SetFont(m_pFont);

	// ^u̍ČvZ
	RECT r;
	m_cTab.AdjustRect(FALSE, &r);
	m_cTab.MoveWindow(&r, TRUE); 
	resizeView();
}

BOOL Cq2chwmTabView::AddView(
	CView *pView,
	const char *chp_name)
{
	CString cstr_name;
	cstr_name = W(chp_name);
	int in_index = m_cTab.InsertItem(m_cTab.GetItemCount(), cstr_name);
	if (in_index == -1) {
		return FALSE;
	}
	TCITEM st_item;
	st_item.mask = TCIF_PARAM;
	st_item.lParam = (LPARAM)pView;
	m_cTab.SetItem(in_index, &st_item);

	return TRUE;
}

void Cq2chwmTabView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	if (m_cTab.GetItemCount() > 0) {
		CView *pView = currentView();
		if (pView != NULL) {
			pView->SendMessage(WM_KEYDOWN, nChar, nFlags);
		}
	}

	CView::OnKeyDown(nChar, nRepCnt, nFlags);
}

BOOL Cq2chwmTabView::PreTranslateMessage(MSG* pMsg)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB

	if (pMsg->message == WM_KEYDOWN) {
		// ANeBur[gɂ
		setActiveView();
		if (Cq2chwmConfig::GetInstance()->IsKeyNextTab(pMsg->wParam)) {
			NextTab();
			return TRUE;
		} else if (Cq2chwmConfig::GetInstance()->IsKeyPrevTab(pMsg->wParam)) {
			PrevTab();
			return TRUE;
		} else if (Cq2chwmConfig::GetInstance()->IsKeyViewBack(pMsg->wParam)) {
			AfxGetMainWnd()->SendMessage(WM_USER_VIEWBACK, 0, 0);
			return TRUE;
		} else if (Cq2chwmConfig::GetInstance()->IsKeyViewForward(pMsg->wParam)) {
			AfxGetMainWnd()->SendMessage(WM_USER_VIEWFORWARD, 0, 0);
			return TRUE;
		}
	}

	return CView::PreTranslateMessage(pMsg);
}

BOOL Cq2chwmTabView::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	if (m_cTab.GetItemCount() > 0) {
		CView *pView = currentView();
		if (pView != NULL) {
			// ANeBur[gɂ
			setActiveView();
			if (pView->OnCmdMsg(nID, nCode, pExtra, pHandlerInfo) == TRUE) {
				return TRUE;
			}
		}
	}

	return CView::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

long Cq2chwmTabView::OnTabClicked(
	WPARAM wParam,
	LPARAM lParam)
{
	if (m_cTab.GetItemCount() > 0) {
		hideView();
		CView *pView = currentView();
		if (pView != NULL) {
			pView->ShowWindow(SW_SHOW);
			resizeView();
		}
	}

	return 0;
}

void Cq2chwmTabView::hideView()
{
	for (int i = 0; i < m_cTab.GetItemCount(); i++) {
		TCITEM st_item;
		st_item.mask = TCIF_PARAM;
		m_cTab.GetItem(i, &st_item);
		CView *pView = (CView*)st_item.lParam;
		pView->ShowWindow(SW_HIDE);
	}
}

void Cq2chwmTabView::resizeView()
{
	RECT st_rect;
	RECT st_rect_client;
	RECT st_rect_tab;
	int in_index = m_cTab.GetItemCount() - 1;

	GetParent()->GetWindowRect(&st_rect);
	GetClientRect(&st_rect_client);
	m_cTab.GetItemRect(in_index, &st_rect_tab);
	m_cTab.MoveWindow(0, 0, st_rect.right - st_rect.left, st_rect_tab.bottom);
	m_cTab.ShowWindow(SW_SHOW);

	CView *pView = currentView();
	if (pView != NULL) {
		pView->MoveWindow(0, st_rect_tab.bottom - 2, st_rect.right - st_rect.left, st_rect_client.bottom - st_rect_tab.bottom + 2);
		pView->ShowWindow(SW_SHOW);
	}
}

CView *Cq2chwmTabView::currentView()
{
	int in_cur = m_cTab.GetCurSel();
	if (in_cur < 0) return NULL;
	TCITEM st_item;
	st_item.mask = TCIF_PARAM;
	m_cTab.GetItem(in_cur, &st_item);
	return (CView*)st_item.lParam;
}

void Cq2chwmTabView::OnNextTab()
{
	// TODO: ɃR}h nh R[hǉ܂B
	NextTab();
}

void Cq2chwmTabView::OnPrevTab()
{
	// TODO: ɃR}h nh R[hǉ܂B
	PrevTab();
}

void Cq2chwmTabView::NextTab()
{
	if (m_cTab.GetItemCount() < 2) return;
	int in_cur = m_cTab.GetCurSel() + 1;
	if (in_cur == m_cTab.GetItemCount()) {
		in_cur = 0;
	}
	m_cTab.SetCurSel(in_cur);
	OnTabClicked(0, 0);
	::InvalidateRect(m_hWnd, NULL, TRUE);
}

void Cq2chwmTabView::PrevTab()
{
	if (m_cTab.GetItemCount() < 2) return;
	int in_cur = m_cTab.GetCurSel() - 1;
	if (in_cur < 0) {
		in_cur = m_cTab.GetItemCount() - 1;
	}
	m_cTab.SetCurSel(in_cur);
	OnTabClicked(0, 0);
	::InvalidateRect(m_hWnd, NULL, TRUE);
}

void Cq2chwmTabView::setActiveView()
{
	// ^uɊ֘AtĂr[ANeBur[ɂȂĂꍇA
	// Cq2chwmApp::changeViewsȂߐer[ł
	// gANeBur[Ƃ邱ƂKv
	CFrameWnd* pParentFrame = GetParentFrame();
	if (pParentFrame == NULL) return;
	CView *pActiveView = pParentFrame->GetActiveView();
	for (int i = 0; i < m_cTab.GetItemCount(); i++) {
		TCITEM st_item;
		st_item.mask = TCIF_PARAM;
		m_cTab.GetItem(i, &st_item);
		CView *pView = (CView*)st_item.lParam;
		if (pActiveView == pView) {
			pParentFrame->SetActiveView(this);
			return;
		}
	}
}

void Cq2chwmTabView::OnShowWindow(BOOL bShow, UINT nStatus)
{
	CView::OnShowWindow(bShow, nStatus);

	// TODO: ɃbZ[W nh R[hǉ܂B
	CView *pView = currentView();
	if (pView != NULL) {
		pView->SendMessage(WM_SHOWWINDOW, bShow);
	}
}

BOOL Cq2chwmTabView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	cs.style &= ~WS_BORDER;
	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
	return CView::PreCreateWindow(cs);
}
