// q2chwmStatusDialog.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmStatusDialog.h"
#include "q2chwmLayoutManager.h"
#include "q2chwmConfig.h"

// Cq2chwmStatusDialog _CAO

IMPLEMENT_DYNAMIC(Cq2chwmStatusDialog, CDialog)

Cq2chwmStatusDialog::Cq2chwmStatusDialog(CWnd* pParent /*=NULL*/)
	: CDialog(Cq2chwmStatusDialog::IDD, pParent)
{
}

Cq2chwmStatusDialog::~Cq2chwmStatusDialog()
{
}

void Cq2chwmStatusDialog::DoDataExchange(CDataExchange* pDX)
{
}


BEGIN_MESSAGE_MAP(Cq2chwmStatusDialog, CDialog)
	ON_WM_SIZE()
	ON_WM_SHOWWINDOW()
END_MESSAGE_MAP()


// Cq2chwmStatusDialog bZ[W nh

void Cq2chwmStatusDialog::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	Cq2chwmLayoutManager cLayout(
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_MESSAGE), 1, GetDlgItem(IDC_PROGRESS), 1)
	);
	cLayout.Layout(cx, cy);
}

void Cq2chwmStatusDialog::SetMessage(
	const char *chp_message)
{
	CStatic *pStatic = (CStatic*)GetDlgItem(IDC_STATIC_MESSAGE);
	if (pStatic != NULL) {
		CString cstr_message;
		cstr_message = chp_message;
		pStatic->SetWindowText(cstr_message);
	}
}

void Cq2chwmStatusDialog::SetProgress(
	int in_pos,
	int in_max)
{
	CProgressCtrl *pCtrl = (CProgressCtrl*)GetDlgItem(IDC_PROGRESS);
	if (pCtrl != NULL) {
		int in_per = (int)((double)((double)in_pos / (double)in_max) * 100);
		pCtrl->SetPos(in_per);
	}
}

void Cq2chwmStatusDialog::OnShowWindow(BOOL bShow, UINT nStatus)
{
	CDialog::OnShowWindow(bShow, nStatus);

	// TODO: ɃbZ[W nh R[hǉ܂B
}

void Cq2chwmStatusDialog::OnOK()
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB

	//CDialog::OnOK();
}

void Cq2chwmStatusDialog::OnCancel()
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	GetParent()->SendMessage(WM_USER_SHOWSTATUSBAR, 0, (LPARAM)FALSE);

	//CDialog::OnCancel();
}

BOOL Cq2chwmStatusDialog::PreTranslateMessage(MSG* pMsg)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	return CDialog::PreTranslateMessage(pMsg);
}
