#pragma once

#include "YoHttpClient.h"
#include "YoRegex.h"
#include "YoString.h"
#include "q2chwmCommon.h"
#include "q2chwmConfig.h"
#include "q2chwmDatFile.h"
#include "q2chwmMessage.h"

//! 2chf擾NX
/*!
 * SĂ̌fNX̊NXƂȂĂ
 */
class Cq2chwmBbs
{
private:
	CFile m_cFile;
	CYoString m_str_path;
	CYoString m_str_dir;
	CYoString m_str_aid;
	CYoString m_str_burl;
	CYoString m_str_buff;
	CYoString m_str_err;
	int m_in_recv;
	int m_in_write;
	int m_in_http_result_code;
//	BOOL m_bo_lock;

protected:
	CWnd *m_pParent;
	CYoHttpClient m_cHttp;

	int OpenFile();
	int WriteFile(const char *chp_data);
	int CloseFile();
	int OpenUrl();
	int ReadUrl(char *chp_buff, int in_len);
	int CloseUrl();
	virtual CYoString GetUrl();
	virtual int ModifyHttp();
	virtual int OpenUrlCheck();
	virtual int WriteFileConvert(CYoString &str_buff);
	virtual int DoActionInit();
	virtual int DoActionTerm(int in_ret);
	void SetErrorMessage(const char *chp_err){ m_str_err = chp_err; }

public:
	Cq2chwmBbs(CWnd *pParent, const char *chp_aid, const char *chp_burl);
	virtual ~Cq2chwmBbs();

	const char *GetErrorMessage(){ return m_str_err; }
	virtual BOOL MatchUrl();
	int DoAction();

#undef FUNC_NAME
#define FUNC_NAME		"SetLock"
//! CxgM~[ebNXbNw
/*!
 * CQ2ch::Lock()`CQ2chUnlock()ł݂͂ƂTRUE
 * pthread_createĂԏꍇ͕KTRUE
 * CXbh(processEvents܂)Ăԏꍇ́A񒆂processEventsĂ΂邱Ƃ̂ŕKFALSE
 * \param bo_lock 
 * \return void 
 */
//	void SetLock(BOOL bo_lock){ m_bo_lock = bo_lock; }

#undef FUNC_NAME
#define FUNC_NAME		"GetDir"
//! fBNg̃tpX擾
/*!
 * ex. /home/root/.navi2ch/pc10.2ch.net/mobile
 * \return char* fBNg̃tpX
 */
	virtual inline const char *GetDir(){ return m_str_dir; }

#undef FUNC_NAME
#define FUNC_NAME		"GetId"
//! fID擾
/*!
 * 1147306677
 * \return char* fID
 */
	virtual inline const char *GetArticleId(){ return m_str_aid; }

#undef FUNC_NAME
#define FUNC_NAME		"GetBaseUrl"
//! x[XURL擾
/*!
 * http://pc10.2ch.net/mobile/
 * \return char* 
 */
	virtual inline const char *GetBoardUrl(){ return m_str_burl; }

#undef FUNC_NAME
#define FUNC_NAME		"GetDatPath"
//! DATt@C̃tpX擾
/*!
 * /home/root/.navi2ch/pc10.2ch.net/mobile/1147306677.dat
 * \return char* DATt@C̃tpX
 */
	virtual inline const char *GetDatPath(){ return m_str_path; }

#undef FUNC_NAME
#define FUNC_NAME		"GetHttpResultCode"
//! HTTPR[h擾
/*!
 * OpenUrl\bhɃR[邱ƁBRg[̃G[nhOɎgpB
 * \return int 
 */
	virtual inline const int GetHttpResultCode(){ return m_in_http_result_code; }

#undef FUNC_NAME
#define FUNC_NAME		"GetWriteSize"
//! t@C݃oCg擾
/*!
 * 
 * \return int 
 */
	virtual inline const int GetWriteSize(){ return m_in_write; }
};

//! ߋO擾pNX
/*!
 * ܂Ⴀ܉ߋOȂkako/xxxx/xxxxx/xxxxxxxxxx.dat.gz݂Ȃ̂擾
 */
class Cq2chwmBbsKako : public Cq2chwmBbs
{
public:
	Cq2chwmBbsKako(CWnd *pParent, const char *chp_id, const char *chp_url);
	virtual int OpenUrlCheck();
	virtual CYoString GetUrl();
	virtual int ModifyHttp();
};

//! kߋO擾pNX
/*!
 * kĂȂߋO悤
 * kako/xxxx/xxxxx/xxxxxxxxxx.dat݂Ȃ̂擾
 */
class Cq2chwmBbsKakoPlain : public Cq2chwmBbsKako
{
public:
	Cq2chwmBbsKakoPlain(CWnd *pParent, const char *chp_id, const char *chp_url);
	virtual CYoString GetUrl();
};

//! DoLiboR2ch擾pNX
/*!
 * ZbVID擾Ădat擾s
 */
class Cq2chwmBbsDoLib : public Cq2chwmBbs
{
private:
	CYoString m_str_firstline;
	BOOL m_bo_check;
	BOOL m_bo_login;

public:
	Cq2chwmBbsDoLib(CWnd *pParent, const char *chp_id, const char *chp_url);
	virtual int OpenUrlCheck();
	virtual CYoString GetUrl();
	virtual BOOL MatchUrl();
	virtual int ModifyHttp();
	virtual int WriteFileConvert(CYoString &str_buff);
	virtual int DoActionInit();
	virtual int DoActionTerm(int in_ret);
};

//! 2ch݊SJISf擾pNX
/*!
 * be.2ch.netƂpukiwikiƂ
 */
class Cq2chwmBbsSjis : public Cq2chwmBbs
{
public:
	Cq2chwmBbsSjis(CWnd *pParent, const char *chp_id, const char *chp_url);
	virtual BOOL MatchUrl();
	virtual int WriteFileConvert(CYoString &str_buff);
};
