// q2chwmMessageDialog.cpp : t@C
//

#include "stdafx.h"
#include "YoRegex.h"
#include "MainFrm.h"
#include "q2chwm.h"
#include "q2chwmMessageDialog.h"
#include "q2chwmLayoutManager.h"
#include "q2chwmConfig.h"
#include "q2chwmCommon.h"
#include "q2chwmDoLib.h"
#include "q2chwmAsciiArt.h"
#include "q2chwmTemplateFile.h"
#include "VentUtil.h"

// Cq2chwmMessageDialog _CAO

IMPLEMENT_DYNAMIC(Cq2chwmMessageDialog, CDialog)

BOOL Cq2chwmMessageDialog::m_bo_running = FALSE;

Cq2chwmMessageDialog::Cq2chwmMessageDialog(const char *chp_aname, const char *chp_burl, const char *chp_aid, CWnd* pParent /*=NULL*/)
	: CDialog(Cq2chwmMessageDialog::IDD, pParent)
	, m_cstr_title(_T(""))
{
	m_str_aname = chp_aname;
	m_str_burl = chp_burl;
	m_str_aid = chp_aid;
	m_pFont = NULL;
	m_bo_running = FALSE;
}

Cq2chwmMessageDialog::~Cq2chwmMessageDialog()
{
	if (m_pFont != NULL) delete m_pFont;
}

void Cq2chwmMessageDialog::DoDataExchange(CDataExchange* pDX)
{
	DDX_Text(pDX, IDC_COMBO_NAME, m_cstr_name);
	DDX_Text(pDX, IDC_COMBO_MAIL, m_cstr_mail);
	DDX_Text(pDX, IDC_EDIT_MESSAGE, m_cstr_message);
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDIT_TITLE, m_cstr_title);
}


BEGIN_MESSAGE_MAP(Cq2chwmMessageDialog, CDialog)
	ON_WM_SIZE()
	ON_BN_CLICKED(IDC_CHECK_SAGE, &Cq2chwmMessageDialog::OnBnClickedCheckSage)
	ON_COMMAND(ID_MENU_CANCEL, &Cq2chwmMessageDialog::OnMenuCancel)
	ON_COMMAND(ID_MENU_OK, &Cq2chwmMessageDialog::OnMenuOk)
	ON_CBN_SELENDOK(IDC_COMBO_TEMPLATE, &Cq2chwmMessageDialog::OnCbnSelendokComboTemplate)
	ON_COMMAND(ID_MENU_COPY, &Cq2chwmMessageDialog::OnMenuCopy)
	ON_COMMAND(ID_MENU_CUT, &Cq2chwmMessageDialog::OnMenuCut)
	ON_COMMAND(ID_MENU_PASTE, &Cq2chwmMessageDialog::OnMenuPaste)
	ON_COMMAND(ID_MENU_PASTE_CITE, &Cq2chwmMessageDialog::OnMenuPasteCite)
	ON_COMMAND(ID_MENU_DELETE, &Cq2chwmMessageDialog::OnMenuDelete)
	ON_COMMAND(ID_MENU_UNDO, &Cq2chwmMessageDialog::OnMenuUndo)
	ON_COMMAND(ID_MENU_SEND_LIKE_IE, &Cq2chwmMessageDialog::OnMenuSendLikeIe)
	ON_WM_INITMENUPOPUP()
END_MESSAGE_MAP()


// Cq2chwmMessageDialog bZ[W nh

void Cq2chwmMessageDialog::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	Cq2chwmLayoutManager cLayout(
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_NAME), 1, GetDlgItem(IDC_COMBO_NAME), 4),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_MAIL), 1, GetDlgItem(IDC_COMBO_MAIL), 3, GetDlgItem(IDC_CHECK_SAGE), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_COMBO_TEMPLATE), 1),
		new Cq2chwmLayoutLine(6, GetDlgItem(IDC_EDIT_MESSAGE), 1)
	);
	cLayout.Layout(cx, cy);
}

int Cq2chwmMessageDialog::Send(
	BOOL bo_ie)			// SoftBankIEV~[gđM
{
	if (m_bo_running == TRUE) return ERR_NONE;

	if ((((Cq2chwmApp*)AfxGetApp())->GetBookmarkView()->IsRunning() == TRUE ||
		((Cq2chwmApp*)AfxGetApp())->GetDatView()->IsRunning() == TRUE) &&
		Cq2chwmConfig::GetInstance()->GetWriteChange() == TRUE &&
		Cq2chwmConfig::GetInstance()->GetConnection() != Cq2chwmConfig::GetInstance()->GetWriteConnection())
	{
		// ubN}[N[hXbh擾ɐؒfꍇ͏݋֎~
		AfxMessageBox(_T("ʐMI܂ŏ߂܂"));
		return ERR_SEND;
	}

	((CMainFrame*)AfxGetMainWnd())->SetCancel(FALSE);
	EnableControls(FALSE);
	m_bo_running = TRUE;
	// http://ex.2ch.net/goods/bbs.cgiURLBBS擾
	CYoString str_url;
	CYoString str_bbs;
	CYoString str_category;
	char *chp_sta = (char*)m_str_burl;
	char *chp_end = strchr( chp_sta+strlen("http://"), '/' );
	str_url.StrnCpy( chp_sta, chp_end-chp_sta );
	BOOL bo_use_sjis = TRUE;	//TRUEȂ瑗MɕR[hShift_JISɕϊAFALSEȂEUC-JP̂܂ܑMB
	int r = ERR_SEND;
	CYoString str_time;

	CYoRegex cRegex;
	if ( cRegex.Match( PAT_FILENAME_MACHIBBS, (const char *)m_str_burl ) >= 0 ) {
		// ܂aar
		str_url += "/bbs/write.cgi";
	} else if ( cRegex.Match( PAT_FILENAME_JBBS, (const char *)m_str_burl ) >= 0 ) {
		// JBBS
		str_url += "/bbs/write.cgi";
		// JeSRs[
		chp_sta = chp_end+1;
		chp_end = strchr( chp_sta, '/' ); 
		str_category.StrnCpy( chp_sta, chp_end - chp_sta );
		bo_use_sjis = FALSE;
	} else if ( cRegex.Match( PAT_FILENAME_LIVESOCCER, (const char *)m_str_burl ) >= 0 ) {
		// TbJ[
		str_url += "/cgi-bin/12ch/test/bbs.cgi";
		chp_end = strchr( chp_end+1, '/' ); // cgi-bin Ƃ΂
		chp_end = strchr( chp_end+1, '/' ); // 12ch Ƃ΂
	} else if ( cRegex.Match( PAT_FILENAME_LIVESOCCEREXT, (const char *)m_str_burl) >= 0) {
		// TbJ[
		str_url += "/12ch/test/bbs.cgi";
		chp_end = strchr( chp_end+1, '/' ); // 12ch Ƃ΂
	} else if (cRegex.Match(PAT_FILENAME_ANIRADI, (const char *)m_str_burl) >= 0 || // AjW
		cRegex.Match(PAT_FILENAME_CHA2, (const char *)m_str_burl) >= 0 || // `bg˂
		cRegex.Match(PAT_FILENAME_CHA2_SAKURA, (const char *)m_str_burl) >= 0 || // `bg˂
		cRegex.Match(PAT_FILENAME_JIKKYOEXT, (const char *)m_str_burl) >= 0 || // 
		cRegex.Match(PAT_FILENAME_JIKKYOEXT2, (const char *)m_str_burl) >= 0) //  by with2ch & Level3-BBS
	{
		str_url += "/cgi-bin/test/bbs.cgi";
		chp_end = strchr( chp_end+1, '/' ); // cgi-bin Ƃ΂
	} else {
		str_url += "/test/bbs.cgi";
	}
	str_bbs.StrnCpy( chp_end+1, strlen(chp_end)-2 );

	BOOL	swVent = FALSE;		//	sǂ̃tO

	if(Cq2chwmConfig::GetInstance()->GetVentControl() == TRUE){		//	s
		if(VentUtil_Initialize() == TRUE){							//	Tu[`̏
			if(VentUtil_IsInstalled() == TRUE){						//	CXg[Ă邩
				if(VentUtil_IsServiceStarted() == TRUE){			//	T[rXL
					if(VentUtil_IsEnable() == TRUE){				//	T[rXONɂȂĂ邩
						swVent = TRUE;
					}
				}
			}
		}
	}

	if(swVent){
		if(VentUtil_DoEnable(FALSE) == FALSE){			//	OFFɎs
			swVent = FALSE;								//	ȍ~̗𖳌
			VentUtil_Terminate();						//	Tu[`̌n
		}
	}

	// HTTPNCAgIuWFNg
	CYoHttpClient cHttp(str_url);
	cHttp.SetCallbackProc(CMainFrame::CallbackProc, AfxGetMainWnd());
	cHttp.SetReferer(m_str_burl);
	cHttp.AddRequestHeader("Content-Type", "application/x-www-form-urlencoded");

	// From擾
	CYoString str_from = A(m_cstr_name);
	m_str_name = str_from;
	if (bo_use_sjis == FALSE) {
		str_from.ConvertKCodeEx(CYoString::SJISTOEUC);
	}
	str_from.UrlEncode();

	// Mail擾
	CYoString str_mail = A(m_cstr_mail);
	m_str_mail = str_mail;
	if (bo_use_sjis == FALSE) {
		str_mail.ConvertKCodeEx(CYoString::SJISTOEUC);
	}
	str_mail.UrlEncode();

	// MESAGE擾
	CYoString str_message = A(m_cstr_message);
	if( str_message.Length() == 0 ){
		// {܂
		r = ERR_MESSAGE;
		goto end;
	}
	if (bo_use_sjis == FALSE) {
		str_message.ConvertKCodeEx(CYoString::SJISTOEUC);
	}
	str_message.UrlEncode();

	// TIME擾
	// bI3߂BقƂWEBT[o擾Datewb_̒ltimel𐶐B
	str_time = (int)time( NULL ) - 60*60*24*3;

	// p[^Zbg
	// XĎCq2chwmThreadDialog::SetParameterĂ΂
	SetParameter(cHttp, bo_use_sjis, m_str_burl, str_bbs, str_category, m_str_aid, str_time, str_from, str_mail, str_message);

	if (bo_ie == TRUE) {
		// IEV~[g
		cHttp.SetProxy("172.24.168.137", 8080);
		cHttp.SetUserAgent("Mozilla/4.0 (compatible; MSIE 6.0; Windows CE; IEMobile 6.12) Toshiba/X01T");
		cHttp.AddRequestHeader("Accept", "*/*");
		cHttp.AddRequestHeader("Accept-Language", "ja");
		cHttp.AddRequestHeader("UA_OS", "Windows CE (Pocket PC) - Version 5.2");
		cHttp.AddRequestHeader("UA-color", "color16");
		cHttp.AddRequestHeader("UA-Voice", "TRUE");
		cHttp.AddRequestHeader("UA-pixels", "480x800");
		cHttp.AddRequestHeader("UA-CPU", "ARM");
		cHttp.AddRequestHeader("Pragma", "no-cache");

		// IEV~[ǵAƂ
		cHttp.RemoveParameter("sid");
	} else {
		if (Cq2chwmConfig::GetInstance()->GetWriteChange() == TRUE) {
			// ݎAڑύX
			if (Cq2chwmConfig::GetInstance()->GetWriteProxyUse() == TRUE) {
				cHttp.SetProxy(Cq2chwmConfig::GetInstance()->GetWriteProxyHost(), Cq2chwmConfig::GetInstance()->GetWriteProxyPort());
				cHttp.SetProxyAuth(Cq2chwmConfig::GetInstance()->GetWriteProxyId(), Cq2chwmConfig::GetInstance()->GetWriteProxyPass() );
			}
			cHttp.SetUserAgent(Cq2chwmConfig::GetInstance()->GetWriteUserAgent());
		} else {
			if (Cq2chwmConfig::GetInstance()->GetProxyUse() == TRUE) {
				cHttp.SetProxy(Cq2chwmConfig::GetInstance()->GetProxyHost(), Cq2chwmConfig::GetInstance()->GetProxyPort());
				cHttp.SetProxyAuth(Cq2chwmConfig::GetInstance()->GetProxyId(), Cq2chwmConfig::GetInstance()->GetProxyPass() );
			}
			cHttp.SetUserAgent(Cq2chwmConfig::GetInstance()->GetUserAgent());
		}
		cHttp.AddRequestHeader( "MIME-Version", "1.0" );
	}

	int in_all = 8;
	int in_curr = 0;

	if (cRegex.Match(PAT_FILENAME_MACHIBBS, (const char *)m_str_burl) >= 0 ||
		cRegex.Match(PAT_FILENAME_JBBS, (const char *)m_str_burl) >= 0 ||
		cRegex.Match(PAT_FILENAME_LIVESOCCER, (const char *)m_str_burl) >= 0 ||
		cRegex.Match(PAT_FILENAME_LIVESOCCEREXT, (const char *)m_str_burl) >= 0 ||
		cRegex.Match(PAT_FILENAME_ANIRADI, (const char *)m_str_burl) >= 0 ||
		cRegex.Match(PAT_FILENAME_CHA2, (const char *)m_str_burl) >= 0 ||
		cRegex.Match(PAT_FILENAME_CHA2_SAKURA, (const char *)m_str_burl) >= 0 ||
		cRegex.Match(PAT_FILENAME_JIKKYOEXT, (const char *)m_str_burl) >= 0 ||
		cRegex.Match(PAT_FILENAME_JIKKYOEXT2, (const char *)m_str_burl) >= 0)
	{
		in_all = 5; // ܂BBS, JBBSȂǂł5Xebv
	}

	if( cHttp.Connect( TIMEOUT ) == FALSE ){
		r = ERR_HTTP_CONNECT;
		goto end;
	}

	if (cHttp.Post() == FALSE) {
		r = ERR_HTTP_GET;
		goto end;
	}

	if (cRegex.Match( PAT_FILENAME_MACHIBBS, (const char *)m_str_burl ) >= 0 ||
		cRegex.Match( PAT_FILENAME_JBBS, (const char *)m_str_burl ) >= 0 ||
		cRegex.Match( PAT_FILENAME_LIVESOCCER, (const char *)m_str_burl ) >= 0 ||
		cRegex.Match( PAT_FILENAME_LIVESOCCEREXT, (const char *)m_str_burl ) >= 0 ||
		cRegex.Match( PAT_FILENAME_JIKKYOEXT, (const char *)m_str_burl )>= 0 ||
		cRegex.Match( PAT_FILENAME_JIKKYOEXT2, (const char *)m_str_burl )>= 0)
	{
		if (cHttp.GetResultCode() == 302) {
			// ܂aar, JBBSł̓|Xg302Ԃă_CNg悤Ƃ炵
			r = ERR_NONE; // I
			goto end;
		} else {
			CYoString str_html;
			CYoString str_message;
			int in_ret = checkHtml(cHttp, str_html, str_message);
			if (in_ret != ERR_NONE) {
				// bZ[W\ďI
				if (str_message.Length() > 0) {
					CString cstr_message;
					cstr_message = str_message;
					AfxMessageBox(cstr_message);
				}
				r = ERR_SEND;
				goto end;
			}
			r = ERR_NONE;
			goto end;
		}
	} else if( cHttp.GetResultCode() < 200 || cHttp.GetResultCode() >= 300 ){
		r = ERR_HTTP_GET;
		goto end;
	}

	// NbL[mFy[W񂭂邱Ƃ̂10܂ŃgC
	for (int i = 0; i < 10; i++) {
		if (i > 0) {
			// 1ڂ͊POSTς݂Ȃ̂2ڈȍ~̂ݍĐڑPOST
			if (cHttp.Connect( TIMEOUT ) == FALSE) {
				r = ERR_HTTP_CONNECT;
				goto end;
			}

			if (cHttp.Post() == FALSE) {
				r = ERR_HTTP_GET;
				goto end;
			}

			if (cHttp.GetResultCode() < 200 || cHttp.GetResultCode() >= 300) {
				r = ERR_HTTP_GET;
				goto end;
			}
		}

		// MƓẽ`FbN
		CYoString str_html;
		CYoString str_message;
		int in_ret = checkHtml(cHttp, str_html, str_message);
		if (in_ret == ERR_SEND_COOKIE) {
			// <!-- 2ch_X:cookie -->݂ߍđM
			// 2POSTReferercgiURLݒ肷
			cHttp.SetReferer(str_url);

			// MK̂timep[^15bx点lɂ
			setTime(cHttp, str_html, 15);

			// NbL[t
			setCookie(cHttp);

			// {^t
			{
				CYoRegex cRegex("input type=submit value=\"([^\"]+)\" name=\"([^\"]+)\"", CYoRegex::SJIS);
				CYoString str_name;
				CYoString str_value;
				if (cRegex.Match( str_html ) >= 0) {
					str_name = cRegex.Get(2);
					if (str_name.Length() > 0) {
						str_value = cRegex.Get(1);
						str_value.UrlEncode();
						cHttp.RemoveParameter(str_name);
						cHttp.SetParameter(str_name, str_value);
					}
				}
			}

			// subjectp[^t
			{
				CYoRegex cRegex("input type=hidden name=subject value=\"([^\"]*)\"", CYoRegex::SJIS);
				if (cRegex.Match(str_html) >= 0) {
					CYoString str_value = cRegex.Get(1);
					str_value.UrlEncode();
					cHttp.RemoveParameter("subject");
					cHttp.SetParameter("subject", str_value);
				}
			}

			// getp[^t
			{
				CYoRegex cRegex("NAME=get[ ]+value=\"([^\"]+)\"", CYoRegex::SJIS);
				if (cRegex.Match((char*)str_html) >= 0) {
					// getp[^݂΃p[^tđM
					char *chp_get = cRegex.Get(1);
					cHttp.RemoveParameter("get");
					cHttp.SetParameter("get", chp_get);
				}
			}
			continue;
		} else if (in_ret == ERR_SEND) {
			// G[
			if (bo_ie == FALSE &&
				strlen(Cq2chwmConfig::GetInstance()->GetDoLibId()) > 0 &&
				strlen(Cq2chwmConfig::GetInstance()->GetDoLibPass()) > 0)
			{
				// [Û߂ɃOCgCƂĂ
				// Ȃ݂ɁASidL؂̏ꍇ́udqqnqFēxOCĂˁBBBvƂG[bZ[W
				str_message  += "\nOCナgC܂H";
				CString cstr_message;
				cstr_message = str_message;
				if (::MessageBox(m_hWnd, cstr_message, _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
					// OCナgC
					CYoString str_sid;
					if (Cq2chwmDoLib::GetSid(str_sid, Cq2chwmConfig::GetInstance()->GetDoLibId(), Cq2chwmConfig::GetInstance()->GetDoLibPass()) == FALSE) {
						// OCG[
						ErrorMessageBox(ERR_DOLIB_AUTH);
					} else {
						// OC
						Cq2chwmConfig::GetInstance()->SetDoLibSid(str_sid);
						m_bo_running = FALSE;
						r = Send();
						goto end;
					}
				}
			} else {
				// 񁜃[U̓G[bZ[W\Ă[[
				CString cstr_message;
				cstr_message = str_message;
				AfxMessageBox(cstr_message);
			}
			r = ERR_SEND;
			goto end;
		} else if (in_ret == ERR_NONE) {
			// I
			r = ERR_NONE;
			goto end;
		} else {
			// ̑̃G[
			r = in_ret;
			goto end;
		}
	}

	if (r == ERR_SEND) {
		AfxMessageBox(_T("߂܂ł"));
		r = ERR_SEND;
		goto end;
	}

	// "done"
	// AfxGetMainWnd()->SendMessage(WM_USER_SETPROGRESS, in_curr++, in_all);
end:
	if(swVent){								//	䂵Ă
		VentUtil_DoEnable(TRUE);			//	ON
		VentUtil_Terminate();				//	Tu[`̌n
	}

	EnableControls(TRUE);
	m_bo_running = FALSE;
	return r;
}

BOOL Cq2chwmMessageDialog::SetParameter(
	CYoHttpClient &cHttp,
	BOOL bo_use_sjis,
	const char *chp_burl,
	const char *chp_bbs,
	const char *chp_category,
	const char *chp_aid,
	const char *chp_time,
	const char *chp_from,
	const char *chp_mail,
	const char *chp_message)
{
	CYoRegex cRegex;
	if (cRegex.Match(PAT_FILENAME_MACHIBBS, chp_burl) >= 0) {
		// ܂aar
		cHttp.SetParameter("BBS", chp_bbs);
		cHttp.SetParameter("KEY", chp_aid);
		cHttp.SetParameter("TIME", chp_time);
		cHttp.SetParameter("NAME", chp_from);
		cHttp.SetParameter("MAIL", chp_mail);
		cHttp.SetParameter("MESSAGE", chp_message);
	} else if (cRegex.Match(PAT_FILENAME_JBBS, chp_burl) >= 0) {
		cHttp.SetParameter("DIR", chp_category);
		cHttp.SetParameter("BBS", chp_bbs);
		cHttp.SetParameter("KEY", chp_aid);
		cHttp.SetParameter("TIME", chp_time);
		cHttp.SetParameter("NAME", chp_from);
		cHttp.SetParameter("MAIL", chp_mail);
		cHttp.SetParameter("MESSAGE", chp_message);
	} else if (cRegex.Match(PAT_FILENAME_LIVESOCCER, chp_burl) >= 0 ||
		cRegex.Match(PAT_FILENAME_LIVESOCCEREXT, chp_burl) >= 0 )
	{
		// TbJ[є
		CYoString str_submit = "";
		str_submit.UrlEncode();
		cHttp.SetParameter("submit", str_submit);
		cHttp.SetParameter("bbs", chp_bbs);
		cHttp.SetParameter("key", chp_aid);
		cHttp.SetParameter("time", chp_time);
		cHttp.SetParameter("FROM", chp_from);
		cHttp.SetParameter("mail", chp_mail);
		cHttp.SetParameter("MESSAGE", chp_message);
	} else {
		CYoString str_submit = "";
		str_submit.UrlEncode();
		cHttp.SetParameter("submit", str_submit);
		cHttp.SetParameter("FROM", chp_from);
		cHttp.SetParameter("mail", chp_mail);
		cHttp.SetParameter("MESSAGE", chp_message);
		cHttp.SetParameter("bbs", chp_bbs);
		cHttp.SetParameter("time", chp_time);
		cHttp.SetParameter("key", chp_aid);
		cHttp.SetParameter("hana", "mogera");
		CYoString str_dolib_id = Cq2chwmConfig::GetInstance()->GetDoLibId();
		CYoString str_dolib_pass = Cq2chwmConfig::GetInstance()->GetDoLibPass();
		CYoString str_sid = Cq2chwmConfig::GetInstance()->GetDoLibSid();
		if (str_dolib_id.Length() > 0 && str_dolib_pass.Length() > 0 && str_sid.Length() > 0) {
			// ZbVID擾ς݂ȂZbVIDt
			str_sid.UrlEncode();
			cHttp.SetParameter("sid", str_sid);
		}
		CYoString str_cookie;
		str_cookie.Format("NAME=%s; MAIL=%s", chp_from, chp_mail);
		cHttp.SetCookie(str_cookie);
	}
	return TRUE;
}

void Cq2chwmMessageDialog::OnOK()
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	UpdateData(TRUE);
	int in_ret = Send();
	if (in_ret != ERR_NONE) {
		if (in_ret != ERR_SEND) {
			ErrorMessageBox(in_ret);
		}
		return;
	}
	m_cstr_cache_message = _T("");
	CDialog::OnOK();
}

void Cq2chwmMessageDialog::OnMenuSendLikeIe()
{
	// TODO: ɃR}h nh R[hǉ܂B
	UpdateData(TRUE);
	int in_ret = Send(TRUE);
	if (in_ret != ERR_NONE) {
		if (in_ret != ERR_SEND) {
			ErrorMessageBox(in_ret);
		}
		return;
	}
	m_cstr_cache_message = _T("");
	CDialog::OnOK();
}

BOOL Cq2chwmMessageDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ
	// WM_SIZE܂ƗȂEEE
	GetDlgItem(IDC_STATIC_TITLE)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_EDIT_TITLE)->ShowWindow(SW_HIDE);
	RECT r;
	GetClientRect(&r);
	Cq2chwmLayoutManager cLayout(
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_NAME), 1, GetDlgItem(IDC_COMBO_NAME), 4),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_MAIL), 1, GetDlgItem(IDC_COMBO_MAIL), 3, GetDlgItem(IDC_CHECK_SAGE), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_COMBO_TEMPLATE), 1),
		new Cq2chwmLayoutLine(4, GetDlgItem(IDC_EDIT_MESSAGE), 1)
	);
	cLayout.Layout(r.right - r.left, r.bottom - r.top);

	// ^Cgo[
	CString cstr_title;
	cstr_title = m_str_aname;
	SetWindowText(cstr_title);

	// OR{{bNX
	{
		CComboBox *pCombo = (CComboBox*)GetDlgItem(IDC_COMBO_NAME);
		int in_count = Cq2chwmConfig::GetInstance()->GetHistoryNameCount();
		if (in_count > 0) pCombo->AddString(_T(""));
		for (int i = 0; i < in_count; i++) {
			CString cstr_value;
			cstr_value = Cq2chwmConfig::GetInstance()->GetHistoryName(i);
			pCombo->AddString(cstr_value);
		}
	}

	// [R{{bNX
	{
		CComboBox *pCombo = (CComboBox*)GetDlgItem(IDC_COMBO_MAIL);
		int in_count = Cq2chwmConfig::GetInstance()->GetHistoryMailCount();
		if (in_count > 0) pCombo->AddString(_T(""));
		for (int i = 0; i < in_count; i++) {
			CString cstr_value;
			cstr_value = Cq2chwmConfig::GetInstance()->GetHistoryMail(i);
			pCombo->AddString(cstr_value);
		}
	}

	// ^
	{
		CComboBox *pCombo = (CComboBox*)GetDlgItem(IDC_COMBO_TEMPLATE);
		if (Cq2chwmConfig::GetInstance()->GetUseDefaultTemplate() == TRUE) {
			for (int i = 0; i < sizeof(chpa_art)/sizeof(chpa_art[0]); i++) {
				CString cstr_value;
				cstr_value = chpa_art[i];
				pCombo->InsertString(i, cstr_value);
			}
		}

		// [U`
		for (int i = 0; i < Cq2chwmTemplateFile::GetInstance()->Rows(); i++) {
			CString cstr_value;
			cstr_value = Cq2chwmTemplateFile::GetInstance()->GetTemplate(i);
			pCombo->InsertString(i, cstr_value);
		}
	}

	// tHg
	SetFont();

	m_cstr_name = m_cstr_cache_name;
	m_cstr_mail = m_cstr_cache_mail;
	m_cstr_message = m_cstr_cache_message;
	if (m_cstr_mail.GetLength() == 0 && Cq2chwmConfig::GetInstance()->GetSage() == TRUE) {
		((CButton*)GetDlgItem(IDC_CHECK_SAGE))->SetCheck(TRUE);
		m_cstr_mail = "sage";
	}
	UpdateData(FALSE);

	// J[\I[ֈړ
	CEdit *pEdit = (CEdit*)GetDlgItem(IDC_EDIT_MESSAGE);
	pEdit->SetSel(m_cstr_message.GetLength(), m_cstr_message.GetLength());

#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
	if (!m_wndCommandBar.Create(this) ||
	    !m_wndCommandBar.InsertMenuBar(IDR_MENU_MESSAGE) ||
	    !m_wndCommandBar.AddAdornments())
	{
		TRACE0("CommandBar ̍쐬Ɏs܂\n");
		return FALSE;
	}
	m_wndCommandBar.SetBarStyle(m_wndCommandBar.GetBarStyle() | CBRS_SIZE_FIXED);
#else
	m_cMenu.LoadMenu(IDR_MENU_MESSAGE);
	SetMenu(&m_cMenu);
#endif // WIN32_PLATFORM_PSPC

	// ҏWXɃtH[JX
	if (Cq2chwmConfig::GetInstance()->GetFocusOnMessage() == TRUE) {
		pEdit->SetFocus();
		return FALSE;
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void Cq2chwmMessageDialog::OnCancel()
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	if (m_bo_running == TRUE) {
		if (::MessageBox(m_hWnd, _T("LZ܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
			((CMainFrame*)AfxGetMainWnd())->SetCancel(TRUE);
		}
	} else {
		UpdateData(TRUE);
		m_cstr_cache_name = m_cstr_name;
		m_cstr_cache_mail = m_cstr_mail;
		m_cstr_cache_message = m_cstr_message;
		CDialog::OnCancel();
	}
}

void Cq2chwmMessageDialog::SetName(
	const char *chp_name)
{
	m_cstr_cache_name = chp_name;
}

void Cq2chwmMessageDialog::SetMail(
	const char *chp_mail)
{
	m_cstr_cache_mail = chp_mail;
}

void Cq2chwmMessageDialog::SetMessage(
	const char *chp_text)
{
	if (m_cstr_cache_message.GetLength() > 0) m_cstr_cache_message += _T("\r\n");
	m_cstr_cache_message += chp_text;
	if (*(chp_text + strlen(chp_text) - 1) != '\n') {
		m_cstr_cache_message += "\r\n";
	}
}

void Cq2chwmMessageDialog::OnBnClickedCheckSage()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	CButton *pButton = (CButton*)GetDlgItem(IDC_CHECK_SAGE);
	CComboBox *pCombo = (CComboBox*)GetDlgItem(IDC_COMBO_MAIL);
	if (pButton->GetCheck() == BST_CHECKED) {
		pCombo->SetWindowText(_T("sage"));
	} else {
		CString cstr_text;
		pCombo->GetWindowText(cstr_text);
		if (cstr_text == "sage") {
			pCombo->SetWindowText(_T(""));
		}
	}
}

void Cq2chwmMessageDialog::SetFont()
{
	CString cstr_name;
	cstr_name = Cq2chwmConfig::GetInstance()->GetFontNameMessage();
	LOGFONT lf;
	memset(&lf, 0x00, sizeof(lf));
	_tcscpy_s(lf.lfFaceName, LF_FACESIZE, cstr_name);
	lf.lfHeight = Cq2chwmConfig::GetInstance()->GetFontSizeMessage() * 10;
	lf.lfWeight = Cq2chwmConfig::GetInstance()->GetFontBoldMessage() == TRUE ? FW_BOLD : FW_NORMAL;
	lf.lfCharSet = DEFAULT_CHARSET;

	if (m_pFont != NULL) delete m_pFont;
	m_pFont = new CFont();
	m_pFont->CreatePointFontIndirect(&lf);
	CWnd::SetFont(m_pFont);

	int ina_id[] = {IDC_STATIC_NAME, IDC_COMBO_NAME, IDC_STATIC_MAIL, IDC_COMBO_MAIL, IDC_CHECK_SAGE, IDC_COMBO_TEMPLATE, IDC_EDIT_MESSAGE};
	for (int i = 0; i < sizeof(ina_id)/sizeof(ina_id[0]); i++) {
		GetDlgItem(ina_id[i])->SetFont(m_pFont);
	}
}

void Cq2chwmMessageDialog::OnMenuCancel()
{
	// TODO: ɃR}h nh R[hǉ܂B
	OnCancel();
}

void Cq2chwmMessageDialog::OnMenuOk()
{
	// TODO: ɃR}h nh R[hǉ܂B
	OnOK();
}

void Cq2chwmMessageDialog::OnCbnSelendokComboTemplate()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	CComboBox *pCombo = (CComboBox*)GetDlgItem(IDC_COMBO_TEMPLATE);
	CEdit *pEdit = (CEdit*)GetDlgItem(IDC_EDIT_MESSAGE);
	CString cstr_text;
	pCombo->GetLBText(pCombo->GetCurSel(), cstr_text);
	cstr_text.Replace(_T("\\n"), _T("\r\n"));
	pEdit->ReplaceSel(cstr_text, TRUE);
}

void Cq2chwmMessageDialog::OnMenuCopy()
{
	// TODO: ɃR}h nh R[hǉ܂B
	GetFocus()->SendMessage(WM_COPY);
}

void Cq2chwmMessageDialog::OnMenuCut()
{
	// TODO: ɃR}h nh R[hǉ܂B
	GetFocus()->SendMessage(WM_CUT);
}

void Cq2chwmMessageDialog::OnMenuPaste()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CString cstr_text;
	if (GetClipBoardText(m_hWnd, cstr_text) == FALSE) {
		return;
	}
	CString cstr_code;
	if (cstr_text.Find(_T("\r\n")) >= 0) {
		// sR[ĥ܂
		;
	} else if (cstr_text.Find(_T("\n")) >= 0) {
		// sR[h\r\nɕϊ
		cstr_text.Replace(_T("\n"), _T("\r\n"));
	}

	// CEdit̃|C^擾
	wchar_t szClassName[256];
	::GetClassName(GetFocus()->m_hWnd, szClassName, 256);
	CEdit *pEdit = NULL;
	if (_tcscmp(szClassName, _T("Edit")) == 0) {
		pEdit = (CEdit*)GetFocus();
	} else if (_tcscmp(szClassName, _T("ComboBox")) == 0) {
		pEdit = (CEdit*)GetFocus()->GetWindow(GW_CHILD);
	}
	if (pEdit != NULL) pEdit->ReplaceSel(cstr_text, TRUE);
}

void Cq2chwmMessageDialog::OnMenuPasteCite()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CString cstr_text;
	if (GetClipBoardText(m_hWnd, cstr_text) == FALSE) {
		return;
	}
	CString cstr_code;
	if (cstr_text.Find(_T("\r\n")) >= 0) {
		cstr_code = _T("\r\n");
	} else if (cstr_text.Find(_T("\n")) >= 0) {
		cstr_code = _T("\n");
	}

	// pLt
	cstr_text.Insert(0, _T('>'));
	if (cstr_code.GetLength() > 0) {
		cstr_text.Replace(cstr_code, _T("\r\n>"));
		if (cstr_text[cstr_text.GetLength() - 1] == _T('>')) {
			cstr_text.Delete(cstr_text.GetLength() - 1);
		}
	}

	// CEdit̃|C^擾
	wchar_t szClassName[256];
	::GetClassName(GetFocus()->m_hWnd, szClassName, 256);
	CEdit *pEdit = NULL;
	if (_tcscmp(szClassName, _T("Edit")) == 0) {
		pEdit = (CEdit*)GetFocus();
	} else if (_tcscmp(szClassName, _T("ComboBox")) == 0) {
		pEdit = (CEdit*)GetFocus()->GetWindow(GW_CHILD);
	}
	if (pEdit != NULL) pEdit->ReplaceSel(cstr_text, TRUE);
}

void Cq2chwmMessageDialog::OnMenuDelete()
{
	// TODO: ɃR}h nh R[hǉ܂B
	GetFocus()->SendMessage(EM_REPLACESEL, TRUE, (LPARAM)_T(""));
}

void Cq2chwmMessageDialog::OnMenuUndo()
{
	// TODO: ɃR}h nh R[hǉ܂B
	if (GetFocus() == GetDlgItem(IDC_COMBO_TEMPLATE)) {
		// tH[JX^R{{bNXȂ烁bZ[WGfBbg{bNXɖ߂
		GetDlgItem(IDC_EDIT_MESSAGE)->SendMessage(EM_UNDO);
	} else {
		GetFocus()->SendMessage(EM_UNDO);
	}
}

void Cq2chwmMessageDialog::setTime(
	CYoHttpClient &cHttp,
	CYoString &str_html,
	int in_sec)
{
	CYoString str_time;
	CYoRegex cRegex("[Nn][Aa][Mm][Ee]=time[ ]+[Vv][Aa][Ll][Uu][Ee]=([0-9]+)", CYoRegex::SJIS);
	if (cRegex.Match(str_html) >= 0) {
		str_time = atoi(cRegex.Get(1)) - in_sec;
	} else {
		str_time = (int)time(NULL) - 60*60*24*3;
	}
	cHttp.RemoveParameter("time");
	cHttp.SetParameter("time", str_time);
}

void Cq2chwmMessageDialog::setCookie(
	CYoHttpClient &cHttp)
{
	CYoRegex cRegex("(.+?);");
	CYoString str_cookie;
	int i = 0;
	while (1) {
		CYoString str_val = cHttp.GetResponseHeader("Set-Cookie", i);
		if (str_val.Length() == 0) {
			if (str_cookie.Length() > 0) {
				// Ṓu; v폜
				str_cookie.Remove(str_cookie.Length() - 2);
			}
			break;
		} else {
			// NbL[擾
			if (cRegex.Match(str_val) >= 0) {
				str_cookie.FormatAdd("%s; ", cRegex.Get(1));
			}
		}
		i++;
	}
	if (str_cookie.Length() > 0) {
		cHttp.ClearCookie();
		cHttp.SetCookie(str_cookie);
	}
}

/*
 * ݊HTML̃`FbN.
 * \return `FbNOK: ERR_NONE Ō̑MȂ: ERR_SEND_COOKIE G[: ERR_SEND
 */
int Cq2chwmMessageDialog::checkHtml(
	CYoHttpClient &cHttp,		// POSTς݂HTTPNCAg
	CYoString &str_html,
	CYoString &str_message)		// G[bZ[W܂
{
	// ݊mFy[W擾
	{
		int in_len;
		char cha_buff[RECV_BUFF];
		while ((in_len = cHttp.Recv(cha_buff, sizeof(cha_buff) - 1)) > 0) {
			cha_buff[in_len] = 0x00;
			str_html += cha_buff;
		}
		if (in_len == SOCKET_ERROR) {
			return ERR_HTTP_RECV;
		}
		if (in_len == 0 && ((CMainFrame*)AfxGetMainWnd())->Canceled() == TRUE) {
			return ERR_CANCELED;
		}
		PRINTLOG("DONE: [%s]", (const char*)str_html);
	}

	if (str_html.Find("<!-- 2ch_X:cookie -->") >= 0) {
		// XĂ͏݊mF2񂭂Ƃ悤
		return ERR_SEND_COOKIE;
	}

	{
		CYoRegex cRegex;
		if (cRegex.Match(PAT_FILENAME_JBBS, (const char *)m_str_burl) >= 0) {
			str_html.ConvertKCodeEx(CYoString::EUCTOSJIS);
		}
	}

	{
		CYoRegex cRegex;
		if (cRegex.Match(PAT_FILENAME_BE2CH, (const char *)m_str_burl) >= 0) {
			str_html.ConvertKCodeEx(CYoString::EUCTOSJIS);
		}
	}

	// ^Cg\
	/*
	{
		CYoRegex cRegex("<title>([^<]+)</title>", CYoRegex::SJIS);
		if (cRegex.Match(str_html) >= 0) {
			CYoString str_message = cRegex.Get(1);
			if (str_message != "݂܂B") {
				CString cstr_message;
				cstr_message = str_message;
				AfxMessageBox(cstr_message);
			}
		}
	}
	*/

	if (str_html.Find("<!-- 2ch_X:error -->") >= 0 ||
		str_html.Find("<title>Error</title>") >= 0 ||
		str_html.Find("<title>dqqnqI</title>") >= 0)
	{
		// G[̎<!-- 2ch_X:error -->܂܂ĂāA<b>`</b>ɃG[bZ[WZbgĂ悤
		// ܂BBSł <title>dqqnqI</title>
		CYoRegex cRegex("<b>([^<]+)", CYoRegex::SJIS);
		if (cRegex.Match((char*)str_html) >= 0) {
			str_message = cRegex.Get(1);
		} else {
			CYoRegex cRegex("<font color=red>([^<]+)", CYoRegex::SJIS);
			if (cRegex.Match((char*)str_html) >= 0) {
				str_message = cRegex.Get(1);
			} else {
				str_message = "߂܂ł";
			}
		}
		return ERR_SEND;
	}

	return ERR_NONE;
}

void Cq2chwmMessageDialog::EnableControls(
	BOOL bo_enable)
{
	GetDlgItem(IDC_STATIC_NAME)->EnableWindow(bo_enable);
	GetDlgItem(IDC_COMBO_NAME)->EnableWindow(bo_enable);
	GetDlgItem(IDC_STATIC_MAIL)->EnableWindow(bo_enable);
	GetDlgItem(IDC_COMBO_MAIL)->EnableWindow(bo_enable);
	GetDlgItem(IDC_CHECK_SAGE)->EnableWindow(bo_enable);
	GetDlgItem(IDC_COMBO_TEMPLATE)->EnableWindow(bo_enable);
	GetDlgItem(IDC_EDIT_MESSAGE)->EnableWindow(bo_enable);
}

void Cq2chwmMessageDialog::OnInitMenuPopup(CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu)
{
	CDialog::OnInitMenuPopup(pPopupMenu, nIndex, bSysMenu);

	// TODO: ɃbZ[W nh R[hǉ܂B
#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
#else
	pPopupMenu->EnableMenuItem(ID_MENU_SEND_LIKE_IE, MF_GRAYED);
#endif
}
