// q2chwmJumpDialog.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmJumpDialog.h"
#include "q2chwmLayoutManager.h"
#include "q2chwmConfig.h"

// Cq2chwmJumpDialog _CAO

IMPLEMENT_DYNAMIC(Cq2chwmJumpDialog, CDialog)

Cq2chwmJumpDialog::Cq2chwmJumpDialog(CWnd* pParent /*=NULL*/)
	: CDialog(Cq2chwmJumpDialog::IDD, pParent)
	, m_cstr_jump(_T(""))
{

}

Cq2chwmJumpDialog::~Cq2chwmJumpDialog()
{
}

void Cq2chwmJumpDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_CBString(pDX, IDC_COMBO_JUMP, m_cstr_jump);
}


BEGIN_MESSAGE_MAP(Cq2chwmJumpDialog, CDialog)
	ON_WM_SIZE()
	ON_BN_CLICKED(IDC_BUTTON_CLOSE, &Cq2chwmJumpDialog::OnBnClickedButtonClose)
	ON_BN_CLICKED(IDC_BUTTON_EXEC, &Cq2chwmJumpDialog::OnBnClickedButtonExec)
	ON_WM_SHOWWINDOW()
END_MESSAGE_MAP()


// Cq2chwmJumpDialog bZ[W nh

void Cq2chwmJumpDialog::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	if (m_cButtonExec.m_hWnd != NULL) {
		Cq2chwmLayoutManager cLayout(
			new Cq2chwmLayoutLine(GetDlgItem(IDC_COMBO_JUMP), 5, &m_cButtonExec, 1, &m_cButtonClose, 1)
		);
		cLayout.Layout(cx, cy);
	}
}

BOOL Cq2chwmJumpDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ
	// Zbg
	ReloadHistory();

	RECT r;
	CComboBox *pCombo = (CComboBox*)GetDlgItem(IDC_COMBO_JUMP);
	pCombo->GetWindowRect(&r);
	int in_buttonsize = r.bottom - r.top;
	int in_iconsize = in_buttonsize < 32 ? 16 : 32;
	if (m_cButtonExec.Create(IDI_ICON_EXEC, in_iconsize, in_iconsize, CRect(0, 0, in_buttonsize, in_buttonsize), this, IDC_BUTTON_EXEC) == FALSE ||
		m_cButtonClose.Create(IDI_ICON_CLOSE, in_iconsize, in_iconsize, CRect(0, 0, in_buttonsize, in_buttonsize), this, IDC_BUTTON_CLOSE) == FALSE)
	{
		return FALSE;
	}
	m_cButtonExec.ShowWindow(SW_SHOW);
	m_cButtonClose.ShowWindow(SW_SHOW);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void Cq2chwmJumpDialog::OnBnClickedButtonClose()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	OnCancel();
}

void Cq2chwmJumpDialog::OnBnClickedButtonExec()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	UpdateData(TRUE);
	if (m_cstr_jump.GetLength() > 0) {
		CYoString str_jump = A(m_cstr_jump);
		GetParent()->SendMessage(WM_USER_EXECJUMP, 0, (LPARAM)(const char*)str_jump);
	}
}

void Cq2chwmJumpDialog::OnCancel()
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	GetParent()->SendMessage(WM_USER_SHOWJUMPBAR, 0, (LPARAM)FALSE);

	//CDialog::OnCancel();
}

void Cq2chwmJumpDialog::OnOK()
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	OnBnClickedButtonExec();

	//CDialog::OnOK();
}

void Cq2chwmJumpDialog::ReloadHistory()
{
	CComboBox *pCombo = (CComboBox*)GetDlgItem(IDC_COMBO_JUMP);
	pCombo->ResetContent();
	for (int i = 0; i < Cq2chwmConfig::GetInstance()->GetHistoryJumpCount(); i++) {
		CString cstr_value;
		cstr_value = Cq2chwmConfig::GetInstance()->GetHistoryJump(i);
		pCombo->InsertString(i, cstr_value);
		if (i == 0) pCombo->SetWindowText(cstr_value);
	}
}

void Cq2chwmJumpDialog::SetFocus()
{
	GetDlgItem(IDC_COMBO_JUMP)->SetFocus();
}
