#pragma once

#include "YoString.h"
#include "YoRegex.h"
#include "YoTable.h"
#include "q2chwmCommon.h"
#include "q2chwmBookmarkItem.h"

//! ubN}[Nt@CǗNX
/*!
 * 
 */
class Cq2chwmBookmarkFile : public CYoPtrArray
{
public:
	enum {
		IDX_INDEX = 0,
		IDX_COUNT,
		IDX_ANAME,
		IDX_COUNTPERDAY,
		IDX_BNAME,
		IDX_AID,
		IDX_NEW,
		IDX_SEARCH,
	};

private:
	CYoRegex *m_pRegex;
	CYoString m_str_filename;
	int m_in_sort_column;
	BOOL m_bo_sort_asc;

private:
	static int compAsc(const void *vop_user, const void *a, const void *b);
	static int compDesc(const void *vop_user, const void *a, const void *b);
	Cq2chwmBookmarkFile();
	static void Delete();

public:
	static Cq2chwmBookmarkFile *m_pInstance;
	static Cq2chwmBookmarkFile *GetInstance();
//	CQ2chBookmarkFile( const char *chp_file, int in_mode = IO_ReadOnly, BOOL bo_store = FALSE );
	~Cq2chwmBookmarkFile();

	BOOL Create(const char *chp_filename);
	BOOL AddBookmark(const char *chp_aname, const char *chp_aid,
		const char *chp_bname, const char *chp_bid, const char *chp_burl);
	int Write();

	void SetArticleName(int in_index, const char *chp_aname);
	void SetCount(int in_index, int in_count, int in_count_new);

	int Search(const char *chp_aurl);
	void Sort(int in_col, BOOL bo_asc);
	Cq2chwmBookmarkItem *GetItem(int in_index){ return (Cq2chwmBookmarkItem*)Get(in_index); }
	void RemoveAll();
	void Remove(int in_pos);
	BOOL Replace(const char *chp_burl_old, const char *chp_burl_new);
};
