#include "stdafx.h"
#include "YoFile.h"
#include "q2chwmCommon.h"
#include "q2chwmConfig.h"
#include "q2chwmNgFile.h"

Cq2chwmNgFile::Cq2chwmNgFile()
	: m_cRegex("^(.*)\t+(.*)$", CYoRegex::SJIS, TRUE)
{
}

Cq2chwmNgFile::~Cq2chwmNgFile()
{
}

Cq2chwmNgFile *Cq2chwmNgFile::m_pInstance = NULL;
Cq2chwmNgFile *Cq2chwmNgFile::GetInstance()
{
	if (m_pInstance == NULL) {
		m_pInstance = new Cq2chwmNgFile();
		m_pInstance->Create();
		atexit(Cq2chwmNgFile::Delete);
	}

	return m_pInstance;
}

BOOL Cq2chwmNgFile::Create()
{
	// ngword.txt̃pXinit@C̃pXɐ
	CYoString str_filename = Cq2chwmConfig::GetInstance()->GetRootDirectory();
	str_filename += "\\ngword.txt";

	CYoTextFile cFile(str_filename, CYoFile::READ);
	if (cFile.Open() == FALSE) {
		return FALSE;
	}

	RemoveAll();
	CYoString str_line;
	while (cFile.Eof() == FALSE) {
		cFile.ReadLine(str_line);
		if (m_cRegex.Match(str_line) >= 0) {
			CYoString str_ng = m_cRegex.Get(2);
			char *chp_tmp = str_ng;
			while (*(chp_tmp + strlen(chp_tmp) - 1) == '\r' ||
				*(chp_tmp + strlen(chp_tmp) - 1) == '\n')
			{
				*(chp_tmp + strlen(chp_tmp) - 1) = 0x00;
			}
			Add((const char*)m_cRegex.Get(1), (const char*)str_ng, NULL);
		}
	}
	cFile.Close();
	
	return TRUE;
}

void Cq2chwmNgFile::Delete()
{
	if (m_pInstance != NULL) {
		delete m_pInstance;
		m_pInstance = NULL;
	}
}

BOOL Cq2chwmNgFile::Write()
{
	CYoString str_filename = Cq2chwmConfig::GetInstance()->GetRootDirectory();
	str_filename += "\\ngword.txt";

	CYoTextFile cFile(str_filename, CYoFile::WRITE);
	if (cFile.Open() == FALSE) {
		return FALSE;
	}

	for (int i = 0; i < Rows(); i++) {
		CYoString str_line;
		str_line.Format("%s\t%s\r\n", Get(i, 0), Get(i, 1));
		cFile.Write(str_line);
	}
	cFile.Close();
	return TRUE;
}

CYoString Cq2chwmNgFile::GetPattern(
	const char *chp_burl,
	const char *chp_aid)
{
	if (chp_burl == NULL || chp_aid == NULL) {
		return CYoString();
	}

	// URL(http://pc10.2ch.net/mobile/1234567890)
	CYoString str_url;
	if (*(chp_burl + strlen(chp_burl) - 1) == '/') {
		str_url = chp_burl;
		str_url += chp_aid;
	} else {
		str_url = chp_burl;
		str_url += '/';
		str_url += chp_aid;
	}

	CYoString str_ret;
	for (int i = 0; i < Rows(); i++) {
		const char *chp_pat_url = Get(i, 0);
		const char *chp_pat_word = Get(i, 1);
		CYoRegex cRegexUrl(chp_pat_url, CYoRegex::SJIS, TRUE);
		if (*chp_pat_url == 0x00 ||
			cRegexUrl.Match(str_url) >= 0)
		{
			str_ret += chp_pat_word;
			str_ret += "|";
		}
	}

	// I[|폜
	if (str_ret.Length() > 0) {
		str_ret = str_ret.Left(str_ret.Length() - 1);
	}

	return str_ret;
}
