// q2chwmBookmarkView.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmBookmarkView.h"
#include "q2chwmBbsManager.h"
#include "q2chwmConfig.h"
#include "q2chwmCommon.h"
#include "q2chwmInfoFile.h"
#include "MainFrm.h"

// Cq2chwmBookmarkView

//IMPLEMENT_DYNCREATE(Cq2chwmBookmarkView, Cq2chwmListView)

Cq2chwmBookmarkView::Cq2chwmBookmarkView()
{
	m_bo_running = FALSE;
	m_bo_create = FALSE;
	m_pThread = NULL;
	m_bo_multiselect = FALSE;
}

Cq2chwmBookmarkView::~Cq2chwmBookmarkView()
{
	if (m_pThread != NULL) m_pThread->Delete();
}

BEGIN_MESSAGE_MAP(Cq2chwmBookmarkView, Cq2chwmListView)
	ON_WM_SIZE()
	ON_WM_KEYDOWN()
	ON_WM_DESTROY()
	ON_COMMAND(ID_RELOAD, &Cq2chwmBookmarkView::OnReload)
	ON_COMMAND(ID_DELETE, &Cq2chwmBookmarkView::OnDelete)
	ON_COMMAND(ID_SORT_AID, &Cq2chwmBookmarkView::OnSortArticleId)
	ON_UPDATE_COMMAND_UI(ID_SORT_AID, &Cq2chwmBookmarkView::OnUpdateSortArticleId)
	ON_COMMAND(ID_SORT_ANAME, &Cq2chwmBookmarkView::OnSortArticleName)
	ON_UPDATE_COMMAND_UI(ID_SORT_ANAME, &Cq2chwmBookmarkView::OnUpdateSortArticleName)
	ON_COMMAND(ID_SORT_BNAME, &Cq2chwmBookmarkView::OnSortBoardName)
	ON_UPDATE_COMMAND_UI(ID_SORT_BNAME, &Cq2chwmBookmarkView::OnUpdateSortBoardName)
	ON_COMMAND(ID_SORT_COUNT, &Cq2chwmBookmarkView::OnSortCount)
	ON_UPDATE_COMMAND_UI(ID_SORT_COUNT, &Cq2chwmBookmarkView::OnUpdateSortCount)
	ON_COMMAND(ID_SORT_INDEX, &Cq2chwmBookmarkView::OnSortIndex)
	ON_UPDATE_COMMAND_UI(ID_SORT_INDEX, &Cq2chwmBookmarkView::OnUpdateSortIndex)
	ON_COMMAND(ID_SORT_NEW, &Cq2chwmBookmarkView::OnSortNew)
	ON_UPDATE_COMMAND_UI(ID_SORT_NEW, &Cq2chwmBookmarkView::OnUpdateSortNew)
	ON_COMMAND(ID_SORT_SEARCH, &Cq2chwmBookmarkView::OnSortSearch)
	ON_UPDATE_COMMAND_UI(ID_SORT_SEARCH, &Cq2chwmBookmarkView::OnUpdateSortSearch)
	ON_WM_SHOWWINDOW()
	ON_COMMAND(ID_ADJUST_COLUMN_WIDTH, &Cq2chwmBookmarkView::OnAdjustColumnWidth)
	ON_COMMAND(ID_SORT_COUNTPERDAY, &Cq2chwmBookmarkView::OnSortCountPerDay)
	ON_UPDATE_COMMAND_UI(ID_SORT_COUNTPERDAY, &Cq2chwmBookmarkView::OnUpdateSortCountPerDay)
	ON_COMMAND(ID_MULTISELECT, &Cq2chwmBookmarkView::OnMultiSelect)
	ON_UPDATE_COMMAND_UI(ID_MULTISELECT, &Cq2chwmBookmarkView::OnUpdateMultiSelect)
END_MESSAGE_MAP()

// Cq2chwmBookmarkView ff

#ifdef _DEBUG
void Cq2chwmBookmarkView::AssertValid() const
{
	Cq2chwmListView::AssertValid();
}

#ifndef _WIN32_WCE
void Cq2chwmBookmarkView::Dump(CDumpContext& dc) const
{
	Cq2chwmListView::Dump(dc);
}
#endif
#endif //_DEBUG


// Cq2chwmBookmarkView bZ[W nh
void Cq2chwmBookmarkView::clearList()
{
	Cq2chwmBookmarkFile::GetInstance()->RemoveAll();
}

BOOL Cq2chwmBookmarkView::CreateFromFile()
{
	if (m_bo_create == TRUE) return TRUE;
	CYoString str_filename = Cq2chwmConfig::GetInstance()->GetRootDirectory();
	str_filename += "\\bookmark2.txt";
	Cq2chwmBookmarkFile::GetInstance()->Create(str_filename);
	GetListCtrl().SetItemCountEx(Cq2chwmBookmarkFile::GetInstance()->Count());
	SortItems(Cq2chwmConfig::GetInstance()->GetSortColumnBookmark(),
		Cq2chwmConfig::GetInstance()->GetSortAscBookmark());
	GoTop();
	m_bo_create = TRUE;
	return TRUE;
}

void Cq2chwmBookmarkView::SetFont()
{
	Cq2chwmListView::SetFont(Cq2chwmConfig::GetInstance()->GetFontNameBookmark(),
		Cq2chwmConfig::GetInstance()->GetFontSizeBookmark(), Cq2chwmConfig::GetInstance()->GetFontBoldBookmark());
}

void Cq2chwmBookmarkView::OnInitialUpdate()
{
	Cq2chwmListView::OnInitialUpdate();

	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	GetListCtrl().InsertColumn(0, _T("No"));
	GetListCtrl().InsertColumn(1, _T("X"));
	GetListCtrl().InsertColumn(2, _T("Xbh"));
	GetListCtrl().InsertColumn(3, _T(""));
	GetListCtrl().InsertColumn(4, _T(""));
	GetListCtrl().InsertColumn(5, _T("XbhID"));
	GetListCtrl().SetColumnWidth(0, Cq2chwmConfig::GetInstance()->GetColumnWidthBookmark(0) == 0 ? 50 :
		Cq2chwmConfig::GetInstance()->GetColumnWidthBookmark(0));
	GetListCtrl().SetColumnWidth(1, Cq2chwmConfig::GetInstance()->GetColumnWidthBookmark(1) == 0 ? 50 :
		Cq2chwmConfig::GetInstance()->GetColumnWidthBookmark(1));
	GetListCtrl().SetColumnWidth(2, Cq2chwmConfig::GetInstance()->GetColumnWidthBookmark(2) == 0 ? 300 :
		Cq2chwmConfig::GetInstance()->GetColumnWidthBookmark(2));
	GetListCtrl().SetColumnWidth(3, Cq2chwmConfig::GetInstance()->GetColumnWidthBookmark(3) == 0 ? 50 :
		Cq2chwmConfig::GetInstance()->GetColumnWidthBookmark(3));
	GetListCtrl().SetColumnWidth(4, Cq2chwmConfig::GetInstance()->GetColumnWidthBookmark(4) == 0 ? 100 :
		Cq2chwmConfig::GetInstance()->GetColumnWidthBookmark(4));
	GetListCtrl().SetColumnWidth(5, Cq2chwmConfig::GetInstance()->GetColumnWidthBookmark(5) == 0 ? 100 :
		Cq2chwmConfig::GetInstance()->GetColumnWidthBookmark(5));
	SetFont();
}

void Cq2chwmBookmarkView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	if (Cq2chwmConfig::GetInstance()->IsKeyReload(nChar)) {
		OnReload();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeySort(nChar)) {
		Sort();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeySearch(nChar)) {
		GetParent()->SendMessage(WM_USER_SHOWSEARCHBAR, 0, (LPARAM)TRUE);
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyDelete(nChar)) {
		OnDelete();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyNextLine(nChar)) {	//	Default : 
        if (::GetKeyState(VK_SHIFT) < 0) {
			// ShiftĂubN}[Nւ
			if (SwapItem(FALSE) == FALSE){
				return;
			}
        }
	} else if (Cq2chwmConfig::GetInstance()->IsKeyPrevLine(nChar)) {	//	Default : 
        if (::GetKeyState(VK_SHIFT) < 0) {
			// ShiftĂubN}[Nւ
			if (SwapItem(TRUE) == FALSE) {
				return;
			}
        }
	};

	Cq2chwmListView::OnKeyDown(nChar, nRepCnt, nFlags);
}

BOOL Cq2chwmBookmarkView::AddBookmark(
	const char *chp_aname,
	const char *chp_aid,
	const char *chp_bname,
	const char *chp_bid,
	const char *chp_burl)
{
	// 擪ɃACeǉ
	Cq2chwmBookmarkFile::GetInstance()->AddBookmark(chp_aname, chp_aid, chp_bname, chp_bid, chp_burl);
	Cq2chwmBookmarkFile::GetInstance()->Write();

	// VJEgZbg
	GetListCtrl().SetItemCountEx(Cq2chwmBookmarkFile::GetInstance()->Count());

	return TRUE;
}

void Cq2chwmBookmarkView::OnDestroy()
{
	CYoPtrArray cArray;
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(0));
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(1));
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(2));
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(3));
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(4));
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(5));
	Cq2chwmConfig::GetInstance()->SetColumnWidthBookmark(cArray);
	Cq2chwmConfig::GetInstance()->SetSortColumnBookmark(GetSortColumn());
	Cq2chwmConfig::GetInstance()->SetSortAscBookmark(GetSortAsc());
	clearList();
	Cq2chwmListView::OnDestroy();

	// TODO: ɃbZ[W nh R[hǉ܂B
}

long Cq2chwmBookmarkView::OnCustomMessage(
	WPARAM wParam,
	LPARAM lParam)
{
	Cq2chwmMessage *pMessage = (Cq2chwmMessage*)lParam;
	switch (pMessage->GetType()) {
		case Cq2chwmMessage::TYPE_OPENFILE:
			break;
		case Cq2chwmMessage::TYPE_CLOSEFILE:
		{
			// MYubN}[NACeXV
			Cq2chwmCloseFileMessage *pCloseFileMessage = (Cq2chwmCloseFileMessage*)pMessage;
			if (pCloseFileMessage->GetWriteSize() > 0) {
				UpdateItem(pMessage->GetFileName());
			}
			break;
		}
		case Cq2chwmMessage::TYPE_WRITEFILE:
			break;
		case Cq2chwmMessage::TYPE_RELOADFILE:
			break;
		case Cq2chwmMessage::TYPE_CLOSETAB:
			break;
	};

	return 0;
}

void Cq2chwmBookmarkView::UpdateItem(
	const char *chp_filename)
{
	Cq2chwmBookmarkItem *pItem = (Cq2chwmBookmarkItem*)GetItem(chp_filename);
	if (pItem != NULL) {
		pItem->Update();
	}
}

Cq2chwmBookmarkItem *Cq2chwmBookmarkView::GetNextItem(
	const char *chp_filename)
{
	if (chp_filename == NULL) return NULL;
	// datt@CpXɑACe̎VACe
	int in_index = 0;
	for (int i = 0; i < Cq2chwmBookmarkFile::GetInstance()->Count(); i++) {
		Cq2chwmBookmarkItem *pItem = Cq2chwmBookmarkFile::GetInstance()->GetItem(i);
		if (strcmp(chp_filename, pItem->GetFileName()) == 0) {
			in_index = i + 1;
			break;
		}
	}
	if (in_index == NULL) return NULL;
	for (int i = in_index; i < Cq2chwmBookmarkFile::GetInstance()->Count(); i++) {
		Cq2chwmBookmarkItem *pItem = Cq2chwmBookmarkFile::GetInstance()->GetItem(i);
		if (pItem->GetNew() == TRUE) return pItem;
	}
	return NULL;
}

class Cq2chwmThreadInfo
{
private:
	CWnd *m_pMainFrame;
	Cq2chwmBookmarkView *m_pThis;
	Cq2chwmBookmarkItem *m_pItem;
	int m_in_index;
	CWinThread *m_pThread;

public:
	Cq2chwmThreadInfo(CWnd *pMainFrame, Cq2chwmBookmarkView *pThis, Cq2chwmBookmarkItem *pItem = NULL, int in_index = -1)
	{
		m_pMainFrame = pMainFrame;
		m_pThis= pThis;
		m_pItem = pItem;
		m_in_index = in_index;
		m_pThread = NULL;
	}
	inline CWnd *GetMainWnd(){ return m_pMainFrame; }
	inline Cq2chwmBookmarkView *GetView(){ return m_pThis; }
	inline Cq2chwmBookmarkItem *GetItem(){ return m_pItem; }
	inline int GetIndex(){ return m_in_index; }
	inline CWinThread *GetThread(){ return m_pThread; }
	inline void SetThread(CWinThread *pThread){ m_pThread = pThread; }
};

void Cq2chwmBookmarkView::OnReload()
{
	// TODO: ɃR}h nh R[hǉ܂B
	if (m_bo_running == TRUE) {
		return;
	}
	if (m_pThread != NULL) m_pThread->Delete();
	m_pThread = AfxBeginThread(Cq2chwmBookmarkView::ThreadReloadProc, (LPVOID)new Cq2chwmThreadInfo(AfxGetMainWnd(), this), THREAD_PRIORITY_BELOW_NORMAL);
	if (m_pThread == NULL) {
		PRINTLOG("AfxBeginThread error(%d)", ::GetLastError());
		return;
	}
}

BOOL Cq2chwmBookmarkView::waitThread(
	BOOL bo_all)
{
	while (m_cArrayThread.Count() > 0) {
		// Cxg̃nhz쐬
		HANDLE *hThreadArray = (HANDLE*)malloc(sizeof(HANDLE) * m_cArrayThread.Count());
		for (int i = 0; i < m_cArrayThread.Count(); i++) {
			Cq2chwmThreadInfo *pInfo = (Cq2chwmThreadInfo*)m_cArrayThread.Get(i);
			hThreadArray[i] = pInfo->GetThread()->m_hThread;
		}
		DWORD dwRet = ::WaitForMultipleObjects(m_cArrayThread.Count(), hThreadArray, FALSE, 100);
		free(hThreadArray);
		if (dwRet == WAIT_TIMEOUT) {
			// ^CAEg
			continue;
		} else if (dwRet == WAIT_FAILED) {
			PRINTLOG("WaitForMultipleObjects error: %d", ::GetLastError());
			return FALSE;
		} else {
			// XbhI
			int in_index = dwRet - WAIT_OBJECT_0;
			Cq2chwmThreadInfo *pInfo = (Cq2chwmThreadInfo*)m_cArrayThread.Get(in_index);
			pInfo->GetThread()->Delete();
			m_cArrayThread.Remove(in_index);
			delete pInfo;
			if (bo_all == FALSE) break;
		}
	}
	return TRUE;
}

UINT __cdecl Cq2chwmBookmarkView::ThreadReloadProc(
	LPVOID lpParameter)
{
	Cq2chwmThreadInfo *pInfo = (Cq2chwmThreadInfo*)lpParameter;
	Cq2chwmBookmarkView *pThis = (Cq2chwmBookmarkView*)pInfo->GetView();
	CMainFrame *pMainFrame = (CMainFrame*)pInfo->GetMainWnd();

	// |C^ێĂ邾Ȃ̂łŔjĂv
	delete pInfo;

	pThis->m_bo_running = TRUE;
	::SendMessage(pMainFrame->m_hWnd, WM_USER_SHOWSTATUSBAR, 0, (LPARAM)TRUE);
	PRINTLOG("start: %d", pThis->GetListCtrl().GetItemCount());
	pThis->m_cArrayThread.RemoveAll();
	for (int i = 0; i < Cq2chwmBookmarkFile::GetInstance()->Count(); i++) {
		// 1XbhI`FbN
		if (pThis->m_cArrayThread.Count() == Cq2chwmConfig::GetInstance()->GetThreadMax()) {
			if (pThis->waitThread(FALSE) == FALSE) break;
		}

		// G[ԃZbg
		Cq2chwmBookmarkItem *pItem = Cq2chwmBookmarkFile::GetInstance()->GetItem(i);
		pItem->SetError(FALSE);

		// XbhNX
		Cq2chwmThreadInfo *pInfo = new Cq2chwmThreadInfo(pMainFrame, pThis, pItem, i);

		// XbhJn
		CWinThread *pThread = AfxBeginThread(Cq2chwmBookmarkView::ThreadProc, (LPVOID)pInfo, THREAD_PRIORITY_BELOW_NORMAL);
		if (pThread == NULL) {
			PRINTLOG("AfxBeginThread error(%d)", ::GetLastError());
			break;
		}

		// XbhZbg
		pInfo->SetThread(pThread);

		// Xbhzɒǉ
		pThis->m_cArrayThread.Add(pInfo);

		PRINTLOG("[%d]", i);
		::SendMessage(pMainFrame->m_hWnd, WM_USER_SETPROGRESS, i + 1, Cq2chwmBookmarkFile::GetInstance()->Count());
		if (pMainFrame->Canceled() == TRUE) break;
	}

	// SẴXbhI`FbN
	pThis->waitThread(TRUE);
	pThis->m_bo_running = FALSE;
	PRINTLOG("end");

	// V\[gԂȂVōă\[g
	if (pThis->GetSortColumn() == Cq2chwmBookmarkFile::IDX_NEW) {
		pThis->SortItems(Cq2chwmBookmarkFile::IDX_NEW, TRUE);
	}

	// Xe[^Xo[
	::SendMessage(pMainFrame->m_hWnd, WM_USER_SHOWSTATUSBAR, 0, (LPARAM)FALSE);
	AfxEndThread(0, FALSE);
	return 0;
}

//DWORD WINAPI Cq2chwmBookmarkView::ThreadProc(
UINT __cdecl Cq2chwmBookmarkView::ThreadProc(
	LPVOID lpParameter)
{
	PRINTLOG("Cq2chwmBookmarkView::ThreadProc: %08x", ::GetCurrentThreadId());
	Cq2chwmThreadInfo *pInfo = (Cq2chwmThreadInfo*)lpParameter;
	Cq2chwmBookmarkView *pThis = pInfo->GetView();
	Cq2chwmBookmarkItem *pItem = pInfo->GetItem();
	CWnd *pMainWnd = pInfo->GetMainWnd();
	int in_index = pInfo->GetIndex();

	// ACRĕ`
	{
		pItem->SetRunning(TRUE);
		RECT rect;
		pThis->GetListCtrl().GetItemRect(in_index, &rect, LVIR_BOUNDS);
		rect.right = 16;
		pThis->InvalidateRect(&rect, FALSE);
	}

	CYoString str_err;
	if (Cq2chwmBbsManager::GetInstance()->HttpGet(pMainWnd, pItem->GetBoardUrl(), pItem->GetArticleId(), str_err) != ERR_NONE) {
		pItem->SetError(TRUE);
	}

	// ACeĕ`
	{
		pItem->SetRunning(FALSE);
		pItem->ClearCountPerDay();
		RECT rect;
		pThis->GetListCtrl().GetItemRect(in_index, &rect, LVIR_BOUNDS);
		pThis->InvalidateRect(&rect, FALSE);
	}

	AfxEndThread(0, FALSE);
	return 0;
}

void Cq2chwmBookmarkView::OnListClicked()
{
	POSITION pos = GetListCtrl().GetFirstSelectedItemPosition();
	if (pos == NULL) return;
	Cq2chwmBookmarkItem *pItem = (Cq2chwmBookmarkItem*)Cq2chwmBookmarkFile::GetInstance()->GetItem((int)pos - 1);
	if (pItem == NULL) return;

	if (m_bo_multiselect == TRUE) {
		pItem->SetSelected(!pItem->GetSelected());
		RECT rect;
		GetListCtrl().GetItemRect((int)pos - 1, &rect, LVIR_BOUNDS);
		InvalidateRect(&rect, FALSE);
	} else {
		GetParent()->SendMessage(WM_USER_BOOKMARKCLICKED, 0, (LPARAM)pItem);
	}
}

// ĂԂтɃ\[gω郁\bh
// JwŃ\[gƂSortItemsĂԂ
void Cq2chwmBookmarkView::Sort()
{
	int in_col = GetSortColumn();
	if (in_col == Cq2chwmBookmarkFile::IDX_SEARCH) {
		in_col = Cq2chwmBookmarkFile::IDX_INDEX;
	} else {
		in_col++;
	}
	SortItems(in_col, TRUE);
}

void Cq2chwmBookmarkView::SortItems(
	int in_col,
	BOOL bo_asc)
{
	// \[gsƂ^Cgo[ς
	/*
	CString cstr_title = _T("ubN}[N");
	switch (in_col) {
	case Cq2chwmBookmarkFile::IDX_INDEX:
		cstr_title += _T("[No]");
		break;
	case Cq2chwmBookmarkFile::IDX_COUNT:
		cstr_title += _T("[X]");
		break;
	case Cq2chwmBookmarkFile::IDX_ANAME:
		cstr_title += _T("[Xbh]");
		break;
	case Cq2chwmBookmarkFile::IDX_BNAME:
		cstr_title += _T("[]");
		break;
	case Cq2chwmBookmarkFile::IDX_AID:
		cstr_title += _T("[XbhID]");
		break;
	case Cq2chwmBookmarkFile::IDX_NEW:
		cstr_title += _T("[V]");
		break;
	case Cq2chwmBookmarkFile::IDX_SEARCH:
		cstr_title += _T("[]");
		break;
	};
	AfxGetMainWnd()->SetWindowText(cstr_title);
	*/

	if (IsRunning() == TRUE) {
		// [h̓\[g֎~
		return;
	}
	Cq2chwmBookmarkFile::GetInstance()->Sort(in_col, bo_asc);
	RedrawWindow();
	SetSortColumn(in_col);
	SetSortAsc(bo_asc);
}

void Cq2chwmBookmarkView::Search(
	const char *chp_word)
{
	BOOL bo_ret = FALSE;
	CYoRegex cRegex(chp_word, CYoRegex::SJIS, TRUE);
	for (int i = 0; i < Cq2chwmBookmarkFile::GetInstance()->Count(); i++) {
		Cq2chwmBookmarkItem *pItem = (Cq2chwmBookmarkItem*)Cq2chwmBookmarkFile::GetInstance()->GetItem(i);
		if (cRegex.Match(pItem->GetArticleName()) >= 0) {
			pItem->SetSearch(TRUE);
			bo_ret = TRUE;
		} else {
			pItem->SetSearch(FALSE);
		}
	}

	// }b`ꍇ̂݁A[]Ń\[g&ֈړ
	if (bo_ret == TRUE) {
		SortItems(Cq2chwmBookmarkFile::IDX_SEARCH, TRUE);
		GoTop();
	}
}

BOOL Cq2chwmBookmarkView::GetItemText(
	LPTSTR wchp_text,
	int in_size,
	int in_row,
	int in_col)
{
	Cq2chwmBookmarkItem *pItem = Cq2chwmBookmarkFile::GetInstance()->GetItem(in_row);
	if (pItem == NULL) return FALSE;
	CString cstr_tmp;
	switch (in_col) {
	case Cq2chwmBookmarkFile::IDX_INDEX:
		cstr_tmp.Format(_T("%d"), pItem->GetIndex());
		break;
	case Cq2chwmBookmarkFile::IDX_COUNT:
		if (pItem->GetNew() == FALSE || pItem->GetCountNew() == 0) {
			cstr_tmp.Format(_T("%d"), pItem->GetCount());
		} else {
			if (Cq2chwmConfig::GetInstance()->GetListSingleLine() == TRUE) {
				cstr_tmp.Format(_T("%d(%d)"), pItem->GetCount(), pItem->GetCountNew());
			} else {
				cstr_tmp.Format(_T("%d\n(%d)"), pItem->GetCount(), pItem->GetCountNew());
			}
		}
		break;
	case Cq2chwmBookmarkFile::IDX_ANAME:
		cstr_tmp = pItem->GetArticleName();
		break;
	case Cq2chwmBookmarkFile::IDX_COUNTPERDAY:
		cstr_tmp.Format(_T("%.1f"), pItem->GetCountPerDay());
		break;
	case Cq2chwmBookmarkFile::IDX_BNAME:
		cstr_tmp = pItem->GetBoardName();
		break;
	case Cq2chwmBookmarkFile::IDX_AID:
		cstr_tmp = pItem->GetArticleId();
		break;
	};
	_tcscpy_s(wchp_text, in_size, cstr_tmp);
	return TRUE;
}

Cq2chwmListItem *Cq2chwmBookmarkView::GetSelectedItem()
{
	POSITION pos = GetListCtrl().GetFirstSelectedItemPosition();
	if (pos == NULL) return NULL;
	return Cq2chwmBookmarkFile::GetInstance()->GetItem((int)pos - 1);
}

Cq2chwmListItem *Cq2chwmBookmarkView::GetItem(
	int iRow)
{
	return Cq2chwmBookmarkFile::GetInstance()->GetItem(iRow);
}

BOOL Cq2chwmBookmarkView::SwapItem(
	BOOL swUp)
{
	// No\[ĝݗLł
	if (GetSortColumn() != Cq2chwmBookmarkFile::IDX_INDEX) {
		if (::MessageBox(m_hWnd, _T("ubN}[NړNo\[gԂōsĂ\nNo\[gԂɂ܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
			SortItems(Cq2chwmBookmarkFile::IDX_INDEX, TRUE);
		}
		return FALSE;
	}

	//	Iʒu擾
	POSITION pos = GetListCtrl().GetFirstSelectedItemPosition();
	//	擾siIԁHjȂI
	if (pos == NULL) return FALSE;
	//	LXgʓ|Ȃ̂ŁAint^ɑ
	int iPos = (int)pos;
	//	ubN}[N擾
	int Cnt = Cq2chwmBookmarkFile::GetInstance()->Count();
	bool swFlag = FALSE;
	Cq2chwmBookmarkItem	*p1;
	Cq2chwmBookmarkItem	*p2;
	if (swUp == TRUE) {	//	Ȃ
		if (iPos > 1) {		//	IʒuP𒴂Ȃ
			p1 = Cq2chwmBookmarkFile::GetInstance()->GetItem(iPos-2);
			p2 = Cq2chwmBookmarkFile::GetInstance()->GetItem(iPos-1);
			swFlag = TRUE;
		}
	} else {	//	Ȃ
		if (iPos < Cnt) {	//	IʒuubN}[N菬Ȃ
			p1 = Cq2chwmBookmarkFile::GetInstance()->GetItem(iPos-1);
			p2 = Cq2chwmBookmarkFile::GetInstance()->GetItem(iPos);
			swFlag = TRUE;
		}
	}
	if (swFlag == TRUE) {
		p1->SetIndex(p1->GetIndex()+1);	//	p1
		p2->SetIndex(p1->GetIndex()-1);	//	p2̈ʒuւ
		Cq2chwmBookmarkFile::GetInstance()->Write();	//	bookmark.txt ɏo
		InvalidateRect(NULL);	//	\
	} else {
		return	FALSE;
	}
	return	TRUE;
}

Cq2chwmListItem *Cq2chwmBookmarkView::GetItem(
	const char *chp_filename)
{
	for (int i = 0; i < Cq2chwmBookmarkFile::GetInstance()->Count(); i++) {
		Cq2chwmBookmarkItem *pItem = Cq2chwmBookmarkFile::GetInstance()->GetItem(i);
		if (strcmp(chp_filename, pItem->GetFileName()) == 0) {
			return pItem;
		}
	}
	return NULL;
}

void Cq2chwmBookmarkView::OnDelete()
{
	// TODO: ɃR}h nh R[hǉ܂B
	if (m_bo_multiselect == TRUE) {
		// I[h͊Sɏ𕪂
		if (::MessageBox(m_hWnd, _T("IACeSč폜܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
			AfxGetApp()->DoWaitCursor(1);
			for (int i = 0; i < Cq2chwmBookmarkFile::GetInstance()->Count(); i++) {
				Cq2chwmBookmarkItem *pItem = Cq2chwmBookmarkFile::GetInstance()->GetItem(i);
				if (pItem->GetState() & Cq2chwmListItem::STATE_SELECTED) {
					Cq2chwmBookmarkFile::GetInstance()->Remove(i);
					i--;
				}
			}
			Cq2chwmBookmarkFile::GetInstance()->Write();
			GetListCtrl().SetItemCountEx(Cq2chwmBookmarkFile::GetInstance()->Count());
			InvalidateRect(NULL);
			AfxGetApp()->DoWaitCursor(-1);
		}
	} else {
		POSITION pos = GetListCtrl().GetFirstSelectedItemPosition();
		if (pos == NULL) return;
		if (::MessageBox(m_hWnd, _T("폜܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
			Cq2chwmBookmarkFile::GetInstance()->Remove((int)pos - 1);
			Cq2chwmBookmarkFile::GetInstance()->Write();
			GetListCtrl().SetItemCountEx(Cq2chwmBookmarkFile::GetInstance()->Count());
			InvalidateRect(NULL);
		}
	}
}

void Cq2chwmBookmarkView::OnSortArticleId()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmBookmarkFile::IDX_AID, FALSE);
}

void Cq2chwmBookmarkView::OnUpdateSortArticleId(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmBookmarkFile::IDX_AID);
}

void Cq2chwmBookmarkView::OnSortArticleName()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmBookmarkFile::IDX_ANAME, TRUE);
}

void Cq2chwmBookmarkView::OnUpdateSortArticleName(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmBookmarkFile::IDX_ANAME);
}

void Cq2chwmBookmarkView::OnSortBoardName()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmBookmarkFile::IDX_BNAME, TRUE);
}

void Cq2chwmBookmarkView::OnUpdateSortBoardName(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmBookmarkFile::IDX_BNAME);
}

void Cq2chwmBookmarkView::OnSortCount()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmBookmarkFile::IDX_COUNT, FALSE);
}

void Cq2chwmBookmarkView::OnUpdateSortCount(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmBookmarkFile::IDX_COUNT);
}

void Cq2chwmBookmarkView::OnSortIndex()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmBookmarkFile::IDX_INDEX, TRUE);
}

void Cq2chwmBookmarkView::OnUpdateSortIndex(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmBookmarkFile::IDX_INDEX);
}

void Cq2chwmBookmarkView::OnSortNew()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmBookmarkFile::IDX_NEW, TRUE);
}

void Cq2chwmBookmarkView::OnUpdateSortNew(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmBookmarkFile::IDX_NEW);
}

void Cq2chwmBookmarkView::OnSortSearch()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmBookmarkFile::IDX_SEARCH, TRUE);
}

void Cq2chwmBookmarkView::OnUpdateSortSearch(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmBookmarkFile::IDX_SEARCH);
}

void Cq2chwmBookmarkView::OnShowWindow(BOOL bShow, UINT nStatus)
{
	Cq2chwmListView::OnShowWindow(bShow, nStatus);

	// TODO: ɃbZ[W nh R[hǉ܂B
	if (bShow == TRUE && GetSortColumn() == Cq2chwmBookmarkFile::IDX_NEW) {
		SortItems(Cq2chwmBookmarkFile::IDX_NEW, TRUE);
	}
}

void Cq2chwmBookmarkView::OnAdjustColumnWidth()
{
	// TODO: ɃR}h nh R[hǉ܂B
	for (int i = 0; i < GetListCtrl().GetHeaderCtrl()->GetItemCount(); i++) {
		GetListCtrl().SetColumnWidth(i, LVSCW_AUTOSIZE);
	}
	if (Cq2chwmConfig::GetInstance()->GetListSingleLine() == FALSE) {
		// X1/2
		GetListCtrl().SetColumnWidth(1, GetListCtrl().GetColumnWidth(1) / 2);
	}
	// Xbh1/2
	GetListCtrl().SetColumnWidth(2, GetListCtrl().GetColumnWidth(2) / 2);
}

void Cq2chwmBookmarkView::OnSortCountPerDay()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmBookmarkFile::IDX_COUNTPERDAY, FALSE);
}

void Cq2chwmBookmarkView::OnUpdateSortCountPerDay(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmBookmarkFile::IDX_COUNTPERDAY);
}

void Cq2chwmBookmarkView::OnMultiSelect()
{
	// TODO: ɃR}h nh R[hǉ܂B
	if (m_bo_multiselect == FALSE) {
		m_bo_multiselect = TRUE;
	} else {
		m_bo_multiselect = FALSE;
		// SẴACeSTATE_SELECTED
		for (int i = 0; i < Cq2chwmBookmarkFile::GetInstance()->Count(); i++) {
			Cq2chwmBookmarkItem *pItem = Cq2chwmBookmarkFile::GetInstance()->GetItem(i);
			pItem->SetSelected(FALSE);
		}
		InvalidateRect(NULL);
		UpdateWindow();
	}
}

void Cq2chwmBookmarkView::OnUpdateMultiSelect(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(m_bo_multiselect);
}
