#pragma once

#include "YoTable.h"
#include "YoTree.h"
#include "q2chwmCommon.h"
#include "q2chwmSubjectItem.h"

class Cq2chwmSubjectFile : public CYoPtrArray
{
public:
	enum {
		IDX_INDEX = 0,
		IDX_COUNT,
		IDX_ANAME,
		IDX_COUNTPERDAY,
		IDX_AID,
		IDX_NEW,
		IDX_SEARCH,
		IDX_CACHE,
		IDX_BNAME,
	};

private:
	CYoTree m_cTree;
	CYoString m_str_burl;
	static int compAsc(const void *vop_user, const void *a, const void *b);
	static int compDesc(const void *vop_user, const void *a, const void *b);

public:
	Cq2chwmSubjectFile();
	~Cq2chwmSubjectFile();

	Cq2chwmSubjectItem *GetItem(int in_index){ return (Cq2chwmSubjectItem*)Get(in_index); }
	Cq2chwmSubjectItem *GetItem(const char *chp_aid){ return (Cq2chwmSubjectItem*)m_cTree.Get(chp_aid); }

	int CreateFromFile(const char *chp_filename);
	int CreateFromHttp(const char *chp_filename, const char *chp_burl);
	int CreateFromFindUrl(const char *chp_filename, const char *chp_url);
	void RemoveAll();
	void Sort(int in_col, BOOL bo_asc);
};
