#pragma once

#include "YoPtrArray.h"
#include "q2chwmCommon.h"
#include "q2chwmCacheItem.h"

class Cq2chwmCacheFile : public CYoPtrArray
{
public:
	enum {
		IDX_INDEX = 0,
		IDX_ANAME,
		IDX_BNAME,
		IDX_DATE,
		IDX_SEARCH,
	};

private:
	static int compAsc(const void *vop_user, const void *a, const void *b);
	static int compDesc(const void *vop_user, const void *a, const void *b);

private:
	BOOL readDirectory(const char *chp_dir, int& in_index);
	BOOL addItem(int in_index, const char *chp_filename, const char *chp_date);

public:
	Cq2chwmCacheFile();
	~Cq2chwmCacheFile();

	Cq2chwmCacheItem *GetItem(int in_index){ return (Cq2chwmCacheItem*)Get(in_index); }

	int Create();
	void RemoveAll();
	void Sort(int in_col, BOOL bo_asc);
	void Remove(int in_index);

};
