// q2chwmPageSystem.cpp : t@C
//

#include "stdafx.h"
#include <shlobj.h>
#include "q2chwm.h"
#include "q2chwmPageSystem.h"
#include "q2chwmLayoutManager.h"
#include "q2chwmConfig.h"
#include "q2chwmConfigDialog.h"
#include "q2chwmFolderSelector.h"
#include "q2chwmProgramSelector.h"

// Cq2chwmPageSystem _CAO

IMPLEMENT_DYNAMIC(Cq2chwmPageSystem, CDialog)

Cq2chwmPageSystem::Cq2chwmPageSystem(CWnd* pParent /*=NULL*/)
	: Cq2chwmConfigPage(Cq2chwmPageSystem::IDD, pParent)
	, m_bo_debug(FALSE)
{
	m_cstr_root_dir = Cq2chwmConfig::GetInstance()->GetRootDirectory();
	m_cstr_board_url = Cq2chwmConfig::GetInstance()->GetBoardUrl();
	m_cstr_browser = Cq2chwmConfig::GetInstance()->GetBrowser();
	m_in_threadmax = Cq2chwmConfig::GetInstance()->GetThreadMax();
	m_in_tabmax = Cq2chwmConfig::GetInstance()->GetTabMax();
	m_in_tabwidth = Cq2chwmConfig::GetInstance()->GetTabWidth();
	m_bo_debug = Cq2chwmConfig::GetInstance()->GetDebug();
}

Cq2chwmPageSystem::~Cq2chwmPageSystem()
{
}

void Cq2chwmPageSystem::DoDataExchange(CDataExchange* pDX)
{
	DDX_Text(pDX, IDC_EDIT_ROOTDIR, m_cstr_root_dir);
	DDX_Text(pDX, IDC_EDIT_BOARDURL, m_cstr_board_url);
	DDX_Text(pDX, IDC_EDIT_BROWSER, m_cstr_browser);
	DDX_Text(pDX, IDC_COMBO_THREADMAX, m_in_threadmax);
	DDX_Text(pDX, IDC_COMBO_TABMAX, m_in_tabmax);
	DDX_Text(pDX, IDC_EDIT_TABWIDTH, m_in_tabwidth);
	DDX_Check(pDX, IDC_CHECK_DEBUG, m_bo_debug);
	Cq2chwmConfigPage::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(Cq2chwmPageSystem, Cq2chwmConfigPage)
	ON_WM_SIZE()
	ON_BN_CLICKED(IDC_BUTTON_BROWSE, &Cq2chwmPageSystem::OnBnClickedButtonBrowse)
	ON_BN_CLICKED(IDC_BUTTON_PROGRAMBROWSE, &Cq2chwmPageSystem::OnBnClickedButtonProgrambrowse)
END_MESSAGE_MAP()


// Cq2chwmPageSystem bZ[W nh

void Cq2chwmPageSystem::OnSize(UINT nType, int cx, int cy)
{
	Cq2chwmConfigPage::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	Cq2chwmLayoutManager cLayout(
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_ROOTDIR), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_EDIT_ROOTDIR), 3, GetDlgItem(IDC_BUTTON_BROWSE), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_BOARDURL), 2, GetDlgItem(IDC_EDIT_BOARDURL), 3),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_BROWSER), 1, GetDlgItem(IDC_EDIT_BROWSER), 2, GetDlgItem(IDC_BUTTON_PROGRAMBROWSE), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_THREADMAX), 2, GetDlgItem(IDC_COMBO_THREADMAX), 3),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_TABMAX), 2, GetDlgItem(IDC_COMBO_TABMAX), 3),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_TABWIDTH), 2, GetDlgItem(IDC_EDIT_TABWIDTH), 3),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_CHECK_DEBUG), 1)
	);
	cLayout.Layout(cx, cy);
}

void Cq2chwmPageSystem::Write()
{
	UpdateData(TRUE);
	CYoString str_root_dir = A(m_cstr_root_dir);
	Cq2chwmConfig::GetInstance()->SetRootDirectory(str_root_dir);
	CYoString str_board_url = A(m_cstr_board_url);
	if (str_board_url.Length() == 0) {
		str_board_url = DEF_BOARDURL;
	}
	Cq2chwmConfig::GetInstance()->SetBoardUrl(str_board_url);
	CYoString str_browser = A(m_cstr_browser);
	Cq2chwmConfig::GetInstance()->SetBrowser(str_browser);
	Cq2chwmConfig::GetInstance()->SetThreadMax(m_in_threadmax);
	Cq2chwmConfig::GetInstance()->SetTabMax(m_in_tabmax);
	Cq2chwmConfig::GetInstance()->SetTabWidth(m_in_tabwidth);
	Cq2chwmConfig::GetInstance()->SetDebug(m_bo_debug);
	// fobOݒ
	{
		wchar_t cha_dir[MAX_PATH + 1];
		wchar_t *chp_ptr;
		CWinApp *pApp = AfxGetApp();
		GetModuleFileName(NULL, cha_dir, MAX_PATH);
		chp_ptr = wcsrchr(cha_dir, '\\');
		if (chp_ptr != NULL) {
			*chp_ptr = 0x00;
			if (Cq2chwmConfig::GetInstance()->GetDebug() == TRUE) {
				CYoString str_dir = A(cha_dir);
				CYoObject::SetLogdir(str_dir);
				CYoObject::SetModule(APP_NAME);
				CYoObject::SetLoglevel(LEVEL_DEBUG);
			} else {
				CYoObject::SetLogdir("");
				CYoObject::SetModule("");
				CYoObject::SetLoglevel("");
			}
		}
	}
}


void Cq2chwmPageSystem::OnBnClickedButtonBrowse()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	Cq2chwmFolderSelector cDlg;
	if (cDlg.DoModal() == IDOK) {
		m_cstr_root_dir = cDlg.GetPath();
		UpdateData(FALSE);
	}
}

BOOL Cq2chwmPageSystem::OnInitDialog()
{
	Cq2chwmConfigPage::OnInitDialog();

	// TODO:  ɏǉĂ

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void Cq2chwmPageSystem::OnBnClickedButtonProgrambrowse()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	Cq2chwmProgramSelector cDlg;
	if (cDlg.DoModal() == IDOK) {
		m_cstr_browser = cDlg.GetPath();
		UpdateData(FALSE);
	}
}
