// q2chwmPageNetwork.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmPageNetwork.h"
#include "q2chwmConfig.h"
#include "q2chwmLayoutManager.h"

// Cq2chwmPageNetwork _CAO

#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
#include <connmgr.h>
#include <connmgr_proxy.h>
#endif // WIN32_PLATFORM_PSPC

IMPLEMENT_DYNAMIC(Cq2chwmPageNetwork, CDialog)

Cq2chwmPageNetwork::Cq2chwmPageNetwork(CWnd* pParent /*=NULL*/)
	: Cq2chwmConfigPage(Cq2chwmPageNetwork::IDD, pParent)
{
	m_cstr_proxy_host = Cq2chwmConfig::GetInstance()->GetProxyHost();
	m_in_proxy_port = Cq2chwmConfig::GetInstance()->GetProxyPort();
	m_cstr_proxy_id = Cq2chwmConfig::GetInstance()->GetProxyId();
	m_cstr_proxy_pass = Cq2chwmConfig::GetInstance()->GetProxyPass();
	m_cstr_dolib_id = Cq2chwmConfig::GetInstance()->GetDoLibId();
	m_cstr_dolib_pass = Cq2chwmConfig::GetInstance()->GetDoLibPass();
	if (strcmp(Cq2chwmConfig::GetInstance()->GetUserAgent(), USERAGENT) != 0) {
		m_cstr_ua = Cq2chwmConfig::GetInstance()->GetUserAgent();
	}
}

Cq2chwmPageNetwork::~Cq2chwmPageNetwork()
{
}

void Cq2chwmPageNetwork::DoDataExchange(CDataExchange* pDX)
{
	DDX_Control(pDX, IDC_CHECK_PROXYUSE, m_cProxyUse);
	DDX_Text(pDX, IDC_COMBO_PROXYHOST, m_cstr_proxy_host);
	DDX_Text(pDX, IDC_EDIT_PROXYPORT, m_in_proxy_port);
	DDX_Text(pDX, IDC_EDIT_PROXYID, m_cstr_proxy_id);
	DDX_Text(pDX, IDC_EDIT_PROXYPASS, m_cstr_proxy_pass);
	DDX_Text(pDX, IDC_EDIT_DOLIBID, m_cstr_dolib_id);
	DDX_Text(pDX, IDC_EDIT_DOLIBPASS, m_cstr_dolib_pass);
	DDX_Text(pDX, IDC_COMBO_UA, m_cstr_ua);
	Cq2chwmConfigPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_CONN, m_cComboConnection);
	DDX_Control(pDX, IDC_STATIC_CONN, m_cStaticConnection);
	DDX_Control(pDX, IDC_COMBO_UA, m_cComboUserAgent);
	DDX_Control(pDX, IDC_COMBO_PROXYHOST, m_cComboProxyHost);
}


BEGIN_MESSAGE_MAP(Cq2chwmPageNetwork, Cq2chwmConfigPage)
	ON_WM_SIZE()
	ON_BN_CLICKED(IDC_CHECK_PROXYUSE, &Cq2chwmPageNetwork::OnBnClickedCheckProxyuse)
END_MESSAGE_MAP()


// Cq2chwmPageNetwork bZ[W nh

void Cq2chwmPageNetwork::Write()
{
	UpdateData(TRUE);
	CYoString str_value;
	str_value = A(m_cstr_proxy_host);
	Cq2chwmConfig::GetInstance()->SetProxyHost(str_value);
	Cq2chwmConfig::GetInstance()->SetProxyPort(m_in_proxy_port);
	str_value = A(m_cstr_proxy_id);
	Cq2chwmConfig::GetInstance()->SetProxyId(str_value);
	str_value = A(m_cstr_proxy_pass);
	Cq2chwmConfig::GetInstance()->SetProxyPass(str_value);
	str_value = A(m_cstr_dolib_id);
	Cq2chwmConfig::GetInstance()->SetDoLibId(str_value);
	str_value = A(m_cstr_dolib_pass);
	Cq2chwmConfig::GetInstance()->SetDoLibPass(str_value);
	Cq2chwmConfig::GetInstance()->SetProxyUse(m_cProxyUse.GetCheck());
	str_value = A(m_cstr_ua);
	Cq2chwmConfig::GetInstance()->SetUserAgent(str_value);
#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
	Cq2chwmConfig::GetInstance()->SetConnection(m_cComboConnection.GetCurSel());
#endif
}

BOOL Cq2chwmPageNetwork::OnInitDialog()
{
	Cq2chwmConfigPage::OnInitDialog();

	// TODO:  ɏǉĂ
	m_cProxyUse.SetCheck(Cq2chwmConfig::GetInstance()->GetProxyUse());
	OnBnClickedCheckProxyuse();

	// vLVR{{bNX
	{
		m_cComboProxyHost.InsertString(0, _T(""));
		m_cComboProxyHost.InsertString(1, _T("vfkkwapproxy.vodafone.ne.jp"));
	}

	// UAR{{bNX
	{
		m_cComboUserAgent.InsertString(0, _T(""));
		m_cComboUserAgent.InsertString(1, _T("Vodafone/1.0/V904SH/SHJ001/SN350000010000004 Browser/NetFront/3.3 Profile/MIDP-2.0 Configuration/CLDC-1.1"));
	}

#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
	// ڑR{{bNX
	CONNMGR_DESTINATION_INFO di;
	for(int i = 0; SUCCEEDED(ConnMgrEnumDestinations(i, &di)); i++) {
		m_cComboConnection.InsertString(i, di.szDescription);
		if (Cq2chwmConfig::GetInstance()->GetConnection() >= 0) {
			if (Cq2chwmConfig::GetInstance()->GetConnection() == i) {
				m_cComboConnection.SetCurSel(i);
			}
		} else {
			if (di.guid == IID_DestNetInternet) {
				m_cComboConnection.SetCurSel(i);
			}
		}
	}
	m_cComboConnection.ShowWindow(SW_SHOW);
	m_cStaticConnection.ShowWindow(SW_SHOW);
#else
	m_cComboConnection.ShowWindow(SW_HIDE);
	m_cStaticConnection.ShowWindow(SW_HIDE);
#endif

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void Cq2chwmPageNetwork::OnSize(UINT nType, int cx, int cy)
{
	Cq2chwmConfigPage::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	Cq2chwmLayoutManager cLayout(
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_DOLIB), 1, GetDlgItem(IDC_EDIT_DOLIBID), 1, GetDlgItem(IDC_EDIT_DOLIBPASS), 1),
#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_CONN), 1, GetDlgItem(IDC_COMBO_CONN), 3),
#endif
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_UA), 1, GetDlgItem(IDC_COMBO_UA), 3),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_CHECK_PROXYUSE), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_PROXY), 1, GetDlgItem(IDC_COMBO_PROXYHOST), 2, GetDlgItem(IDC_EDIT_PROXYPORT), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_PROXYID), 1, GetDlgItem(IDC_EDIT_PROXYID), 1, GetDlgItem(IDC_EDIT_PROXYPASS), 1)
	);
	cLayout.Layout(cx, cy);
}

void Cq2chwmPageNetwork::OnBnClickedCheckProxyuse()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	BOOL bo_check = ((CButton*)GetDlgItem(IDC_CHECK_PROXYUSE))->GetCheck();
	GetDlgItem(IDC_STATIC_PROXY)->EnableWindow(bo_check);
	GetDlgItem(IDC_COMBO_PROXYHOST)->EnableWindow(bo_check);
	GetDlgItem(IDC_EDIT_PROXYPORT)->EnableWindow(bo_check);
	GetDlgItem(IDC_STATIC_PROXYID)->EnableWindow(bo_check);
	GetDlgItem(IDC_EDIT_PROXYID)->EnableWindow(bo_check);
	GetDlgItem(IDC_EDIT_PROXYPASS)->EnableWindow(bo_check);
}
