#include "StdAfx.h"
#include "YoTime.h"
#include "q2chwmDatFile.h"
#include "q2chwmEditCtrl.h"
#include "q2chwmCommon.h"
#include "q2chwmArticleFile.h"
#include "q2chwmInfoFile.h"

#define MSG_SEPARATOR			"\n\n"
#define MSG_SEPARATOR_LEN		2

Cq2chwmDatFile::Cq2chwmDatFile()
{
}

Cq2chwmDatFile::~Cq2chwmDatFile()
{
}

int Cq2chwmDatFile::Count(
	const char *chp_dat)
{
	CYoTime cTime;
	FILE *fp = fopen(chp_dat, "rb");
	if (fp == NULL) {
		PRINTLOG("error %s(%d)", chp_dat, ::GetLastError());
		return -1;
	}
	char cha_line[1024 * 16];
	int in_count = 0;
	int in_read;
	while ((in_read = fread(cha_line, sizeof(char), sizeof(cha_line)-1, fp)) > 0) {
		cha_line[in_read] = 0x00;
		char *chp_lf = cha_line;
		while ((chp_lf = strchr(chp_lf, '\n')) != NULL) {
			in_count++;
			chp_lf++;
		}
	}
	fclose(fp);
	PRINTLOG("done [%s]%d(msec)", chp_dat, cTime.Elapsed());
	return in_count;
}

//! DAT`r[`ɕϊ
/*!
 * DAT`: O<>[AhX<>t<>Rg<>Xbh\n
 * 
 * r[`: [Xԍ]O<[AhX>\nt\nRg\n
 * ɕϊ
 * XbhDATt@C1sڂ̂
 * chp_srcɂ͕̃XĂ悢K\nŏI邱(r[ȃXȂ)
 * \param str_name ()Xbh
 * \param chp_dst r[`̏݃AhX(\ȃmۂKv)
 * \param chp_src DAT`
 * \param in_msg JnXԍ
 * \param uin_new JnVXԍ(̒lȏ̃XԍVƂȂ)
 * \param pRegex NG[hK\(}b`X͂ځ[񂳂)
 * \param bo_transparentabone ځ[tO(TRUEœځ[)
 * \param pHideArray ځ[񃁃bZ[W̃XԔz
 * \param pImportantArray NG[hK\Ƀ}b`Ă̔zɓXԂ͂ځ[񂳂Ȃ
 * \return int I: chp_dstɏ܂ꂽoCg ُI: -1
 */
int Cq2chwmDatFile::Convert(
	CYoString &str_name,
	char *chp_dst,
	const char *chp_src,
	int in_msg,
	unsigned int uin_new,
	CYoRegex *pRegex,
	BOOL bo_transparentabone,
	BOOL bo_deleteblanklines,
	CYoPtrArray *pHideArray,
	CYoPtrArray *pImportantArray)
{
	if (chp_dst == NULL || chp_src == NULL) {
		return -1;
	}

	char *chp_outp = chp_dst;
	char *chp_inp = (char*)chp_src;
	char *chp_sta = chp_inp;
	char *chp_end;
	int in_len;

	while (*chp_sta != 0x00) {
		char *chp_tmp = chp_outp;

		// From ʂ̂
		*chp_outp = Cq2chwmEditCtrl::COLOR_FROM;
		chp_outp++;

		chp_outp += sprintf(chp_outp, "[%d]", in_msg);

		for (int i = 0; i < 3; i++) {
			chp_end = strstr(chp_sta, "<>");
			if (chp_end == NULL) {
				*chp_outp = 0x00;
				return chp_outp - chp_dst;
			}
			in_len = chp_end - chp_sta;
			switch (i) {
			case 0:		// O
				while (chp_sta < chp_end) {
					encodeTag(&chp_outp, (const char**)&chp_sta);
				}
				break;
			case 1:		// email
				*chp_outp = '<';
				chp_outp++;
				while (chp_sta < chp_end) {
					encodeTag(&chp_outp, (const char**)&chp_sta);
				}
				if (strncmp(chp_outp - 4, "sage", 4) == 0) {
					*chp_tmp = Cq2chwmEditCtrl::COLOR_FROM_WITHSAGE;
				} else if (*(chp_outp - 1) != '<') {
					*chp_tmp = Cq2chwmEditCtrl::COLOR_FROM_WITHMAIL;
				}
				strcpy (chp_outp, ">\n");
				chp_outp += 2;
				break;
			case 2:		// t
				*chp_outp = (unsigned int)(in_msg) >= uin_new ? Cq2chwmEditCtrl::COLOR_NEW : Cq2chwmEditCtrl::COLOR_DATE;
				chp_outp++;
				while (chp_sta < chp_end) {
				    encodeTag(&chp_outp, (const char**)&chp_sta);
				}
				*chp_outp = '\n';
				chp_outp++;
				break;
			}
			chp_sta = chp_end + 2;
			if (*chp_sta == ' ') chp_sta++;
			if (*chp_sta == '\n') break;
		}
		// bZ[W
		while (*chp_sta != 0x00 && *chp_sta != '\n') {
			if (*chp_sta == '<') {
				if (*(chp_sta+1) == '>') {
					// bZ[W̏I
					char *chp_name = chp_sta + 2;
					chp_sta = strchr(chp_name, '\n');
					if (chp_sta == NULL) {
						chp_sta = chp_name + strlen(chp_name);
					}
					if (in_msg == 1 && str_name == "" && chp_name != chp_sta) {
						// Xbh擾
						str_name.StrnCpy(chp_name, chp_sta-chp_name);
					}
					break;
				} else if (strncmp( chp_sta + 1, "br>", 3 ) == 0) {
					if (*(chp_outp-1) == ' ') chp_outp--;

					// As폜
					if (bo_deleteblanklines == TRUE &&
						(*(chp_outp - 1) == '\n' && *(chp_outp - 2) == '\n' && *(chp_outp - 3) == '\n'))
					{
						// s3sȂ
						;
					} else {
						*chp_outp = '\n';
						chp_outp++;
					}
					chp_sta += 4;
					if (*chp_sta == ' ') chp_sta++;
				} else {
					char *chp_tmp = strchr(chp_sta, '>');
					if (chp_tmp != NULL) {
						chp_sta = chp_tmp;
					}
					chp_sta++;
				}
			} else {
				encodeTag(&chp_outp, (const char**)&chp_sta);
			}
		}
		*chp_outp = 0x00;		// NULL^[~l[g

 		if (pRegex != NULL && pRegex->Match( chp_tmp ) >= 0) {
			// importantXgɓĂ邩`FbN
			BOOL bo_exist_important = FALSE;
			if (pImportantArray != NULL) {
				for (int i = 0; i < pImportantArray->Count(); i++) {
					if (in_msg == (int)pImportantArray->Get(i)) {
						bo_exist_important = TRUE;
						break;
					}
				}
			}

			// importantXgɓĂ炠ځ[񂵂Ȃ
			if (bo_exist_important == FALSE) {
				if (bo_transparentabone == TRUE) {
					*chp_tmp = Cq2chwmEditCtrl::COLOR_ABONE;
					chp_tmp++;
					chp_outp = chp_tmp; // ځ[
				} else {
					*chp_tmp = Cq2chwmEditCtrl::COLOR_ABONE;
				}
			}
		}

		// XԂɂ郍[Jځ[
		if (pHideArray != NULL) {
			for (int i = 0; i < pHideArray->Count(); i++) {
				if (in_msg == (int)pHideArray->Get(i)) {
					if (bo_transparentabone == TRUE) {
						*chp_tmp = Cq2chwmEditCtrl::COLOR_ABONE;
						chp_tmp++;
						chp_outp = chp_tmp; // ځ[
					} else {
						*chp_tmp = Cq2chwmEditCtrl::COLOR_ABONE;
					}
					break;
				}
			}
		}

		in_msg++;

		if (*chp_sta == 0x00) {
			break;
		}
		chp_sta++;
		strcpy(chp_outp, MSG_SEPARATOR);
		chp_outp += MSG_SEPARATOR_LEN;
	}

	// Ō̉s
	if( *(chp_outp - 1) == '\n' ){
		chp_outp--;
		*chp_outp = 0x00;
	}

	return chp_outp - chp_dst;
}

//! HTMLeLXgɕϊ
/*!
 * &gt; -> >
 * &lt; -> <
 * &amp; -> &
 * &nbsp; -> pXy[X
 * &quot; -> "
 * <.*>폜
 * \param *chp_dst 
 * \param *chp_src 
 * \return void 
 */
void Cq2chwmDatFile::encodeTag(
	char **chp_dst,
	const char **chp_src )
{
	if( **chp_src == '&' ){
		if( strncmp( *chp_src + 1, "gt;", 3 ) == 0 ){
			**chp_dst = '>';
			(*chp_dst)++;
			(*chp_src)+=4;
		}else if( strncmp( *chp_src + 1, "lt;", 3 ) == 0 ){
			**chp_dst = '<';
			(*chp_dst)++;
			(*chp_src)+=4;
		}else if( strncmp( *chp_src + 1, "amp;", 4 ) == 0 ){
			**chp_dst = '&';
			(*chp_dst)++;
			(*chp_src)+=5;
		}else if( strncmp( *chp_src + 1, "nbsp;", 5 ) == 0 ){
			**chp_dst = ' ';
			(*chp_dst)++;
			(*chp_src)+=6;
		}else if( strncmp( *chp_src + 1, "quot;", 5 ) == 0 ){
			**chp_dst = '"';
			(*chp_dst)++;
			(*chp_src) += 6;
		}else{
			**chp_dst = '&';
			(*chp_dst)++;
			(*chp_src)++;
		}
	}else if( **chp_src == '<' ){
		(*chp_src) = strchr( *chp_src, '>' );
		if( (*chp_src) == NULL ){
		  **chp_dst = **chp_src;
		  (*chp_dst)++;
		  (*chp_src)++;
		}else{
		  (*chp_src)++;
		}
	}else{
		**chp_dst = **chp_src;
		(*chp_dst)++;
		(*chp_src)++;
	}
}

//! Datt@CXbh擾
/*!
 * Describe GetThread
 * K\gȂo[W
 * \param chp_filename Datt@C̃tpX
 * \return char* 
 */
BOOL Cq2chwmDatFile::GetName(
	CYoString &str_name,
	const char *chp_filename)
{
	FILE *fp = fopen(chp_filename, "r");
	if (fp == NULL) {
		return FALSE;
	}
	char cha_line[1024 * 16];
	CYoString str_line;
	cha_line[0] = 0x00;
	do {
		if (fgets(cha_line, sizeof(cha_line), fp) == NULL) {
			fclose( fp );
			return FALSE;
		}
		str_line += cha_line;
	} while (str_line.Find("\n") == -1);
	fclose(fp);
	str_line.Trim();
	const char *chp_sta = strrchr((const char*)str_line, '>');
	if (chp_sta == NULL) return FALSE;
	str_name = chp_sta + 1;
	str_name.Trim();

	return TRUE;
}

BOOL Cq2chwmDatFile::Delete(
	const char *chp_burl,
	const char *chp_aid)
{
	CYoString str_dir = UrlToPath(chp_burl);
	CYoString str_filename = str_dir;
	str_filename += "\\";
	str_filename += chp_aid;
	str_filename += ".dat";
	CYoString str_tmp;

	// Datt@C폜
	{
		str_tmp = (const char*)str_filename;
		RemoveFile(str_tmp);
	}

	// Infot@C폜
	{
		str_tmp = (const char*)str_dir;
		str_tmp += "\\info\\";
		str_tmp += chp_aid;
		RemoveFile(str_tmp);
	}

	// Articlet@C폜
	Cq2chwmArticleFile cArticle;
	cArticle.Create(chp_burl);
	cArticle.Remove(cArticle.Search(chp_aid));
	cArticle.Write();

	return TRUE;
}

//! DAT`r[`ɕϊ
/*!
 * DAT`: O<>[AhX<>t<>Rg<>Xbh\n
 * 
 * r[`: [Xԍ]O<[AhX>\nt\nRg\n
 * ɕϊ
 * XbhDATt@C1sڂ̂
 * chp_srcɂ͕̃XĂ悢K\nŏI邱(r[ȃXȂ)
 * \param str_name ()Xbh
 * \param chp_dst r[`̏݃AhX(\ȃmۂKv)
 * \param chp_src DAT`
 * \param in_msg JnXԍ
 * \param uin_new JnVXԍ(̒lȏ̃XԍVƂȂ)
 * \param pRegex NG[hK\(}b`X͂ځ[񂳂)
 * \param bo_transparentabone ځ[tO(TRUEœځ[)
 * \param pHideArray ځ[񃁃bZ[W̃XԔz
 * \param pImportantArray NG[hK\Ƀ}b`Ă̔zɓXԂ͂ځ[񂳂Ȃ
 * \return int I: chp_dstɏ܂ꂽoCg ُI: -1
 */
int Cq2chwmDatFile::Convert(
	CString &str_name,
	wchar_t *chp_dst,
	const wchar_t *chp_src,
	int in_msg,
	unsigned int uin_new,
	CYoRegex *pRegex,
	BOOL bo_transparentabone,
	BOOL bo_deleteblanklines,
	CYoPtrArray *pHideArray,
	CYoPtrArray *pImportantArray)
{
	if (chp_dst == NULL || chp_src == NULL) {
		return -1;
	}

	wchar_t *chp_outp = chp_dst;
	wchar_t *chp_inp = (wchar_t*)chp_src;
	wchar_t *chp_sta = chp_inp;
	wchar_t *chp_end;
	int in_len;

	while (*chp_sta != 0x00) {
		wchar_t *chp_tmp = chp_outp;

		// From ʂ̂
		*chp_outp = Cq2chwmEditCtrl::COLOR_FROM;
		chp_outp++;

		chp_outp += wsprintf(chp_outp, _T("[%d]"), in_msg);

		for (int i = 0; i < 3; i++) {
			chp_end = _tcsstr(chp_sta, _T("<>"));
			if (chp_end == NULL) {
				*chp_outp = 0x00;
				return chp_outp - chp_dst;
			}
			in_len = chp_end - chp_sta;
			switch (i) {
			case 0:		// O
				while (chp_sta < chp_end) {
					encodeTag(&chp_outp, (const wchar_t**)&chp_sta);
				}
				break;
			case 1:		// email
				*chp_outp = _T('<');
				chp_outp++;
				while (chp_sta < chp_end) {
					encodeTag(&chp_outp, (const wchar_t**)&chp_sta);
				}
				if (_tcsncmp(chp_outp - 4, _T("sage"), 4) == 0) {
					*chp_tmp = Cq2chwmEditCtrl::COLOR_FROM_WITHSAGE;
				} else if (*(chp_outp - 1) != _T('<')) {
					*chp_tmp = Cq2chwmEditCtrl::COLOR_FROM_WITHMAIL;
				}
				_tcscpy(chp_outp, _T(">\n"));
				chp_outp += 2;
				break;
			case 2:		// t
				*chp_outp = (unsigned int)(in_msg) >= uin_new ? Cq2chwmEditCtrl::COLOR_NEW : Cq2chwmEditCtrl::COLOR_DATE;
				chp_outp++;
				while (chp_sta < chp_end) {
				    encodeTag(&chp_outp, (const wchar_t**)&chp_sta);
				}
				*chp_outp = _T('\n');
				chp_outp++;
				break;
			}
			chp_sta = chp_end + 2;
			if (*chp_sta == _T(' ')) chp_sta++;
			if (*chp_sta == _T('\n')) break;
		}
		// bZ[W
		while (*chp_sta != 0x00 && *chp_sta != _T('\n')) {
			if (*chp_sta == _T('<')) {
				if (*(chp_sta+1) == _T('>')) {
					// bZ[W̏I
					wchar_t *chp_name = chp_sta + 2;
					chp_sta = _tcschr(chp_name, _T('\n'));
					if (chp_sta == NULL) {
						chp_sta = chp_name + _tcslen(chp_name);
					}
					if (in_msg == 1 && str_name.GetLength() == 0 && chp_name != chp_sta) {
						// Xbh擾
						str_name.SetString(chp_name, chp_sta-chp_name);
					}
					break;
				} else if (_tcsncmp( chp_sta + 1, _T("br>"), 3 ) == 0) {
					if (*(chp_outp-1) == _T(' ')) chp_outp--;

					// As폜
					if (bo_deleteblanklines == TRUE &&
						(*(chp_outp - 1) == _T('\n') && *(chp_outp - 2) == _T('\n') && *(chp_outp - 3) == _T('\n')))
					{
						// s3sȂ
						;
					} else {
						*chp_outp = _T('\n');
						chp_outp++;
					}
					chp_sta += 4;
					if (*chp_sta == _T(' ')) chp_sta++;
				} else {
					wchar_t *chp_tmp = _tcschr(chp_sta, _T('>'));
					if (chp_tmp != NULL) {
						chp_sta = chp_tmp;
					}
					chp_sta++;
				}
			} else {
				encodeTag(&chp_outp, (const wchar_t**)&chp_sta);
			}
		}
		*chp_outp = 0x00;		// NULL^[~l[g

 		if (pRegex != NULL && pRegex->Match( chp_tmp ) >= 0) {
			// importantXgɓĂ邩`FbN
			BOOL bo_exist_important = FALSE;
			if (pImportantArray != NULL) {
				for (int i = 0; i < pImportantArray->Count(); i++) {
					if (in_msg == (int)pImportantArray->Get(i)) {
						bo_exist_important = TRUE;
						break;
					}
				}
			}

			// importantXgɓĂ炠ځ[񂵂Ȃ
			if (bo_exist_important == FALSE) {
				if (bo_transparentabone == TRUE) {
					*chp_tmp = Cq2chwmEditCtrl::COLOR_ABONE;
					chp_tmp++;
					chp_outp = chp_tmp; // ځ[
				} else {
					*chp_tmp = Cq2chwmEditCtrl::COLOR_ABONE;
				}
			}
		}

		// XԂɂ郍[Jځ[
		if (pHideArray != NULL) {
			for (int i = 0; i < pHideArray->Count(); i++) {
				if (in_msg == (int)pHideArray->Get(i)) {
					if (bo_transparentabone == TRUE) {
						*chp_tmp = Cq2chwmEditCtrl::COLOR_ABONE;
						chp_tmp++;
						chp_outp = chp_tmp; // ځ[
					} else {
						*chp_tmp = Cq2chwmEditCtrl::COLOR_ABONE;
					}
					break;
				}
			}
		}

		in_msg++;

		if (*chp_sta == 0x00) {
			break;
		}
		chp_sta++;
		_tcscpy(chp_outp, _T(MSG_SEPARATOR));
		chp_outp += MSG_SEPARATOR_LEN;
	}

	// Ō̉s
	if (*(chp_outp - 1) == _T('\n')) {
		chp_outp--;
		*chp_outp = 0x00;
	}

	return chp_outp - chp_dst;
}

//! HTMLeLXgɕϊ
/*!
 * &gt; -> >
 * &lt; -> <
 * &amp; -> &
 * &nbsp; -> pXy[X
 * &quot; -> "
 * <.*>폜
 * \param *chp_dst 
 * \param *chp_src 
 * \return void 
 */
void Cq2chwmDatFile::encodeTag(
	wchar_t **chp_dst,
	const wchar_t **chp_src )
{
	struct _convert_list {
		wchar_t *lpszBefore;		// uO&܂܂Ȃ
		wchar_t chAfter;			// u̕
	};
	static struct _convert_list sta_convert_list[] = {
		{_T("gt;"), 62},
		{_T("lt;"), 60},
		{_T("quot;"), 34},
		{_T("amp;"), 38},
		{_T("nbsp;"), 160},
		{_T("omega;"), 969},
		{_T("hearts;"), 9829},
		{_T("spades;"), 9824},
		{_T("clubs;"), 9827},
		{_T("diams;"), 9830},
		{_T("iexcl;"), 161},
		{_T("cent;"), 162},
		{_T("pound;"), 163},
		{_T("curren;"), 164},
		{_T("yen;"), 165},
		{_T("brvbar;"), 166},
		{_T("sect;"), 167},
		{_T("uml;"), 168},
		{_T("copy;"), 169},
		{_T("ordf;"), 170},
		{_T("laquo;"), 171},
		{_T("not;"), 172},
		{_T("shy;"), 173},
		{_T("reg;"), 174},
		{_T("macr;"), 175},
		{_T("deg;"), 176},
		{_T("plusmn;"), 177},
		{_T("sup2;"), 178},
		{_T("sup3;"), 179},
		{_T("acute;"), 180},
		{_T("micro;"), 181},
		{_T("para;"), 182},
		{_T("middot;"), 183},
		{_T("cedil;"), 184},
		{_T("sup1;"), 185},
		{_T("ordm;"), 186},
		{_T("raquo;"), 187},
		{_T("frac14;"), 188},
		{_T("frac12;"), 189},
		{_T("frac34;"), 190},
		{_T("iquest;"), 191},
		{_T("Agrave;"), 192},
		{_T("Aacute;"), 193},
		{_T("Acirc;"), 194},
		{_T("Atilde;"), 195},
		{_T("Auml;"), 196},
		{_T("Aring;"), 197},
		{_T("AElig;"), 198},
		{_T("Ccedil;"), 199},
		{_T("Egrave;"), 200},
		{_T("Eacute;"), 201},
		{_T("Ecirc;"), 202},
		{_T("Euml;"), 203},
		{_T("Igrave;"), 204},
		{_T("Iacute;"), 205},
		{_T("Icirc;"), 206},
		{_T("Iuml;"), 207},
		{_T("ETH;"), 208},
		{_T("Ntilde;"), 209},
		{_T("Ograve;"), 210},
		{_T("Oacute;"), 211},
		{_T("Ocirc;"), 212},
		{_T("Otilde;"), 213},
		{_T("Ouml;"), 214},
		{_T("times;"), 215},
		{_T("Oslash;"), 216},
		{_T("Ugrave;"), 217},
		{_T("Uacute;"), 218},
		{_T("Ucirc;"), 219},
		{_T("Uuml;"), 220},
		{_T("Yacute;"), 221},
		{_T("THORN;"), 222},
		{_T("szlig;"), 223},
		{_T("agrave;"), 224},
		{_T("aacute;"), 225},
		{_T("acirc;"), 226},
		{_T("atilde;"), 227},
		{_T("auml;"), 228},
		{_T("aring;"), 229},
		{_T("aelig;"), 230},
		{_T("ccedil;"), 231},
		{_T("egrave;"), 232},
		{_T("eacute;"), 233},
		{_T("ecirc;"), 234},
		{_T("euml;"), 235},
		{_T("igrave;"), 236},
		{_T("iacute;"), 237},
		{_T("icirc;"), 238},
		{_T("iuml;"), 239},
		{_T("eth;"), 240},
		{_T("ntilde;"), 241},
		{_T("ograve;"), 242},
		{_T("oacute;"), 243},
		{_T("ocirc;"), 244},
		{_T("otilde;"), 245},
		{_T("ouml;"), 246},
		{_T("divide;"), 247},
		{_T("oslash;"), 248},
		{_T("ugrave;"), 249},
		{_T("uacute;"), 250},
		{_T("ucirc;"), 251},
		{_T("uuml;"), 252},
		{_T("yacute;"), 253},
		{_T("thorn;"), 254},
		{_T("yuml;"), 255},
		{_T("OElig;"), 338},
		{_T("oelig;"), 339},
		{_T("Scaron;"), 352},
		{_T("scaron;"), 353},
		{_T("Yuml;"), 376},
		{_T("circ;"), 710},
		{_T("tilde;"), 732},
		{_T("fnof;"), 402},
		{_T("Alpha;"), 913},
		{_T("Beta;"), 914},
		{_T("Gamma;"), 915},
		{_T("Delta;"), 916},
		{_T("Epsilon;"), 917},
		{_T("Zeta;"), 918},
		{_T("Eta;"), 919},
		{_T("Theta;"), 920},
		{_T("Iota;"), 921},
		{_T("Kappa;"), 922},
		{_T("Lambda;"), 923},
		{_T("Mu;"), 924},
		{_T("Nu;"), 925},
		{_T("Xi;"), 926},
		{_T("Omicron;"), 927},
		{_T("Pi;"), 928},
		{_T("Rho;"), 929},
		{_T("Sigma;"), 931},
		{_T("Tau;"), 932},
		{_T("Upsilon;"), 933},
		{_T("Phi;"), 934},
		{_T("Chi;"), 935},
		{_T("Psi;"), 936},
		{_T("Omega;"), 937},
		{_T("alpha;"), 945},
		{_T("beta;"), 946},
		{_T("gamma;"), 947},
		{_T("delta;"), 948},
		{_T("epsilon;"), 949},
		{_T("zeta;"), 950},
		{_T("eta;"), 951},
		{_T("theta;"), 952},
		{_T("iota;"), 953},
		{_T("kappa;"), 954},
		{_T("lambda;"), 955},
		{_T("mu;"), 956},
		{_T("nu;"), 957},
		{_T("xi;"), 958},
		{_T("omicron;"), 959},
		{_T("pi;"), 960},
		{_T("rho;"), 961},
		{_T("sigmaf;"), 962},
		{_T("sigma;"), 963},
		{_T("tau;"), 964},
		{_T("upsilon;"), 965},
		{_T("phi;"), 966},
		{_T("chi;"), 967},
		{_T("psi;"), 968},
		{_T("thetasym;"), 977},
		{_T("upsih;"), 978},
		{_T("piv;"), 982},
		{_T("ensp;"), 8194},
		{_T("emsp;"), 8195},
		{_T("thinsp;"), 8201},
		{_T("zwnj;"), 8204},
		{_T("zwj;"), 8205},
		{_T("lrm;"), 8206},
		{_T("rlm;"), 8207},
		{_T("ndash;"), 8211},
		{_T("mdash;"), 8212},
		{_T("lsquo;"), 8216},
		{_T("rsquo;"), 8217},
		{_T("sbquo;"), 8218},
		{_T("ldquo;"), 8220},
		{_T("rdquo;"), 8221},
		{_T("bdquo;"), 8222},
		{_T("dagger;"), 8224},
		{_T("Dagger;"), 8225},
		{_T("bull;"), 8226},
		{_T("hellip;"), 8230},
		{_T("permil;"), 8240},
		{_T("prime;"), 8242},
		{_T("Prime;"), 8243},
		{_T("lsaquo;"), 8249},
		{_T("rsaquo;"), 8250},
		{_T("oline;"), 8254},
		{_T("frasl;"), 8260},
		{_T("euro;"), 8364},
		{_T("image;"), 8465},
		{_T("ewierp;"), 8472},
		{_T("real;"), 8476},
		{_T("trade;"), 8482},
		{_T("alefsym;"), 8501},
		{_T("larr;"), 8592},
		{_T("uarr;"), 8593},
		{_T("rarr;"), 8594},
		{_T("darr;"), 8595},
		{_T("harr;"), 8596},
		{_T("crarr;"), 8629},
		{_T("lArr;"), 8656},
		{_T("uArr;"), 8657},
		{_T("rArr;"), 8658},
		{_T("dArr;"), 8659},
		{_T("hArr;"), 8660},
		{_T("forall;"), 8704},
		{_T("part;"), 8706},
		{_T("exist;"), 8707},
		{_T("empty;"), 8709},
		{_T("nabla;"), 8711},
		{_T("isin;"), 8712},
		{_T("notin;"), 8713},
		{_T("ni;"), 8715},
		{_T("prod;"), 8719},
		{_T("sum;"), 8721},
		{_T("minus;"), 8722},
		{_T("lowast;"), 8727},
		{_T("radic;"), 8730},
		{_T("prop;"), 8733},
		{_T("infin;"), 8734},
		{_T("ang;"), 8736},
		{_T("and;"), 8743},
		{_T("or;"), 8744},
		{_T("cap;"), 8745},
		{_T("cup;"), 8746},
		{_T("int;"), 8747},
		{_T("there4;"), 8756},
		{_T("sim;"), 8764},
		{_T("cong;"), 8773},
		{_T("asymp;"), 8776},
		{_T("ne;"), 8800},
		{_T("equiv;"), 8801},
		{_T("le;"), 8804},
		{_T("ge;"), 8805},
		{_T("sub;"), 8834},
		{_T("sup;"), 8835},
		{_T("nsub;"), 8836},
		{_T("sube;"), 8838},
		{_T("supe;"), 8839},
		{_T("oplus;"), 8853},
		{_T("otimes;"), 8855},
		{_T("perp;"), 8869},
		{_T("sdot;"), 8901},
		{_T("lceil;"), 8968},
		{_T("rceil;"), 8969},
		{_T("lfloor;"), 8970},
		{_T("rfloor;"), 8971},
		{_T("lang;"), 9001},
		{_T("rang;"), 9002},
		{_T("loz;"), 9674},
	};

	if (**chp_src == _T('&')) {
		if (*(*chp_src + 1) == _T('#')) {
			wchar_t wcha_tmp[8] = {0};
			(*chp_src) += 2;
			for (int i = 0; i < 5 && *(*chp_src) != 0 &&
				(*(*chp_src) >= _T('0') && *(*chp_src) <= _T('9') ||
				*(*chp_src) >= _T('a') && *(*chp_src) <= _T('z') ||
				*(*chp_src) >= _T('A') && *(*chp_src) <= _T('Z')); i++)
			{
				wcha_tmp[i] = *(*chp_src);
				(*chp_src)++;
			}
			if (wcha_tmp[0] != 0) {
				if (wcha_tmp[0] == _T('x')) {
					**chp_dst = (wchar_t)wcstol(wcha_tmp + 1, NULL, 16);
				} else {
					**chp_dst = (wchar_t)_wtoi(wcha_tmp);
				}
				(*chp_dst)++;
				if (*(*chp_src) == _T(';')) {
					(*chp_src)++;
				}
			}
		} else {
			int i;
			for (i = 0; i < sizeof(sta_convert_list) / sizeof(sta_convert_list[0]); i++) {
				BOOL bo_match = TRUE;
				int in_len = 0;
				for (int j = 0; sta_convert_list[i].lpszBefore[j] != 0; j++) {
					if (*(*chp_src + 1 + j) != sta_convert_list[i].lpszBefore[j]) {
						bo_match = FALSE;
						break;
					}
					in_len++;
				}
				if (bo_match == TRUE) {
					**chp_dst = sta_convert_list[i].chAfter;
					(*chp_dst)++;
					(*chp_src) += in_len + 1;
					break;
				}
			}
			if (i == sizeof(sta_convert_list) / sizeof(sta_convert_list[0])) {
				**chp_dst = _T('&');
				(*chp_dst)++;
				(*chp_src)++;
			}
		}
	} else if (**chp_src == _T('<')) {
		(*chp_src) = _tcschr(*chp_src, _T('>'));
		if ((*chp_src) == NULL) {
		  **chp_dst = **chp_src;
		  (*chp_dst)++;
		  (*chp_src)++;
		} else {
		  (*chp_src)++;
		}
	} else {
		**chp_dst = **chp_src;
		(*chp_dst)++;
		(*chp_src)++;
	}
}
