#include "stdafx.h"
#include "q2chwmBbsManager.h"
#include "q2chwmDatCtrl.h"
#include "q2chwmConfig.h"
#include "q2chwmDatFile.h"
#include "q2chwmArticleFile.h"
#include "q2chwmNgFile.h"
#include "YoTime.h"

Cq2chwmDatCtrl::Cq2chwmDatCtrl(CWnd *pParent, CWnd *pMain)
: m_cArrayFromLine(1000)
{
	m_pMain = pMain;
	m_pParent = pParent;
	m_cEdit.Create(m_pParent, 0, 0, 0, 0);
	m_cEdit.SetWrap(TRUE);
	m_bo_running = FALSE;
	m_in_width = 0;
	m_in_font_size = 0;
	m_bo_font_bold = FALSE;
	m_pRegex = NULL;
	m_bo_transparentabone = Cq2chwmConfig::GetInstance()->GetTransParentAbone();
}

Cq2chwmDatCtrl::~Cq2chwmDatCtrl()
{
	if (ExistFile(GetFileName()) == TRUE) {
		Cq2chwmArticleFile cArticle;
		cArticle.Create(GetBoardUrl());
		cArticle.SetSeen(GetArticleId(), GetMessageCount(), FALSE);
		cArticle.Write();

		m_cInfo.SetNumber(GetCurrentMessageNumber());
		m_cInfo.Write();
	}
	if (m_pRegex != NULL) delete m_pRegex;
}

int Cq2chwmDatCtrl::Reload()
{
	Clear();
	return Create(m_str_aname, m_str_aid, m_str_bname, m_str_burl, m_str_bid);
}

int Cq2chwmDatCtrl::Create(
	const char *chp_aname,
	const char *chp_aid,
	const char *chp_bname,
	const char *chp_burl,
	const char *chp_bid)
{
	m_str_bname = chp_bname;
	m_str_burl = chp_burl;
	m_str_bid = chp_bid;
	m_str_aname = chp_aname;
	m_str_aid = chp_aid;
	m_str_aurl = m_str_burl + m_str_aid;
	m_str_url = m_str_burl + "dat/" + m_str_aid + ".dat";
	m_str_filename = UrlToPath(chp_burl);
	m_str_filename += "\\" + m_str_aid + ".dat";

	if (ExistFile(m_str_filename) == FALSE) {
		if (Cq2chwmConfig::GetInstance()->GetOnline() == TRUE ||
			::MessageBox(m_pParent->m_hWnd, _T("t@C݂܂BT[o擾܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES)
		{
			return CreateFromHttp();
		}
		return ERR_NONE;
	}
	int in_ret = CreateFromFile();
	if (in_ret != ERR_NONE) {
		return in_ret;
	}

	if (Cq2chwmConfig::GetInstance()->GetOnline() == TRUE) {
		return CreateFromHttp();
	}
	return ERR_NONE;
}

int Cq2chwmDatCtrl::CreateFromFile()
{
	CYoTime cTime;
	CString cstr_filename;
	cstr_filename = m_str_filename;
	CFile cFile;
	if (cFile.Open(cstr_filename, CFile::modeRead) == FALSE) {
		return ERR_FILE_OPEN;
	}

	int in_filesize = (int)cFile.GetLength();
	if (in_filesize == 0) {
		cFile.Close();
		return ERR_NONE;
	}

	// t@Cǂݍݗ̈ƕϊ̈m
	char *chp_in = (char*)malloc(sizeof(char) * in_filesize + 1);
	char *chp_out = (char*)malloc(sizeof(char) * in_filesize * 2 + 1);

	// ǂݍ
	cFile.Read(chp_in, in_filesize);
	chp_in[in_filesize] = 0x00;

	// infot@Cǂݍ
	if (m_cInfo.Create(GetBoardUrl(), GetArticleId()) == FALSE) {
		m_cInfo.SetNumber(1);
	}

	// Ǖ\
	int in_seen;
	if (m_cInfo.GetNew() == TRUE) {
		// VtOĂȂ{ő僌Xԍȍ~𖢓Ǖ\
		in_seen = m_cInfo.GetMax();
	} else {
		// VtOĂȂȂSĊǕ\
		in_seen = m_cInfo.GetCount();
	}

	// NG[hK\ǂݍ
	CYoString str_pat = Cq2chwmNgFile::GetInstance()->GetPattern(GetBoardUrl(), GetArticleId());
	if (m_pRegex != NULL) delete m_pRegex;
	if (str_pat.Length() > 0) {
		m_pRegex = new CYoRegex(str_pat, CYoRegex::SJIS, TRUE);
	}

	// ϊ
	CYoString str_name;
	int in_len = Cq2chwmDatFile::Convert(str_name, chp_out, chp_in, 1, in_seen + 1, m_pRegex, m_bo_transparentabone,
		Cq2chwmConfig::GetInstance()->GetDeleteBlankLines(), NULL, NULL);
	if (str_name.Length() > 0) {
		m_str_aname = str_name;
	}
	free(chp_in);

	m_cEdit.SetAutoUpdate(FALSE);
	m_cEdit.AddText(chp_out, in_len);
	createIndex();

	// ǈʒuփWv
	JumpNumber(m_cInfo.GetNumber());
	m_cEdit.SetAutoUpdate(TRUE);

	// Ō̃XFroms܂ňړVtOIt
	if (m_cEdit.GetTopLine() >= (int)m_cArrayFromLine.Get(GetLastMessageNumber() - 1)) {
		m_cInfo.SetNew(FALSE);
		m_cInfo.Write();
	}

	// 
	free(chp_out);
	cFile.Close();

	PRINTLOG("%d(msec)", cTime.Elapsed());
	return ERR_NONE;
}

void Cq2chwmDatCtrl::createIndex(
	int in_line)
{
	CYoTime cTime;
	if (in_line == 0) m_cArrayFromLine.RemoveAll();
	int in_count = m_cEdit.GetLines();
	for (int i = in_line; i < in_count; i++) {
		TCHAR *wchp_line = m_cEdit.GetLine(i);
		if (wchp_line == NULL) continue;
		if (wchp_line[0] == Cq2chwmEditCtrl::COLOR_FROM ||
			wchp_line[0] == Cq2chwmEditCtrl::COLOR_FROM_WITHMAIL ||
			wchp_line[0] == Cq2chwmEditCtrl::COLOR_FROM_WITHSAGE ||
			wchp_line[0] == Cq2chwmEditCtrl::COLOR_ABONE)
		{
			m_cArrayFromLine.Add(i);
		}
	}
	PRINTLOG("done [%s][%d]%d(msec)", GetArticleId(), m_cArrayFromLine.Count(), cTime.Elapsed());
}

BOOL Cq2chwmDatCtrl::isAboneLine(
	int in_line)
{
	if (m_bo_transparentabone == FALSE) return FALSE;
	TCHAR *wchp_line = m_cEdit.GetLine(in_line);
	return wchp_line[0] == Cq2chwmEditCtrl::COLOR_ABONE;
}

int Cq2chwmDatCtrl::CreateFromHttp()
{
	if (m_bo_running == TRUE) return TRUE;
	m_bo_running = TRUE;
	m_pMain->SendMessage(WM_USER_SHOWSTATUSBAR, 0, (LPARAM)TRUE);

	// infot@Cǂݍ
	if (m_cInfo.Create(GetBoardUrl(), GetArticleId()) == FALSE) {
		m_cInfo.SetNumber(1);
	}

	ResetNewKey();
	int in_ret = Cq2chwmBbsManager::GetInstance()->HttpGet(m_pMain, GetBoardUrl(), GetArticleId(), m_str_err);

	m_bo_running = FALSE;
	m_pMain->SendMessage(WM_USER_SHOWSTATUSBAR, 0, (LPARAM)FALSE);

	return in_ret;
}

void Cq2chwmDatCtrl::OnCustomMessage(
	Cq2chwmMessage *pMessage)
{
	switch (pMessage->GetType()) {
		case Cq2chwmMessage::TYPE_OPENFILE:
			ULONGLONG ull_length;
			if (ExistFile(pMessage->GetFileName(), &ull_length) == FALSE || ull_length == 0) {
				Clear();
			}
			PRINTLOG("TYPE_OPENFILE: %s:%s(%d)",
				(const char *)m_str_aname, pMessage->GetFileName(), ull_length);
			break;
		case Cq2chwmMessage::TYPE_CLOSEFILE:
		{
			Cq2chwmCloseFileMessage *pCloseFileMessage = (Cq2chwmCloseFileMessage*)pMessage;
			if (pCloseFileMessage->GetWriteSize() > 0) {
				// VtOI
				m_cInfo.SetNew(TRUE);
				m_cInfo.SetCount(GetMessageCount());
				m_cInfo.Write();
			}
			break;
		}
		case Cq2chwmMessage::TYPE_WRITEFILE:
		{
			Cq2chwmWriteFileMessage *pWriteFileMessage = (Cq2chwmWriteFileMessage*)pMessage;
			const char *chp_in = pWriteFileMessage->GetData();
			int in_len = strlen(chp_in);
			PRINTLOG("TYPE_WRITEFILE: %s:%d:%d",
				(const char *)m_str_aname, m_cArrayFromLine.Count(), in_len);
			char *chp_out = (char*)malloc(sizeof(char) * in_len * 4);
			CYoString str_name;
			int in_out_len = Cq2chwmDatFile::Convert(str_name, chp_out, chp_in, m_cArrayFromLine.Count() + 1,
				m_cArrayFromLine.Count() + 1, m_pRegex, m_bo_transparentabone, Cq2chwmConfig::GetInstance()->GetDeleteBlankLines(),
				NULL, NULL);
			if (str_name.Length() > 0) {
				m_str_aname = str_name;
			}

			if (m_cArrayFromLine.Count() > 0) m_cEdit.AddText("\r\n", 2);
			m_cEdit.AddText(chp_out, in_out_len);
			createIndex();
			free(chp_out);
			PRINTLOG("TYPE_WRITEFILE: Added %s:%d:%d",
				(const char *)m_str_aname, m_cArrayFromLine.Count(), in_len);
			break;
		}
		case Cq2chwmMessage::TYPE_RELOADFILE:
			CreateFromFile();
			break;
		case Cq2chwmMessage::TYPE_CLOSETAB:
			break;
	};
}

void Cq2chwmDatCtrl::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	if (Cq2chwmConfig::GetInstance()->IsKeyNext(nChar)) {
		if (JumpNextMessage() == FALSE) {
			// ̐VubN}[N
			AfxGetMainWnd()->SendMessage(WM_USER_NEXTARTICLE, 0, 0);
		}
	} else if (Cq2chwmConfig::GetInstance()->IsKeyPrev(nChar)) {
		JumpPrevMessage();
	} else if (Cq2chwmConfig::GetInstance()->IsKeyNextLine(nChar)) {
		JumpNextLine();
	} else if (Cq2chwmConfig::GetInstance()->IsKeyPrevLine(nChar)) {
		JumpPrevLine();
	} else if (Cq2chwmConfig::GetInstance()->IsKeyBottom(nChar)) {
		JumpLastMessage();
	} else if (Cq2chwmConfig::GetInstance()->IsKeyTop(nChar)) {
		JumpFirstMessage();
	} else if (Cq2chwmConfig::GetInstance()->IsKeyNextLink(nChar)) {
		if ((GetKeyState(VK_SHIFT) & 0x8000) == 0) {
			JumpNextLink();
		} else {
			JumpPrevLink();
		}
	} else if (Cq2chwmConfig::GetInstance()->IsKeyPrevLink(nChar)) {
		JumpPrevLink();
	} else if (Cq2chwmConfig::GetInstance()->IsKeyBack(nChar)) {
		JumpBack();
	} else if (nChar == VK_RETURN) {
		Jump();
	}else {
		m_cEdit.OnKeyDown(nChar, nRepCnt, nFlags);
	}

	// ő{Xԍۑ
	m_cInfo.SetMax(max(GetCurrentMessageNumber(), m_cInfo.GetMax()));

	// Ō̃XFroms܂ňړVtOIt
	if (m_cEdit.GetTopLine() >= (int)m_cArrayFromLine.Get(GetLastMessageNumber() - 1)) {
		m_cInfo.SetNew(FALSE);
		m_cInfo.Write();
	}
}

void Cq2chwmDatCtrl::JumpNumber(
	int in_number)
{
	PRINTLOG("%d", in_number);
	if (in_number > m_cArrayFromLine.Count()) return;
	m_cEdit.SetTopLine((int)m_cArrayFromLine.Get(in_number - 1));
}

void Cq2chwmDatCtrl::JumpUrl(
	const char *chp_url)
{
	PRINTLOG("%s", chp_url);
	// ʃXbhĴ͐eEBhEȂ̂ŐeɃbZ[WM
	m_pMain->SendMessage(WM_USER_OPENURL, 0, (LPARAM)chp_url);
}

#define PAT_URL			"[h]*ttp[s]*://[!-~]+"
#define PAT_NUM			"[>|]*[>|]([0-9O-X]+)"
#define PAT_NUM_NAME	"[\\]][ @]*([0-9O-X]+)[ @]*<"
void Cq2chwmDatCtrl::Jump()
{
	CYoRegex cRegexNum(PAT_NUM, CYoRegex::SJIS);
	CYoRegex cRegexNumName(PAT_NUM_NAME, CYoRegex::SJIS);
	CYoRegex cRegexUrl(PAT_URL, CYoRegex::SJIS);
	CString cstr_text;
	if (m_cEdit.GetSelectedString(cstr_text) == TRUE) {
		// I𕶎NƂ݂Ȃ
		CYoString str_text = A(cstr_text);
		if (cRegexNum.Match(str_text) >= 0) {
			m_cArrayJumpHistory.Add(m_cEdit.GetTopLine());
			JumpNumber(Atoi(cRegexNum.Get(1)));
			return;
		} else if (cRegexNumName.Match(str_text) >= 0) {
			m_cArrayJumpHistory.Add(m_cEdit.GetTopLine());
			JumpNumber(Atoi(cRegexNumName.Get(1)));
			return;
		} else if (cRegexUrl.Match(str_text) >= 0) {
			JumpUrl(cRegexUrl.Get(0));
			return;
		}
	}
}

void Cq2chwmDatCtrl::JumpBack()
{
	int in_count = m_cArrayJumpHistory.Count();
	if (in_count == 0) return;
	int in_line = (int)m_cArrayJumpHistory.Get(in_count - 1);
	m_cArrayJumpHistory.Remove(in_count - 1);
	m_cEdit.SetTopLine(in_line);
}

void Cq2chwmDatCtrl::JumpNextLink()
{
	m_cEdit.SearchNext(PAT_NUM"|"PAT_NUM_NAME"|"PAT_URL);
	return;
}

void Cq2chwmDatCtrl::JumpPrevLink()
{
	m_cEdit.SearchPrev(PAT_NUM"|"PAT_NUM_NAME"|"PAT_URL);
	return;
}

void Cq2chwmDatCtrl::JumpNextLine(
	BOOL bo_link)
{
	if (bo_link == TRUE) {
		if (m_cEdit.SearchNext(PAT_NUM"|"PAT_NUM_NAME"|"PAT_URL, TRUE) == FALSE) {
			m_cEdit.ScrollVertical(TRUE, 1);
		}
	} else {
		m_cEdit.ScrollVertical(TRUE, 1);
	}
	return;
}

void Cq2chwmDatCtrl::JumpPrevLine(
	BOOL bo_link)
{
	if (bo_link == TRUE) {
		if (m_cEdit.SearchPrev(PAT_NUM"|"PAT_NUM_NAME"|"PAT_URL, TRUE) == FALSE) {
			m_cEdit.ScrollVertical(FALSE, 1);
		}
	} else {
		m_cEdit.ScrollVertical(FALSE, 1);
	}
	return;
}

BOOL Cq2chwmDatCtrl::JumpNextMessage()
{
	int in_top = m_cEdit.GetTopLine();
	int in_line = -1;
	for (int i = 0; i < m_cArrayFromLine.Count(); i++) {
		if (in_top < (int)m_cArrayFromLine.Get(i) && isAboneLine((int)m_cArrayFromLine.Get(i)) == FALSE) {
			in_line = (int)m_cArrayFromLine.Get(i);
			break;
		}
	}
	if (in_line == -1) in_line = m_cEdit.GetLines() - 1;
	if (Cq2chwmConfig::GetInstance()->GetNextControl() == TRUE &&
		m_cEdit.IsVisibleLine(in_line) == FALSE)
	{
		// XړŒlɃ`FbNĂĈړ悪ʊOȂy[W_E
		SendMessage(WM_KEYDOWN, VK_NEXT);
		return TRUE;
	} else if (in_line != m_cEdit.GetLines() - 1) {
		m_cEdit.SetTopLine(in_line);
		return TRUE;
	}
	return FALSE;
}

BOOL Cq2chwmDatCtrl::JumpPrevMessage()
{
	int in_top = m_cEdit.GetTopLine();
	int in_line = -1;
	for (int i = m_cArrayFromLine.Count() - 1; i >= 0; i--) {
		if (in_top > (int)m_cArrayFromLine.Get(i) && isAboneLine((int)m_cArrayFromLine.Get(i)) == FALSE) {
			in_line = (int)m_cArrayFromLine.Get(i);
			break;
		}
	}
	if (in_line == -1) {
		return FALSE;
	}
	m_cEdit.SetTopLine(in_line);
	return TRUE;
}

BOOL Cq2chwmDatCtrl::ResetNewKey()
{
	for (int i = 0; i < m_cArrayFromLine.Count(); i++) {
		// Os
		int in_line = (int)m_cArrayFromLine.Get(i);

		// Os΂
		while (m_cEdit.IsLineEnd(in_line) == FALSE) in_line++;
		in_line++;
		TCHAR *chp_tmp = m_cEdit.GetLine(in_line);
		if (chp_tmp == NULL) {
			return FALSE;
		}
		*chp_tmp = Cq2chwmEditCtrl::COLOR_DATE;
	}
	return TRUE;
}

void Cq2chwmDatCtrl::JumpFirstMessage()
{
	m_cArrayJumpHistory.Add(m_cEdit.GetTopLine());
	m_cEdit.SetTopLine((int)m_cArrayFromLine.Get(GetFirstMessageNumber() - 1));
}

void Cq2chwmDatCtrl::JumpLastMessage()
{
	m_cArrayJumpHistory.Add(m_cEdit.GetTopLine());
	m_cEdit.SetTopLine((int)m_cArrayFromLine.Get(GetLastMessageNumber() - 1));

	// j[Ă΂ꂽꍇOnKeyDown̐VtOItsȂ߃\bhŃ`FbN
	// Ō̃XFroms܂ňړVtOIt
	if (m_cEdit.GetTopLine() >= (int)m_cArrayFromLine.Get(GetLastMessageNumber() - 1)) {
		m_cInfo.SetNew(FALSE);
		m_cInfo.Write();
	}
}

int Cq2chwmDatCtrl::GetLastMessageNumber()
{
	int in_no;
	for (in_no = m_cArrayFromLine.Count(); isAboneLine((int)m_cArrayFromLine.Get(in_no - 1)) == TRUE; in_no--) {
		// ځ[񃁃bZ[W͔΂
		;
	}
	return in_no;
}

int Cq2chwmDatCtrl::GetFirstMessageNumber()
{
	int in_no;
	for (in_no = 1; isAboneLine((int)m_cArrayFromLine.Get(in_no - 1)) == TRUE; in_no++) {
		// ځ[񃁃bZ[W͔΂
		;
	}
	return in_no;
}

BOOL Cq2chwmDatCtrl::MoveWindow(
	int x,
	int y,
	int cx,
	int cy)
{
	int in_no = GetCurrentMessageNumber();
	m_cEdit.MoveWindow(x, y, cx, cy);
	if (m_in_width != cx) {
		createIndex();
		m_in_width = cx;
	}
	JumpNumber(in_no);
	return TRUE;
}

int Cq2chwmDatCtrl::GetCurrentMessageNumber()
{
	int i = 0;
	int in_line = m_cEdit.GetTopLine();
	for (i = 0; i < m_cArrayFromLine.Count(); i++) {
		if (in_line < (int)m_cArrayFromLine.Get(i)) {
			break;
		}
	}
	return i;
}

void Cq2chwmDatCtrl::GetMessageText(
	int in_number,
	CString& cstr_text,
	BOOL bo_all,			// OAt܂߂ꍇTRUE
	BOOL bo_ext)			// q2chg܂߂ꍇTRUE
{
	int in_first = (int)m_cArrayFromLine.Get(in_number - 1);
	if (bo_all == FALSE) {
		// Os΂
		while (m_cEdit.IsLineEnd(in_first) == FALSE) in_first++;
		in_first++;

		// ts΂
		while (m_cEdit.IsLineEnd(in_first) == FALSE) in_first++;
		in_first++;
	}
	int in_last;
	if (in_number >= m_cArrayFromLine.Count()) {
		in_last = m_cEdit.GetLines();
	} else {
		in_last = (int)m_cArrayFromLine.Get(in_number);
	}

	cstr_text = "";
	for (int i = in_first; i < in_last; i++) {
		CString cstr_line;
		m_cEdit.GetLineString(i, cstr_line, bo_ext);
		cstr_text += cstr_line;
		if (m_cEdit.IsLineEnd(i) == TRUE) cstr_text += "\r\n";
	}
}

void Cq2chwmDatCtrl::GetCurrentMessageText(
	CString& cstr_text,
	BOOL bo_all,			// OAt܂߂ꍇTRUE
	BOOL bo_ext)			// q2chg܂߂ꍇTRUE
{
	return GetMessageText(GetCurrentMessageNumber(), cstr_text, bo_all, bo_ext);
}

void Cq2chwmDatCtrl::Copy()
{
	m_cEdit.Copy();
}

BOOL Cq2chwmDatCtrl::Write()
{
	CYoTime cTime;
	int in_current_number = GetCurrentMessageNumber();
	if (m_cInfo.GetNumber() != in_current_number) {
		m_cInfo.SetNumber(in_current_number);
		m_cInfo.Write();
	}
	PRINTLOG("done [%s]%d(msec)", GetArticleId(), cTime.Elapsed());
	return TRUE;
}

void Cq2chwmDatCtrl::Clear()
{
	m_cEdit.Clear();
}

void Cq2chwmDatCtrl::Delete()
{
	Cq2chwmDatFile::Delete(GetBoardUrl(), GetArticleId());
}

void Cq2chwmDatCtrl::SetFont(
	const char *chp_name,
	int in_size,
	BOOL bo_bold)
{
	if (m_str_font_name == chp_name && m_in_font_size == in_size && m_bo_font_bold == bo_bold) return;
	m_cEdit.SetFont(chp_name, in_size, bo_bold);
	createIndex();
	m_str_font_name = chp_name;
	m_in_font_size = in_size;
	m_bo_font_bold = bo_bold;
}

void Cq2chwmDatCtrl::SetWrap(
	BOOL bo_wrap)
{
	if (m_cEdit.GetWrap() == bo_wrap) return;
	int in_no = GetCurrentMessageNumber();
	m_cEdit.SetWrap(bo_wrap);
	createIndex();
	JumpNumber(in_no);
}

BOOL Cq2chwmDatCtrl::GetWrap()
{
	return m_cEdit.GetWrap();
}

void Cq2chwmDatCtrl::SetTransParentAbone(
	BOOL bo_flg)
{
	if (m_bo_transparentabone == bo_flg) return;
	m_bo_transparentabone = bo_flg;
	Reload();
}

BOOL Cq2chwmDatCtrl::GetTransParentAbone()
{
	return m_bo_transparentabone;
}

BOOL Cq2chwmDatCtrl::ShowWindow(
	int in_cmd)
{
	if (in_cmd == SW_SHOW && GetTransParentAbone() == TRUE) {
		// ʕ\Aځ[lĐVtOăZbg
		// Ō̃XFroms܂ňړVtOIt
		if (m_cEdit.GetTopLine() >= (int)m_cArrayFromLine.Get(GetLastMessageNumber() - 1)) {
			m_cInfo.SetNew(FALSE);
			m_cInfo.Write();
		}
	}
	return m_cEdit.ShowWindow(in_cmd);
}

BOOL Cq2chwmDatCtrl::GetSelectedString(
	CString& cstr_text)
{
	if (m_cEdit.GetSelectedString(cstr_text) == FALSE) {
		return FALSE;
	}
	return TRUE;
}

LRESULT Cq2chwmDatCtrl::SendMessage(
	int msg,
	WPARAM wParam,
	LPARAM lParam)
{
	return ::SendMessage(m_cEdit.m_hWnd, msg, wParam, lParam);
}

BOOL Cq2chwmDatCtrl::GetMessageId(
	int in_number,
	CString& cstr_id)
{
	// Os̍sԍ擾
	int in_line = (int)m_cArrayFromLine.Get(in_number - 1);

	// Os΂
	while (m_cEdit.IsLineEnd(in_line) == FALSE) in_line++;
	in_line++;

	// ts̕擾
	CString cstr_line;
	m_cEdit.GetLineString(in_line, cstr_line, FALSE);
	while (m_cEdit.IsLineEnd(in_line) == FALSE) {
		in_line++;
		CString cstr_tmp;
		m_cEdit.GetLineString(in_line, cstr_tmp, FALSE);
		cstr_line += cstr_tmp;
	}

	// ID擾
	int in_start = cstr_line.Find(_T("ID:"));
	if (in_start == -1) return FALSE;
	in_start += 3;

	// pXy[X΂
	while (cstr_line[in_start] == _T(' ')) in_start++;

	int in_end = cstr_line.Find(_T(' '), in_start);
	if (in_end == -1) {
		cstr_id = cstr_line.Mid(in_start);
	} else {
		cstr_id = cstr_line.Mid(in_start, in_end - in_start);
	}
	cstr_id.Trim();
	return TRUE;
}

BOOL Cq2chwmDatCtrl::GetMessageName(
	int in_number,
	CString& cstr_name)
{
	// Os̍sԍ擾
	int in_line = (int)m_cArrayFromLine.Get(in_number - 1);

	// Os̕擾
	CString cstr_line;
	m_cEdit.GetLineString(in_line, cstr_line, FALSE);
	while (m_cEdit.IsLineEnd(in_line) == FALSE) {
		in_line++;
		CString cstr_tmp;
		m_cEdit.GetLineString(in_line, cstr_tmp, FALSE);
		cstr_line += cstr_tmp;
	}

	// O擾
	// TODO: [AhX<ƐO擾ł܂
	int in_start = cstr_line.Find(_T(']'));
	if (in_start == -1) return FALSE;
	in_start++;
	int in_end = cstr_line.ReverseFind(_T('<'));
	if (in_end == -1) return FALSE;
	cstr_name = cstr_line.Mid(in_start, in_end - in_start);
	cstr_name.Trim();
	return TRUE;
}

void Cq2chwmDatCtrl::CopyMessage(
	int in_number)
{
	CString cstr_text;
	GetMessageText(in_number, cstr_text, TRUE, FALSE);
	StringToClipboard(cstr_text);
}

void Cq2chwmDatCtrl::CopyMessageAll()
{
	CString cstr_text;
	for (int i = 1; i < GetLastMessageNumber(); i++) {
		CString cstr_tmp;
		GetMessageText(i, cstr_tmp, TRUE, FALSE);
		cstr_text += cstr_tmp;
	}
	StringToClipboard(cstr_text);
}
