#include "StdAfx.h"
#include "YoRegex.h"
#include "YoHttpClient.h"
#include "MainFrm.h"
#include "q2chwmCommon.h"
#include "q2chwmConfig.h"
#include "q2chwmThreadDialog.h"
#include "q2chwmLayoutManager.h"
#include "q2chwmDoLib.h"

IMPLEMENT_DYNAMIC(Cq2chwmThreadDialog, CDialog)

BEGIN_MESSAGE_MAP(Cq2chwmThreadDialog, CDialog)
	ON_WM_SIZE()
	ON_COMMAND(ID_MENU_OK, &Cq2chwmThreadDialog::OnMenuOk)
	ON_COMMAND(ID_MENU_CANCEL, &Cq2chwmThreadDialog::OnMenuCancel)
	ON_BN_CLICKED(IDC_CHECK_SAGE, &Cq2chwmThreadDialog::OnBnClickedCheckSage)
	ON_CBN_SELENDOK(IDC_COMBO_TEMPLATE, &Cq2chwmThreadDialog::OnCbnSelendokComboTemplate)
	ON_COMMAND(ID_MENU_COPY, &Cq2chwmThreadDialog::OnMenuCopy)
	ON_COMMAND(ID_MENU_CUT, &Cq2chwmThreadDialog::OnMenuCut)
	ON_COMMAND(ID_MENU_PASTE, &Cq2chwmThreadDialog::OnMenuPaste)
	ON_COMMAND(ID_MENU_PASTE_CITE, &Cq2chwmThreadDialog::OnMenuPasteCite)
	ON_COMMAND(ID_MENU_DELETE, &Cq2chwmThreadDialog::OnMenuDelete)
	ON_COMMAND(ID_MENU_UNDO, &Cq2chwmThreadDialog::OnMenuUndo)
END_MESSAGE_MAP()

Cq2chwmThreadDialog::Cq2chwmThreadDialog(
	const char *chp_burl,
	CWnd *pParent) : Cq2chwmMessageDialog(NULL, chp_burl, NULL, pParent)
{
}

void Cq2chwmThreadDialog::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	Cq2chwmLayoutManager cLayout(
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_TITLE), 1, GetDlgItem(IDC_EDIT_TITLE), 4),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_NAME), 1, GetDlgItem(IDC_COMBO_NAME), 4),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_MAIL), 1, GetDlgItem(IDC_COMBO_MAIL), 3, GetDlgItem(IDC_CHECK_SAGE), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_COMBO_TEMPLATE), 1),
		new Cq2chwmLayoutLine(5, GetDlgItem(IDC_EDIT_MESSAGE), 1)
	);
	cLayout.Layout(cx, cy);
}

BOOL Cq2chwmThreadDialog::OnInitDialog()
{
	Cq2chwmMessageDialog::OnInitDialog();

	// TODO:  ɏǉĂ
	// WM_SIZE܂ƗȂEEE
	GetDlgItem(IDC_STATIC_TITLE)->ShowWindow(SW_SHOW);
	GetDlgItem(IDC_EDIT_TITLE)->ShowWindow(SW_SHOW);
	RECT r;
	GetClientRect(&r);
	Cq2chwmLayoutManager cLayout(
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_TITLE), 1, GetDlgItem(IDC_EDIT_TITLE), 4),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_NAME), 1, GetDlgItem(IDC_COMBO_NAME), 4),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_MAIL), 1, GetDlgItem(IDC_COMBO_MAIL), 3, GetDlgItem(IDC_CHECK_SAGE), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_COMBO_TEMPLATE), 1),
		new Cq2chwmLayoutLine(5, GetDlgItem(IDC_EDIT_MESSAGE), 1)
	);
	cLayout.Layout(r.right - r.left, r.bottom - r.top);

	return TRUE;
}

BOOL Cq2chwmThreadDialog::SetParameter(
	CYoHttpClient &cHttp,
	BOOL bo_use_sjis,
	const char *chp_burl,
	const char *chp_bbs,
	const char *chp_category,
	const char *chp_aid,
	const char *chp_time,
	const char *chp_from,
	const char *chp_mail,
	const char *chp_message)
{
	// Xbh擾
	CYoString str_title = A(m_cstr_title);
	if (bo_use_sjis == FALSE) {
		str_title.ConvertKCodeEx(CYoString::SJISTOEUC);
	}
	str_title.UrlEncode();

	CYoRegex cRegex;
	if (cRegex.Match(PAT_FILENAME_MACHIBBS, (const char *)m_str_burl) >= 0) {
		// ܂aar
		cHttp.SetParameter("BBS", chp_bbs);
		cHttp.SetParameter("SUBJECT", str_title);
		cHttp.SetParameter("TIME", chp_time);
		cHttp.SetParameter("NAME", chp_from);
		cHttp.SetParameter("MAIL", chp_mail);
		cHttp.SetParameter("MESSAGE", chp_message);
	} else if (cRegex.Match(PAT_FILENAME_JBBS, (const char *)m_str_burl) >= 0) {
		cHttp.SetParameter("DIR", chp_category);
		cHttp.SetParameter("BBS", chp_bbs);
		cHttp.SetParameter("SUBJECT", str_title);
		cHttp.SetParameter("TIME", chp_time);
		cHttp.SetParameter("NAME", chp_from);
		cHttp.SetParameter("MAIL", chp_mail);
		cHttp.SetParameter("MESSAGE", chp_message);
	} else if (cRegex.Match(PAT_FILENAME_LIVESOCCER, (const char *)m_str_burl) >= 0 ||
		cRegex.Match(PAT_FILENAME_LIVESOCCEREXT, (const char *)m_str_burl) >= 0 )
	{
		// TbJ[є
		CYoString str_submit = "";
		str_submit.UrlEncode();
		cHttp.SetParameter("submit", str_submit);
		cHttp.SetParameter("bbs", chp_bbs);
		cHttp.SetParameter("subject", str_title);
		cHttp.SetParameter("time", chp_time);
		cHttp.SetParameter("FROM", chp_from);
		cHttp.SetParameter("mail", chp_mail);
		cHttp.SetParameter("MESSAGE", chp_message);
	} else {
		CYoString str_submit = "";
		str_submit.UrlEncode();
		cHttp.SetParameter("submit", str_submit);
		cHttp.SetParameter("FROM", chp_from);
		cHttp.SetParameter("mail", chp_mail);
		cHttp.SetParameter("MESSAGE", chp_message);
		cHttp.SetParameter("bbs", chp_bbs);
		cHttp.SetParameter("subject", str_title);
		cHttp.SetParameter("time", chp_time);
		cHttp.SetParameter("hana", "mogera");
		CYoString str_sid = Cq2chwmConfig::GetInstance()->GetDoLibSid();
		if (str_sid.Length() > 0) {
			// ZbVID擾ς݂ȂZbVIDt
			str_sid.UrlEncode();
			cHttp.SetParameter("sid", str_sid);
		}
		CYoString str_cookie;
		str_cookie.Format("NAME=%s; MAIL=%s", chp_from, chp_mail);
		cHttp.SetCookie(str_cookie);
	}
	return TRUE;
}


void Cq2chwmThreadDialog::OnMenuOk()
{
	// TODO: ɃR}h nh R[hǉ܂B
	OnOK();
}

void Cq2chwmThreadDialog::OnMenuCancel()
{
	// TODO: ɃR}h nh R[hǉ܂B
	OnCancel();
}

void Cq2chwmThreadDialog::OnCbnSelendokComboTemplate()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	Cq2chwmMessageDialog::OnCbnSelendokComboTemplate();
}

void Cq2chwmThreadDialog::OnBnClickedCheckSage()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	Cq2chwmMessageDialog::OnBnClickedCheckSage();
}

void Cq2chwmThreadDialog::OnMenuCopy()
{
	// TODO: ɃR}h nh R[hǉ܂B
	GetFocus()->SendMessage(WM_COPY);
}

void Cq2chwmThreadDialog::OnMenuCut()
{
	// TODO: ɃR}h nh R[hǉ܂B
	GetFocus()->SendMessage(WM_CUT);
}

void Cq2chwmThreadDialog::OnMenuPaste()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Cq2chwmMessageDialog::OnMenuPaste();
}

void Cq2chwmThreadDialog::OnMenuPasteCite()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Cq2chwmMessageDialog::OnMenuPasteCite();
}

void Cq2chwmThreadDialog::OnMenuDelete()
{
	// TODO: ɃR}h nh R[hǉ܂B
	GetFocus()->SendMessage(EM_REPLACESEL, TRUE, (LPARAM)_T(""));
}

void Cq2chwmThreadDialog::OnMenuUndo()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Cq2chwmMessageDialog::OnMenuUndo();
}
