// q2chwmBookmarkView.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmBookmarkView.h"
#include "q2chwmBbsManager.h"
#include "q2chwmConfig.h"
#include "q2chwmCommon.h"
#include "q2chwmInfoFile.h"

// Cq2chwmBookmarkView

//IMPLEMENT_DYNCREATE(Cq2chwmBookmarkView, Cq2chwmListView)

Cq2chwmBookmarkView::Cq2chwmBookmarkView()
{
	CYoString str_filename = Cq2chwmConfig::GetInstance()->GetRootDirectory();
	str_filename += "\\bookmark2.txt";
	Cq2chwmBookmarkFile::GetInstance()->Create(str_filename);
	m_bo_running = FALSE;
	m_bo_create = FALSE;
}

Cq2chwmBookmarkView::~Cq2chwmBookmarkView()
{
}

BEGIN_MESSAGE_MAP(Cq2chwmBookmarkView, Cq2chwmListView)
	ON_WM_SIZE()
	ON_WM_KEYDOWN()
	ON_WM_DESTROY()
	ON_COMMAND(ID_RELOAD, &Cq2chwmBookmarkView::OnReload)
	ON_COMMAND(ID_DELETE, &Cq2chwmBookmarkView::OnDelete)
	ON_COMMAND(ID_SORT_AID, &Cq2chwmBookmarkView::OnSortArticleId)
	ON_UPDATE_COMMAND_UI(ID_SORT_AID, &Cq2chwmBookmarkView::OnUpdateSortArticleId)
	ON_COMMAND(ID_SORT_ANAME, &Cq2chwmBookmarkView::OnSortArticleName)
	ON_UPDATE_COMMAND_UI(ID_SORT_ANAME, &Cq2chwmBookmarkView::OnUpdateSortArticleName)
	ON_COMMAND(ID_SORT_BNAME, &Cq2chwmBookmarkView::OnSortBoardName)
	ON_UPDATE_COMMAND_UI(ID_SORT_BNAME, &Cq2chwmBookmarkView::OnUpdateSortBoardName)
	ON_COMMAND(ID_SORT_COUNT, &Cq2chwmBookmarkView::OnSortCount)
	ON_UPDATE_COMMAND_UI(ID_SORT_COUNT, &Cq2chwmBookmarkView::OnUpdateSortCount)
	ON_COMMAND(ID_SORT_INDEX, &Cq2chwmBookmarkView::OnSortIndex)
	ON_UPDATE_COMMAND_UI(ID_SORT_INDEX, &Cq2chwmBookmarkView::OnUpdateSortIndex)
	ON_COMMAND(ID_SORT_NEW, &Cq2chwmBookmarkView::OnSortNew)
	ON_UPDATE_COMMAND_UI(ID_SORT_NEW, &Cq2chwmBookmarkView::OnUpdateSortNew)
	ON_COMMAND(ID_SORT_SEARCH, &Cq2chwmBookmarkView::OnSortSearch)
	ON_UPDATE_COMMAND_UI(ID_SORT_SEARCH, &Cq2chwmBookmarkView::OnUpdateSortSearch)
	ON_WM_SHOWWINDOW()
END_MESSAGE_MAP()

// Cq2chwmBookmarkView ff

#ifdef _DEBUG
void Cq2chwmBookmarkView::AssertValid() const
{
	Cq2chwmListView::AssertValid();
}

#ifndef _WIN32_WCE
void Cq2chwmBookmarkView::Dump(CDumpContext& dc) const
{
	Cq2chwmListView::Dump(dc);
}
#endif
#endif //_DEBUG


// Cq2chwmBookmarkView bZ[W nh
void Cq2chwmBookmarkView::clearList()
{
	Cq2chwmBookmarkFile::GetInstance()->RemoveAll();
}

BOOL Cq2chwmBookmarkView::CreateFromFile()
{
	if (m_bo_create == TRUE) return TRUE;
	GetListCtrl().SetItemCountEx(Cq2chwmBookmarkFile::GetInstance()->Count());
	SortItems(Cq2chwmConfig::GetInstance()->GetSortColumnBookmark(),
		Cq2chwmConfig::GetInstance()->GetSortAscBookmark());
	GoTop();
	m_bo_create = TRUE;
	return TRUE;
}

void Cq2chwmBookmarkView::SetFont()
{
	Cq2chwmListView::SetFont(Cq2chwmConfig::GetInstance()->GetFontNameBookmark(),
		Cq2chwmConfig::GetInstance()->GetFontSizeBookmark(), Cq2chwmConfig::GetInstance()->GetFontBoldBookmark());
}

void Cq2chwmBookmarkView::OnInitialUpdate()
{
	Cq2chwmListView::OnInitialUpdate();

	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	GetListCtrl().InsertColumn(0, _T("No"));
	GetListCtrl().InsertColumn(1, _T("X"));
	GetListCtrl().InsertColumn(2, _T("Xbh"));
	GetListCtrl().InsertColumn(3, _T(""));
	GetListCtrl().InsertColumn(4, _T("XbhID"));
	if (Cq2chwmConfig::GetInstance()->GetColumnWidthBookmarkCount() == 0) {
		GetListCtrl().SetColumnWidth(0, 100);
		GetListCtrl().SetColumnWidth(1, 100);
		GetListCtrl().SetColumnWidth(2, 300);
		GetListCtrl().SetColumnWidth(3, 200);
		GetListCtrl().SetColumnWidth(4, 100);
	} else {
		GetListCtrl().SetColumnWidth(0, Cq2chwmConfig::GetInstance()->GetColumnWidthBookmark(0));
		GetListCtrl().SetColumnWidth(1, Cq2chwmConfig::GetInstance()->GetColumnWidthBookmark(1));
		GetListCtrl().SetColumnWidth(2, Cq2chwmConfig::GetInstance()->GetColumnWidthBookmark(2));
		GetListCtrl().SetColumnWidth(3, Cq2chwmConfig::GetInstance()->GetColumnWidthBookmark(3));
		GetListCtrl().SetColumnWidth(4, Cq2chwmConfig::GetInstance()->GetColumnWidthBookmark(4));
	}
	SetFont();
}

void Cq2chwmBookmarkView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	if (Cq2chwmConfig::GetInstance()->IsKeyReload(nChar)) {
		OnReload();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeySort(nChar)) {
		Sort();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeySearch(nChar)) {
		GetParent()->SendMessage(WM_USER_SHOWSEARCHBAR, 0, (LPARAM)TRUE);
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyDelete(nChar)) {
		OnDelete();
		return;
	};

	Cq2chwmListView::OnKeyDown(nChar, nRepCnt, nFlags);
}

BOOL Cq2chwmBookmarkView::AddBookmark(
	const char *chp_aname,
	const char *chp_aid,
	const char *chp_bname,
	const char *chp_bid,
	const char *chp_burl)
{
	// 擪ɃACeǉ
	Cq2chwmBookmarkFile::GetInstance()->AddBookmark(chp_aname, chp_aid, chp_bname, chp_bid, chp_burl);
	Cq2chwmBookmarkFile::GetInstance()->Write();
	GetListCtrl().SetItemCountEx(Cq2chwmBookmarkFile::GetInstance()->Count());

	return TRUE;
}

void Cq2chwmBookmarkView::OnDestroy()
{
	CYoPtrArray cArray;
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(0));
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(1));
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(2));
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(3));
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(4));
	Cq2chwmConfig::GetInstance()->SetColumnWidthBookmark(cArray);
	Cq2chwmConfig::GetInstance()->SetSortColumnBookmark(GetSortColumn());
	Cq2chwmConfig::GetInstance()->SetSortAscBookmark(GetSortAsc());
	clearList();
	Cq2chwmListView::OnDestroy();

	// TODO: ɃbZ[W nh R[hǉ܂B
}

long Cq2chwmBookmarkView::OnCustomMessage(
	WPARAM wParam,
	LPARAM lParam)
{
	Cq2chwmMessage *pMessage = (Cq2chwmMessage*)lParam;
	switch (pMessage->GetType()) {
		case Cq2chwmMessage::TYPE_OPENFILE:
			break;
		case Cq2chwmMessage::TYPE_CLOSEFILE:
		{
			// MYubN}[NACeXV
			Cq2chwmCloseFileMessage *pCloseFileMessage = (Cq2chwmCloseFileMessage*)pMessage;
			if (pCloseFileMessage->GetWriteSize() > 0) {
				UpdateItem(pMessage->GetFileName());
			}
			break;
		}
		case Cq2chwmMessage::TYPE_WRITEFILE:
			break;
		case Cq2chwmMessage::TYPE_RELOADFILE:
			break;
		case Cq2chwmMessage::TYPE_CLOSETAB:
			break;
	};

	return 0;
}

void Cq2chwmBookmarkView::UpdateItem(
	const char *chp_filename)
{
	// ACeinfot@Cǂݍނ悤ɂ̂łȂ
	/*
	for (int i = 0; i < Cq2chwmBookmarkFile::GetInstance()->Count(); i++) {
		Cq2chwmBookmarkItem *pItem = Cq2chwmBookmarkFile::GetInstance()->GetItem(i);
		if (strcmp(chp_filename, pItem->GetFileName()) == 0) {
			Cq2chwmInfoFile cInfo;
			cInfo.Create(pItem->GetBoardUrl(), pItem->GetArticleId());
			int in_number;
			if (cInfo.GetNew() == TRUE) {
				// VȂ+n͑Ŝ̃X - ǈʒu
				in_number = cInfo.GetNumber();
			} else {
				in_number = pItem->GetCount();
			}
			Cq2chwmBookmarkFile::GetInstance()->SetCount(i, pItem->GetCount(), pItem->GetCount() - in_number);
			Cq2chwmBookmarkFile::GetInstance()->Write();
			break;
		}
	}
	*/
}

Cq2chwmBookmarkItem *Cq2chwmBookmarkView::GetNextItem()
{
	POSITION pos = GetListCtrl().GetFirstSelectedItemPosition();
	if ((int)pos == NULL) return NULL;
	for (int i = (int)pos; i < Cq2chwmBookmarkFile::GetInstance()->Count(); i++) {
		Cq2chwmBookmarkItem *pItem = Cq2chwmBookmarkFile::GetInstance()->GetItem(i);
		if (pItem->GetNew() == TRUE) return pItem;
	}
	return NULL;
}

class Cq2chwmThreadInfo
{
public:
	CWnd *m_pMainFrame;
	Cq2chwmBookmarkView *m_pThis;
	Cq2chwmBookmarkItem *m_pItem;
	int m_in_index;
	Cq2chwmThreadInfo(CWnd *pMainFrame, Cq2chwmBookmarkView *pThis, Cq2chwmBookmarkItem *pItem, int in_index)
	{
		m_pMainFrame = pMainFrame;
		m_pThis= pThis;
		m_pItem = pItem;
		m_in_index = in_index;
	}
};

void Cq2chwmBookmarkView::OnReload()
{
	// TODO: ɃR}h nh R[hǉ܂B
	if (m_bo_running == TRUE) return;
	m_bo_running = TRUE;
	GetParent()->SendMessage(WM_USER_SHOWSTATUSBAR, 0, (LPARAM)TRUE);
	PRINTLOG("start: %d", GetListCtrl().GetItemCount());
	m_cArrayThread.RemoveAll();
	for (int i = 0; i < Cq2chwmBookmarkFile::GetInstance()->Count(); i++) {
		// Xbhő吔`FbN
		while (m_cArrayThread.Count() == Cq2chwmConfig::GetInstance()->GetThreadMax()) {
			MessageLoop();
			for (int j = 0; j < m_cArrayThread.Count(); j++) {
				CWinThread *pThread = (CWinThread*)m_cArrayThread.Get(j);
				DWORD dw_code;
				if (::GetExitCodeThread(pThread->m_hThread, &dw_code) == FALSE) {
					PRINTLOG("GetExitCodeThread error(%d)", ::GetLastError());
				} else if (dw_code != STILL_ACTIVE) {
					// XbhI
					m_cArrayThread.Remove(j);
					pThread->Delete();
					j--;
				}
			}
		}

		Cq2chwmBookmarkItem *pItem = Cq2chwmBookmarkFile::GetInstance()->GetItem(i);
		pItem->SetError(FALSE);

		CWinThread *pThread = AfxBeginThread(Cq2chwmBookmarkView::ThreadProc, (LPVOID)new Cq2chwmThreadInfo(AfxGetMainWnd(), this, pItem, i));
		if (pThread == NULL) {
			PRINTLOG("AfxBeginThread error(%d)", ::GetLastError());
			break;
		}
		m_cArrayThread.Add(pThread);
		MessageLoop();
		PRINTLOG("[%d]", i);
		AfxGetMainWnd()->SendMessage(WM_USER_SETPROGRESS, i + 1, Cq2chwmBookmarkFile::GetInstance()->Count());
	}

	while (m_cArrayThread.Count() > 0) {
		MessageLoop();
		for (int i = 0; i < m_cArrayThread.Count(); i++) {
			CWinThread *pThread = (CWinThread*)m_cArrayThread.Get(i);
			DWORD dw_code;
			if (::GetExitCodeThread(pThread->m_hThread, &dw_code) == FALSE) {
				PRINTLOG("GetExitCodeThread error(%d)", ::GetLastError());
			} else if (dw_code != STILL_ACTIVE) {
				// XbhI
				m_cArrayThread.Remove(i);
				pThread->Delete();
				i--;
			}
		}
	}

	PRINTLOG("end");
	GetParent()->SendMessage(WM_USER_SHOWSTATUSBAR, 0, (LPARAM)FALSE);
	m_bo_running = FALSE;

	if (GetSortColumn() == Cq2chwmBookmarkFile::IDX_NEW) {
		SortItems(Cq2chwmBookmarkFile::IDX_NEW, TRUE);
	}
}

//DWORD WINAPI Cq2chwmBookmarkView::ThreadProc(
UINT __cdecl Cq2chwmBookmarkView::ThreadProc(
	LPVOID lpParameter)
{
	PRINTLOG("Cq2chwmBookmarkView::ThreadProc: %08x", ::GetCurrentThreadId());
	Cq2chwmThreadInfo *stp_info = (Cq2chwmThreadInfo*)lpParameter;
	Cq2chwmBookmarkView *pThis = stp_info->m_pThis;
	Cq2chwmBookmarkItem *pItem = stp_info->m_pItem;

	// ACRĕ`
	{
		pItem->SetRunning(TRUE);
		RECT rect;
		pThis->GetClientRect(&rect);
		rect.right = 16;
		pThis->InvalidateRect(&rect, FALSE);
	}

	CYoString str_err;
	if (Cq2chwmBbsManager::GetInstance()->HttpGet(stp_info->m_pMainFrame, pItem->GetBoardUrl(), pItem->GetArticleId(), str_err) != ERR_NONE) {
		pItem->SetError(TRUE);
	}

	// ACeĕ`
	{
		pItem->SetRunning(FALSE);
		RECT rect;
		pThis->GetListCtrl().GetItemRect(stp_info->m_in_index, &rect, LVIR_BOUNDS);
		pThis->InvalidateRect(&rect, FALSE);
	}

	delete stp_info;
	AfxEndThread(0, FALSE);
	return 0;
}

void Cq2chwmBookmarkView::OnListClicked()
{
	POSITION pos = GetListCtrl().GetFirstSelectedItemPosition();
	if (pos == NULL) return;
	Cq2chwmBookmarkItem *pItem = (Cq2chwmBookmarkItem*)Cq2chwmBookmarkFile::GetInstance()->GetItem((int)pos - 1);
	if (pItem != NULL) {
		GetParent()->SendMessage(WM_USER_BOOKMARKCLICKED, 0, (LPARAM)pItem);
	}
}

// ĂԂтɃ\[gω郁\bh
// JwŃ\[gƂSortItemsĂԂ
void Cq2chwmBookmarkView::Sort()
{
	int in_col = GetSortColumn();
	if (in_col == Cq2chwmBookmarkFile::IDX_SEARCH) {
		in_col = Cq2chwmBookmarkFile::IDX_INDEX;
	} else {
		in_col++;
	}
	SortItems(in_col, TRUE);
}

void Cq2chwmBookmarkView::SortItems(
	int in_col,
	BOOL bo_asc)
{
	// \[gsƂ^Cgo[ς
	/*
	CString cstr_title = _T("ubN}[N");
	switch (in_col) {
	case Cq2chwmBookmarkFile::IDX_INDEX:
		cstr_title += _T("[No]");
		break;
	case Cq2chwmBookmarkFile::IDX_COUNT:
		cstr_title += _T("[X]");
		break;
	case Cq2chwmBookmarkFile::IDX_ANAME:
		cstr_title += _T("[Xbh]");
		break;
	case Cq2chwmBookmarkFile::IDX_BNAME:
		cstr_title += _T("[]");
		break;
	case Cq2chwmBookmarkFile::IDX_AID:
		cstr_title += _T("[XbhID]");
		break;
	case Cq2chwmBookmarkFile::IDX_NEW:
		cstr_title += _T("[V]");
		break;
	case Cq2chwmBookmarkFile::IDX_SEARCH:
		cstr_title += _T("[]");
		break;
	};
	AfxGetMainWnd()->SetWindowText(cstr_title);
	*/

	Cq2chwmBookmarkFile::GetInstance()->Sort(in_col, bo_asc);
	RedrawWindow();
	SetSortColumn(in_col);
	SetSortAsc(bo_asc);
}

void Cq2chwmBookmarkView::Search(
	const char *chp_word)
{
	BOOL bo_ret = FALSE;
	CYoRegex cRegex(chp_word, CYoRegex::SJIS, TRUE);
	for (int i = 0; i < Cq2chwmBookmarkFile::GetInstance()->Count(); i++) {
		Cq2chwmBookmarkItem *pItem = (Cq2chwmBookmarkItem*)Cq2chwmBookmarkFile::GetInstance()->GetItem(i);
		if (cRegex.Match(pItem->GetArticleName()) >= 0) {
			pItem->SetSearch(TRUE);
			bo_ret = TRUE;
		} else {
			pItem->SetSearch(FALSE);
		}
	}

	// }b`ꍇ̂݁A[]Ń\[g&ֈړ
	if (bo_ret == TRUE) {
		SortItems(Cq2chwmBookmarkFile::IDX_SEARCH, TRUE);
		GoTop();
	}
}

BOOL Cq2chwmBookmarkView::GetItemText(
	LPTSTR wchp_text,
	int in_size,
	int in_row,
	int in_col)
{
	Cq2chwmBookmarkItem *pItem = Cq2chwmBookmarkFile::GetInstance()->GetItem(in_row);
	if (pItem == NULL) return FALSE;
	CString cstr_tmp;
	switch (in_col) {
	case Cq2chwmBookmarkFile::IDX_INDEX:
		cstr_tmp.Format(_T("%d"), pItem->GetIndex());
		break;
	case Cq2chwmBookmarkFile::IDX_COUNT:
		if (pItem->GetNew() == FALSE || pItem->GetCountNew() == 0) {
			cstr_tmp.Format(_T("%d"), pItem->GetCount());
		} else {
			cstr_tmp.Format(_T("%d\n(%d)"), pItem->GetCount(), pItem->GetCountNew());
		}
		break;
	case Cq2chwmBookmarkFile::IDX_ANAME:
		cstr_tmp = pItem->GetArticleName();
		break;
	case Cq2chwmBookmarkFile::IDX_BNAME:
		cstr_tmp = pItem->GetBoardName();
		break;
	case Cq2chwmBookmarkFile::IDX_AID:
		cstr_tmp = pItem->GetArticleId();
		break;
	};
	_tcscpy_s(wchp_text, in_size, cstr_tmp);
	return TRUE;
}

Cq2chwmListItem *Cq2chwmBookmarkView::GetSelectedItem()
{
	POSITION pos = GetListCtrl().GetFirstSelectedItemPosition();
	if (pos == NULL) return NULL;
	return Cq2chwmBookmarkFile::GetInstance()->GetItem((int)pos - 1);
}

Cq2chwmListItem *Cq2chwmBookmarkView::GetItem(
	int iRow)
{
	return Cq2chwmBookmarkFile::GetInstance()->GetItem(iRow);
}

void Cq2chwmBookmarkView::OnDelete()
{
	// TODO: ɃR}h nh R[hǉ܂B
	POSITION pos = GetListCtrl().GetFirstSelectedItemPosition();
	if (pos == NULL) return;
	if (::MessageBox(m_hWnd, _T("폜܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
		Cq2chwmBookmarkFile::GetInstance()->Remove((int)pos - 1);
		Cq2chwmBookmarkFile::GetInstance()->Write();
		GetListCtrl().SetItemCountEx(Cq2chwmBookmarkFile::GetInstance()->Count());
		InvalidateRect(NULL);
	}
}

void Cq2chwmBookmarkView::OnSortArticleId()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmBookmarkFile::IDX_AID, FALSE);
}

void Cq2chwmBookmarkView::OnUpdateSortArticleId(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmBookmarkFile::IDX_AID);
}

void Cq2chwmBookmarkView::OnSortArticleName()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmBookmarkFile::IDX_ANAME, TRUE);
}

void Cq2chwmBookmarkView::OnUpdateSortArticleName(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmBookmarkFile::IDX_ANAME);
}

void Cq2chwmBookmarkView::OnSortBoardName()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmBookmarkFile::IDX_BNAME, TRUE);
}

void Cq2chwmBookmarkView::OnUpdateSortBoardName(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmBookmarkFile::IDX_BNAME);
}

void Cq2chwmBookmarkView::OnSortCount()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmBookmarkFile::IDX_COUNT, FALSE);
}

void Cq2chwmBookmarkView::OnUpdateSortCount(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmBookmarkFile::IDX_COUNT);
}

void Cq2chwmBookmarkView::OnSortIndex()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmBookmarkFile::IDX_INDEX, TRUE);
}

void Cq2chwmBookmarkView::OnUpdateSortIndex(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmBookmarkFile::IDX_INDEX);
}

void Cq2chwmBookmarkView::OnSortNew()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmBookmarkFile::IDX_NEW, TRUE);
}

void Cq2chwmBookmarkView::OnUpdateSortNew(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmBookmarkFile::IDX_NEW);
}

void Cq2chwmBookmarkView::OnSortSearch()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmBookmarkFile::IDX_SEARCH, TRUE);
}

void Cq2chwmBookmarkView::OnUpdateSortSearch(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmBookmarkFile::IDX_SEARCH);
}

void Cq2chwmBookmarkView::OnShowWindow(BOOL bShow, UINT nStatus)
{
	Cq2chwmListView::OnShowWindow(bShow, nStatus);

	// TODO: ɃbZ[W nh R[hǉ܂B
	if (bShow == TRUE && GetSortColumn() == Cq2chwmBookmarkFile::IDX_NEW) {
		SortItems(Cq2chwmBookmarkFile::IDX_NEW, TRUE);
	}
}
