#include "stdafx.h"
#include "YoFile.h"
#include "q2chwmBookmarkFile.h"

#define PAT_BOOKMARK		"\\(\"([^\"]+)\" \\(board \\(name . \"((\\\\\"|[^\"])*)\"\\) \\(uri . \"([^\"]+)\"\\) \\(id . \"([^\"]+)\"\\)\\) \\(article \\(subject . \"((\\\\\"|[^\"])*)\"\\) \\(artid . \"([^\"]+)\"\\) \\(count . \"([^\"]+)\"\\)\\)\\)"

Cq2chwmBookmarkFile *Cq2chwmBookmarkFile::m_pInstance = NULL;
Cq2chwmBookmarkFile *Cq2chwmBookmarkFile::GetInstance()
{
	if (m_pInstance == NULL) {
		m_pInstance = new Cq2chwmBookmarkFile();
		atexit(Cq2chwmBookmarkFile::Delete);
	}

	return m_pInstance;
}
void Cq2chwmBookmarkFile::Delete()
{
	delete m_pInstance;
}

Cq2chwmBookmarkFile::Cq2chwmBookmarkFile()
{
	static CYoRegex cRegex(PAT_BOOKMARK, CYoRegex::SJIS);
	m_pRegex = &cRegex;
	m_in_sort_column = IDX_INDEX;
	m_bo_sort_asc = TRUE;
}

Cq2chwmBookmarkFile::~Cq2chwmBookmarkFile()
{
	RemoveAll();
}

void Cq2chwmBookmarkFile::RemoveAll()
{
	for (int i = 0; i < Count(); i++) {
		Cq2chwmBookmarkItem *pItem = (Cq2chwmBookmarkItem*)Get(i);
		delete pItem;
	}
	CYoPtrArray::RemoveAll();
}

void Cq2chwmBookmarkFile::Remove(
	int in_pos)
{
	Cq2chwmBookmarkItem *pItem = (Cq2chwmBookmarkItem*)Get(in_pos);
	if (pItem != NULL) {
		int in_index = pItem->GetIndex();
		delete pItem;
		CYoPtrArray::Remove(in_pos);

		// CfbNX̍Đݒ
		for (int i = 0; i < Count(); i++) {
			Cq2chwmBookmarkItem *pItem = GetItem(i);
			if (in_index < pItem->GetIndex()) {
				pItem->SetIndex(pItem->GetIndex() - 1);
			}
		}
	}
}

BOOL Cq2chwmBookmarkFile::AddBookmark(
	const char *chp_aname,
	const char *chp_aid,
	const char *chp_bname,
	const char *chp_bid,
	const char *chp_burl)
{
	CYoString str_aurl = chp_burl;
	str_aurl += chp_aid;
	if (Search(str_aurl) == -1) {
		Cq2chwmBookmarkItem *pItem = new Cq2chwmBookmarkItem(1, chp_aname, chp_aid, chp_bname, chp_bid, chp_burl);
		Insert(0, pItem);

		// 1Ԗڈȍ~̃CfbNXCNg
		for (int i = 1; i < Count(); i++) {
			Cq2chwmBookmarkItem *pItem = GetItem(i);
			pItem->SetIndex(pItem->GetIndex() + 1);
		}
		return TRUE;
	}
	return FALSE;
}

BOOL Cq2chwmBookmarkFile::Create(
	const char *chp_filename)
{
	m_str_filename = chp_filename;
	CYoTextFile cFile(m_str_filename, CYoFile::READ);
	if (cFile.Open() == FALSE) {
		return FALSE;
	}

	CYoString str_line;
	int in_index = 1;
	while (cFile.Eof() == FALSE) {
		cFile.ReadLine(str_line);
		const char *chp_line = str_line;

		int in_start = 0;
		while (m_pRegex->Match( chp_line, in_start ) >= 0) {
			CYoString str_aurl = m_pRegex->Get(1);
			CYoString str_bname = m_pRegex->Get(2);			// 3\" or ^"
			CYoString str_burl = m_pRegex->Get(4);
			CYoString str_bid = m_pRegex->Get(5);
			CYoString str_aname = m_pRegex->Get(6);			// 7\" or ^"
			CYoString str_aid = m_pRegex->Get(8);
			CYoString str_count = m_pRegex->Get(9);

			str_bname.Replace( "\\\"", "\"" );
			str_aname.Replace( "\\\"", "\"" );

			// e[uɊi[
			Cq2chwmBookmarkItem *pItem = new Cq2chwmBookmarkItem(in_index++, str_aname, str_aid, str_bname, str_bid, str_burl);
			Add(pItem);

			in_start = m_pRegex->GetEnd();
		}
	}

	return TRUE;
}

#define HEADER	"((\"\" \"\" "
#define FOOTER	"))"
#define FORMAT	"(\"%s\" (board (name . \"%s\") (uri . \"%s\") (id . \"%s\")) (article (subject . \"%s\") (artid . \"%s\") (count . \"%d\")))"
BOOL Cq2chwmBookmarkFile::Write()
{
	// NoŃ\[gĂ珑܂ȂƏԂςႤ
	int in_sort_column = m_in_sort_column;
	BOOL bo_sort_asc = m_bo_sort_asc;
	if (in_sort_column != IDX_INDEX && bo_sort_asc != TRUE) {
		Sort(IDX_INDEX, TRUE);
	}

	CString cstr_filename;
	cstr_filename = m_str_filename;
	CFile cFile;
	if (cFile.Open(cstr_filename, CFile::modeCreate|CFile::modeWrite) == FALSE) {
		return FALSE;
	}
	cFile.Write(HEADER, strlen(HEADER));

	for( int i = 0; i < Count(); i++ ){
		Cq2chwmBookmarkItem *pItem = GetItem(i);
		CYoString str_bname = pItem->GetBoardName();
		const char *chp_burl = pItem->GetBoardUrl();
		const char *chp_bid = pItem->GetBoardId();
		CYoString str_aname = pItem->GetArticleName();
		const char *chp_aid = pItem->GetArticleId();
		int in_count = pItem->GetCount();
		CYoString str_aurl = chp_burl;
		str_aurl += chp_aid;

		str_bname.Replace( "\"", "\\\"" );
		str_aname.Replace( "\"", "\\\"" );

		CYoString str_fmt;
		if( i != 0 ){
			str_fmt += " ";
		}
		str_fmt.FormatAdd(FORMAT, (const char*)str_aurl, (const char*)str_bname, chp_burl, chp_bid, (const char*)str_aname, chp_aid, in_count);
		cFile.Write((const char*)str_fmt, str_fmt.Length());
	}

	cFile.Write(FOOTER, strlen(FOOTER));
	cFile.Close();

	// \[gɖ߂
	if (in_sort_column != IDX_INDEX && bo_sort_asc != TRUE) {
		Sort(in_sort_column, bo_sort_asc);
	}
	return TRUE;
}

int Cq2chwmBookmarkFile::Search(
	const char *chp_aurl)
{
	for( int i = 0; i < Count(); i++ ){
		Cq2chwmBookmarkItem *pItem = GetItem(i);
		if (strcmp(chp_aurl, pItem->GetArticleUrl()) == 0) return i;
	}
	return -1;
}

void Cq2chwmBookmarkFile::SetArticleName(
	int in_index,
	const char *chp_aname)
{
	Cq2chwmBookmarkItem *pItem = GetItem(in_index);
	if (pItem == NULL) return;
	pItem->SetArticleName(chp_aname);
}

void Cq2chwmBookmarkFile::SetCount(
	int in_index,
	int in_count,
	int in_count_new)
{
	Cq2chwmBookmarkItem *pItem = GetItem(in_index);
	if (pItem == NULL) return;
	pItem->SetCount(in_count, in_count_new < 0 ? 0 : in_count_new);
}

void Cq2chwmBookmarkFile::Sort(
	int in_col,
	BOOL bo_asc)
{
	if (bo_asc == TRUE) {
		CYoPtrArray::Sort(Cq2chwmBookmarkFile::compAsc, (const void*)in_col);
	} else {
		CYoPtrArray::Sort(Cq2chwmBookmarkFile::compDesc, (const void*)in_col);
	}
	m_in_sort_column = in_col;
	m_bo_sort_asc = bo_asc;
}

int Cq2chwmBookmarkFile::compAsc(
	const void *vop_user,
	const void *a,
	const void *b)
{
	int in_col = (int)vop_user;
	Cq2chwmBookmarkItem *aa;
	Cq2chwmBookmarkItem *bb;
	memcpy(&aa, (const void*)a, sizeof(Cq2chwmBookmarkItem*));
	memcpy(&bb, (const void*)b, sizeof(Cq2chwmBookmarkItem*));
	switch (in_col) {
	case IDX_INDEX:
		return aa->GetIndex() > bb->GetIndex() ? 1 : -1;
	case IDX_COUNT:
		return aa->GetCount() > bb->GetCount() ? 1 : -1;
	case IDX_ANAME:
		return strcmp(aa->GetArticleName(), bb->GetArticleName());
	case IDX_BNAME:
		return strcmp(aa->GetBoardName(), bb->GetBoardName());
	case IDX_AID:
		return atoi(aa->GetArticleId()) > atoi(bb->GetArticleId()) ? 1 : -1;
	case IDX_NEW:
		// VtO, VANoŃ\[g
		return MAKESORTINT(bb->GetNew(), bb->GetCountNew(), -bb->GetIndex()) >
			MAKESORTINT(aa->GetNew(), aa->GetCountNew(), -aa->GetIndex()) ? 1 : -1;
	case IDX_SEARCH:
		// tO, NoŃ\[g
		return MAKESORTINT(bb->GetSearch(), -bb->GetIndex(), 0) >
			MAKESORTINT(aa->GetSearch(), -aa->GetIndex(), 0) ? 1 : -1;
	}
	return 0;
}

int Cq2chwmBookmarkFile::compDesc(
	const void *vop_user,
	const void *a,
	const void *b)
{
	int in_col = (int)vop_user;
	Cq2chwmBookmarkItem *aa;
	Cq2chwmBookmarkItem *bb;
	memcpy(&aa, (const void*)a, sizeof(Cq2chwmBookmarkItem*));
	memcpy(&bb, (const void*)b, sizeof(Cq2chwmBookmarkItem*));
	switch (in_col) {
	case IDX_INDEX:
		return aa->GetIndex() < bb->GetIndex() ? 1 : -1;
	case IDX_COUNT:
		return aa->GetCount() < bb->GetCount() ? 1 : -1;
	case IDX_ANAME:
		return strcmp(bb->GetArticleName(), aa->GetArticleName());
	case IDX_BNAME:
		return strcmp(bb->GetBoardName(), aa->GetBoardName());
	case IDX_AID:
		return atoi(aa->GetArticleId()) < atoi(bb->GetArticleId()) ? 1 : -1;
	}
	return 0;
}

BOOL Cq2chwmBookmarkFile::Replace(
	const char *chp_burl_old,
	const char *chp_burl_new)
{
	for( int i = 0; i < Count(); i++ ){
		Cq2chwmBookmarkItem *pItem = GetItem(i);
		const char *chp_burl = pItem->GetBoardUrl();
		if (strcmp(chp_burl, chp_burl_old) == 0) {
			pItem->SetBoardUrl(chp_burl_new);
		}
	}
	return TRUE;
}
