#pragma once

#include "YoTable.h"

class Cq2chwmBoardFile : public CYoTable
{
protected:
	CYoString m_str_filename;

public:
	Cq2chwmBoardFile(const char *chp_filename = NULL);
	virtual ~Cq2chwmBoardFile();

	int CreateFromFile();
	int CreateFromHttp(const char *chp_url);
	inline const char *GetBoardName(int in_row){ return Get(in_row, 0); }
	inline const char *GetBoardUrl(int in_row){ return Get(in_row, 1); }
	inline const char *GetBoardId(int in_row){ return Get(in_row, 2); }
	inline const char *GetFileName(){ return m_str_filename; }
	BOOL Exist();
	int Write();
	int SearchFromUrl(const char *chp_url);
	int SearchFromId(const char *chp_id);
	void AddBoard(const char *chp_name, const char *chp_url, const char *chp_id);
	void InsertBoard(const char *chp_name, const char *chp_url, const char *chp_id);
};

class Cq2chwmBoardFileEtc : public Cq2chwmBoardFile
{
public:
	Cq2chwmBoardFileEtc();
};

