// q2chwmPageBoard.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmPageBoard.h"
#include "q2chwmLayoutManager.h"

// Cq2chwmPageBoard _CAO

IMPLEMENT_DYNAMIC(Cq2chwmPageBoard, CDialog)

Cq2chwmPageBoard::Cq2chwmPageBoard(CWnd* pParent /*=NULL*/)
	: Cq2chwmConfigPage(Cq2chwmPageBoard::IDD, pParent)
	, m_cstr_name(_T(""))
	, m_cstr_url(_T(""))
	, m_cstr_id(_T(""))
{

}

Cq2chwmPageBoard::~Cq2chwmPageBoard()
{
}

void Cq2chwmPageBoard::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDIT_NAME, m_cstr_name);
	DDX_CBString(pDX, IDC_COMBO_URL, m_cstr_url);
	DDX_Text(pDX, IDC_EDIT_ID, m_cstr_id);
}


BEGIN_MESSAGE_MAP(Cq2chwmPageBoard, CDialog)
	ON_WM_SIZE()
	ON_BN_CLICKED(IDC_BUTTON_ADD, &Cq2chwmPageBoard::OnBnClickedButtonAdd)
	ON_BN_CLICKED(IDC_BUTTON_MOD, &Cq2chwmPageBoard::OnBnClickedButtonMod)
	ON_BN_CLICKED(IDC_BUTTON_DEL, &Cq2chwmPageBoard::OnBnClickedButtonDel)
	ON_BN_CLICKED(IDC_BUTTON_UP, &Cq2chwmPageBoard::OnBnClickedButtonUp)
	ON_BN_CLICKED(IDC_BUTTON_DOWN, &Cq2chwmPageBoard::OnBnClickedButtonDown)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LIST, &Cq2chwmPageBoard::OnLvnItemchangedList)
END_MESSAGE_MAP()


// Cq2chwmPageBoard bZ[W nh
BOOL Cq2chwmPageBoard::OnInitDialog()
{
	Cq2chwmConfigPage::OnInitDialog();

	// TODO:  ɏǉĂ
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	pList->SetExtendedStyle(LVS_EX_FULLROWSELECT);
	pList->InsertColumn(0, _T("O"));
	pList->InsertColumn(1, _T("URL"));
	pList->InsertColumn(2, _T("L["));

	m_cFile.CreateFromFile();
	for (int i = 0; i < m_cFile.Rows(); i++) {
		CString cstr_tmp;
		cstr_tmp = m_cFile.GetName(i);
		pList->InsertItem(i, cstr_tmp);
		cstr_tmp = m_cFile.GetUrl(i);
		pList->SetItemText(i, 1, cstr_tmp);
		cstr_tmp = m_cFile.GetId(i);
		pList->SetItemText(i, 2, cstr_tmp);
	}

	CComboBox *pCombo = (CComboBox*)GetDlgItem(IDC_COMBO_URL);
	pCombo->InsertString(0, _T("http://jbbs.livedoor.jp/"));
	pCombo->InsertString(1, _T("http://livesoccer.net/cgi-bin/12ch/Live/"));
	pCombo->InsertString(2, _T("http://livesoccer.net/cgi-bin/12ch/Live2/"));
	
	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void Cq2chwmPageBoard::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	Cq2chwmLayoutManager cLayout(
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_NAME), 1, GetDlgItem(IDC_EDIT_NAME), 3),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_URL), 1, GetDlgItem(IDC_COMBO_URL), 3),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_ID), 1, GetDlgItem(IDC_EDIT_ID), 3),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_BUTTON_ADD), 1, GetDlgItem(IDC_BUTTON_MOD), 1, GetDlgItem(IDC_BUTTON_DEL), 1,
			GetDlgItem(IDC_BUTTON_UP), 1, GetDlgItem(IDC_BUTTON_DOWN), 1),
		new Cq2chwmLayoutLine(4, GetDlgItem(IDC_LIST), 1)
	);
	cLayout.Layout(cx, cy);

	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	if (pList != NULL) {
		pList->SetColumnWidth(0, cx / 3);
		pList->SetColumnWidth(1, cx / 3);
		pList->SetColumnWidth(2, cx / 3);
	}
}

void Cq2chwmPageBoard::Write()
{
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	Cq2chwmBoardFileEtc cFile;
	for (int i = 0; i < pList->GetItemCount(); i++) {
		CString cstr_name = pList->GetItemText(i, 0);
		CString cstr_url = pList->GetItemText(i, 1);
		CString cstr_id = pList->GetItemText(i, 2);
		cFile.AddBoard(A(cstr_name), A(cstr_url), A(cstr_id));
	}
	cFile.Write();
}

BOOL Cq2chwmPageBoard::checkDuplicate()
{
	UpdateData(TRUE);
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	for (int i = 0; i < pList->GetItemCount(); i++) {
		CString cstr_name = pList->GetItemText(i, 0);
		CString cstr_url = pList->GetItemText(i, 1);
		CString cstr_id = pList->GetItemText(i, 2);
		if (cstr_name == m_cstr_name &&
			cstr_url == m_cstr_url &&
			cstr_id == m_cstr_id)
		{
			return FALSE;
		}
	}
	return TRUE;
}

void Cq2chwmPageBoard::OnBnClickedButtonAdd()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	if (checkDuplicate() == FALSE) {
		::MessageBox(m_hWnd, _T("o^Ă܂"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK);
		return;
	}
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	pList->InsertItem(0, m_cstr_name);
	pList->SetItemText(0, 1, m_cstr_url);
	pList->SetItemText(0, 2, m_cstr_id);
}

void Cq2chwmPageBoard::OnBnClickedButtonMod()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	if (checkDuplicate() == FALSE) {
		::MessageBox(m_hWnd, _T("o^Ă܂"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK);
		return;
	}
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	POSITION pos = pList->GetFirstSelectedItemPosition();
	if (pos != NULL) {
		int in_index = (int)pos - 1;
		pList->SetItemText(in_index, 0, m_cstr_name);
		pList->SetItemText(in_index, 1, m_cstr_url);
		pList->SetItemText(in_index, 2, m_cstr_id);
	}
}

void Cq2chwmPageBoard::OnBnClickedButtonDel()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	POSITION pos = pList->GetFirstSelectedItemPosition();
	if (pos != NULL) {
		int in_index = (int)pos - 1;
		pList->DeleteItem(in_index);
	}
}

void Cq2chwmPageBoard::OnBnClickedButtonUp()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	POSITION pos = pList->GetFirstSelectedItemPosition();
	if (pos != NULL) {
		int in_index = (int)pos - 1;
		if (in_index == 0) return;
		CString cstr_name = pList->GetItemText(in_index, 0);
		CString cstr_url = pList->GetItemText(in_index, 1);
		CString cstr_id = pList->GetItemText(in_index, 2);
		pList->SetItemText(in_index, 0, pList->GetItemText(in_index - 1, 0));
		pList->SetItemText(in_index, 1, pList->GetItemText(in_index - 1, 1));
		pList->SetItemText(in_index, 2, pList->GetItemText(in_index - 1, 2));
		pList->SetItemText(in_index - 1, 0, cstr_name);
		pList->SetItemText(in_index - 1, 1, cstr_url);
		pList->SetItemText(in_index - 1, 2, cstr_id);
		pList->SetItemState(in_index - 1, LVIS_SELECTED, LVIS_SELECTED);
	}
}

void Cq2chwmPageBoard::OnBnClickedButtonDown()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	POSITION pos = pList->GetFirstSelectedItemPosition();
	if (pos != NULL) {
		int in_index = (int)pos - 1;
		if (in_index == pList->GetItemCount() - 1) return;
		CString cstr_name = pList->GetItemText(in_index, 0);
		CString cstr_url = pList->GetItemText(in_index, 1);
		CString cstr_id = pList->GetItemText(in_index, 2);
		pList->SetItemText(in_index, 0, pList->GetItemText(in_index + 1, 0));
		pList->SetItemText(in_index, 1, pList->GetItemText(in_index + 1, 1));
		pList->SetItemText(in_index, 2, pList->GetItemText(in_index + 1, 2));
		pList->SetItemText(in_index + 1, 0, cstr_name);
		pList->SetItemText(in_index + 1, 1, cstr_url);
		pList->SetItemText(in_index + 1, 2, cstr_id);
		pList->SetItemState(in_index + 1, LVIS_SELECTED, LVIS_SELECTED);
	}
}

void Cq2chwmPageBoard::OnLvnItemchangedList(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMHEADER phdr = reinterpret_cast<LPNMHEADER>(pNMHDR);
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	POSITION pos = pList->GetFirstSelectedItemPosition();
	if (pos != NULL) {
		int in_index = (int)pos - 1;
		CString cstr_name = pList->GetItemText(in_index, 0);
		CString cstr_url = pList->GetItemText(in_index, 1);
		CString cstr_id = pList->GetItemText(in_index, 2);
		CEdit *pEditName = (CEdit*)GetDlgItem(IDC_EDIT_NAME);
		CComboBox *pComboUrl = (CComboBox*)GetDlgItem(IDC_COMBO_URL);
		CEdit *pEditId = (CEdit*)GetDlgItem(IDC_EDIT_ID);
		pEditName->SetWindowTextW(cstr_name);
		pComboUrl->SetWindowTextW(cstr_url);
		pEditId->SetWindowTextW(cstr_id);
	}
	*pResult = 0;
}
