#include "stdafx.h"
#include "q2chwmCommon.h"
#include "q2chwmConfig.h"
#include "q2chwmMessage.h"

/*
 * ANSI->WIDE
 */
CString W(
	const char *chp_string)
{
	CString str_ret;
	int in_len = MultiByteToWideChar(CP_ACP, 0, chp_string, -1, NULL,0);
	if (in_len == 0) return CString();
	wchar_t *wchp_string = (wchar_t*)malloc(sizeof(wchar_t) * in_len);
	MultiByteToWideChar(CP_ACP, 0, chp_string, -1, wchp_string, in_len);
	str_ret = wchp_string;
	free(wchp_string);
	return str_ret;
}

/*
 * WIDE -> ANSI
 */
CYoString A(
	const wchar_t *wchp_string)
{
	CYoString str_ret;
	int in_len = WideCharToMultiByte(CP_ACP, 0, wchp_string, -1, NULL, 0, NULL, NULL);
	if (in_len == 0) return CYoString();
	char *chp_string = (char*)malloc(sizeof(char) * in_len);
	WideCharToMultiByte(CP_ACP, 0, wchp_string, -1, chp_string, in_len, NULL, NULL);
	str_ret = chp_string;
	free(chp_string);
	return str_ret;
}

CYoString UrlToPath(
	const char *chp_url)
{
	if (chp_url == NULL) return CYoString();
	const char *chp_tmp = strstr(chp_url, "://");
	if (chp_tmp == NULL) return CYoString();
	chp_tmp += 3;
	CYoString str_ret = Cq2chwmConfig::GetInstance()->GetRootDirectory();
	if (*((const char*)str_ret + str_ret.Length() - 1) != '\\') str_ret += "\\";
	str_ret += chp_tmp;
	str_ret.Replace("/", "\\");
	if (*((const char*)str_ret + str_ret.Length() - 1) == '\\') str_ret.Remove(str_ret.Length() - 1);
	return str_ret;
}

BOOL ExistFile(
	const char *chp_filename,
	ULONGLONG *ullp_length,
	FILETIME *stp_modify)
{
	CString cstr_filename;
	cstr_filename = chp_filename;
	if (ullp_length == NULL && stp_modify == NULL) {
		// t@CTCYƍXVKvȂ΁A݃`FbNɃRXg̒ႻGetFileAttributesg
		return ::GetFileAttributes(cstr_filename) == -1 ? FALSE : TRUE;
	}

	WIN32_FIND_DATA st_find;
	HANDLE hFind = ::FindFirstFile(cstr_filename, &st_find);
	if (hFind != INVALID_HANDLE_VALUE) {
		if (ullp_length != NULL) *ullp_length = (st_find.nFileSizeHigh * MAXDWORD) + st_find.nFileSizeLow;
		if (stp_modify != NULL) *stp_modify = st_find.ftLastWriteTime;
		::FindClose(hFind);
		return TRUE;
	}
	return FALSE;
}

BOOL MakeDirectory(
	const char *chp_dir)
{
	CString cstr_dir;
	cstr_dir = chp_dir;
	WIN32_FIND_DATA st_find;
	HANDLE hFind = ::FindFirstFile(cstr_dir, &st_find);
	if (hFind == INVALID_HANDLE_VALUE) {
		const char *chp_tmp = strrchr(chp_dir, '\\');
		if( chp_tmp != NULL ){
			CYoString str_dir;
			str_dir.StrnCpy( chp_dir, chp_tmp-chp_dir);
			MakeDirectory(str_dir);
		}
		if (::CreateDirectory(cstr_dir, NULL) == FALSE) {
			return FALSE;
		}
	} else {
		::FindClose(hFind);
	}

	return TRUE;
}

CYoString GetBaseName(
	const char *chp_filename)
{
	if (chp_filename == NULL) return CYoString();
	const char *chp_tmp = strrchr(chp_filename, '\\');
	if (chp_tmp == NULL) return CYoString();
	CYoString str_ret;
	str_ret.StrnCpy(chp_filename, chp_tmp - chp_filename);
	return str_ret;
}

BOOL CleanFileTime(
	const char *chp_filename)
{
	CString cstr_filename;
	cstr_filename = chp_filename;
	// 1970/1/1 00:00:00FILETIME
	FILETIME st_time = {3577643008, 27111902};
	HANDLE hFile = ::CreateFile(cstr_filename, GENERIC_WRITE, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hFile == INVALID_HANDLE_VALUE) return FALSE;
	::SetFileTime(hFile, NULL, NULL, &st_time);
	::CloseHandle(hFile);
	return TRUE;
}

//! eEBhEPostMessage
/*!
 * XbhGUI𑀍삷Ƃ͕KCxgg
 * \param pEvent 
 * \return void 
 */
void PostCustomMessage(
	HWND hWnd,
	Cq2chwmMessage *pMessage)
{
	::PostMessage(hWnd, pMessage->GetMessage(), 0, (LPARAM)pMessage);
	//::SendMessage(hWnd, pMessage->GetMessage(), 0, (LPARAM)pMessage);
}

CYoString ConvertGmtTime(
	FILETIME *stp_modify)
{
	static const char *chpa_week[] = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
	static const char *chpa_month[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
	CYoString str_ret;
	SYSTEMTIME st_system;
	::FileTimeToSystemTime(stp_modify , &st_system);
	// Thu, 19 Jan 2006 04:27:55 GMT 
	str_ret.Format("%s, %d %s %d %02d:%02d:%02d GMT",
		chpa_week[st_system.wDayOfWeek],		// j
		st_system.wDay,							// 
		chpa_month[st_system.wMonth - 1],		// 
		st_system.wYear,						// N
		st_system.wHour,						// 
		st_system.wMinute,						// 
		st_system.wSecond);						// b

	return str_ret;
}

int GetStringLength(
	const char *chp_string,
	int in_len)
{
	return MultiByteToWideChar(CP_ACP, 0, chp_string, in_len, NULL,0);
}

int GetByteLength(
	const wchar_t *wchp_string,
	int in_len)
{
	return WideCharToMultiByte(CP_ACP, 0, wchp_string, in_len, NULL, 0, NULL, NULL);
}

void ErrorMessageBox(
	const char *chp_err)
{
	CString cstr_msg;
	cstr_msg = chp_err;
	AfxMessageBox(cstr_msg, MB_OK|MB_ICONSTOP);
}

void ErrorMessageBox(
	int in_err)
{
	CYoString str_msg;
	switch(in_err){
	case ERR_NONE:
	case ERR_CANCELED:
		// G[Ƃ͂Ȃ
		break;
	case ERR_HTTP_CONNECT:
		str_msg = "ڑG[";
		break;
	case ERR_HTTP_GET:
		str_msg = "HTTPG[(GET)";
		break;
	case ERR_HTTP_RECV:
		str_msg = "HTTPG[(RECV)";
		break;
	case ERR_HTTP_NOTMODIFIED:
		// G[Ƃ͂Ȃ
		break;
	case ERR_HTTP_LOCATION:
		str_msg = "Xbh܂ł";
		break;
	case ERR_HTTP_ABONE:
		// ꂪԂ邱Ƃ͂Ȃ
		_ASSERT(1);
		break;

	case ERR_FILE_OPEN:
		str_msg = "t@CI[vG[";
		break;
	case ERR_FILE_FORMAT:
		str_msg = "t@CtH[}bgG[";
		break;
	case ERR_FILE_CONVERT:
		str_msg = "ERR_FILE_WRITE_CONVERT";
		break;
	case ERR_FILE_WRITE:
		str_msg = "t@C݃G[";
		break;

	case ERR_CONF_BROWSER:
		str_msg = "uEUݒ肵Ă";
		break;

	case ERR_PARAM:
		str_msg = "VXeG[";
		break;
	case ERR_MESSAGE:
		str_msg = "{͂Ă";
		break;
	case ERR_SUBJECT:
		str_msg = "Xbh͂Ă";
		break;

	case ERR_DOLIB_AUTH:
		str_msg = "F؃G[";
		break;

	case ERR_JBBS_BBS_NOT_FOUND:
		str_msg = "ERR_JBBS_BBS_NOT_FOUND";
		break;
	case ERR_JBBS_KEY_NOT_FOUND:
		str_msg = "ERR_JBBS_KEY_NOT_FOUND";
		break;
	case ERR_JBBS_THREAD_NOT_FOUND:
		str_msg = "ERR_JBBS_THREAD_NOT_FOUND";
		break;
	case ERR_JBBS_STORAGE_IN:
		str_msg = "ERR_JBBS_STORAGE_IN";
		break;
	case ERR_JBBS_SYSTEM:
		str_msg = "ERR_JBBS_SYSTEM";
		break;
	default:
		_ASSERT(1);
	}

	CString cstr_msg;
	cstr_msg = str_msg;
	AfxMessageBox(cstr_msg, MB_OK|MB_ICONSTOP);
}

void MessageLoop(DWORD dw_msec)
{
//	DWORD dw_time = ::GetTickCount();
//	do {
		MSG msg;
		while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) {
			TranslateMessage((LPMSG)&msg);
			DispatchMessage((LPMSG)&msg);
		}
//	} while ((::GetTickCount() - dw_time) >= dw_msec);
}

void HtmlToText(
	CYoString &str_src)
{
	str_src.Replace( "<br>", LF );
	int in_sta;
	int in_end;
	while( (in_sta = str_src.Find("<")) >= 0 ){
		in_end = str_src.Find( ">", in_sta );
		if( in_end == -1 ){
			break;
		}
		str_src.Remove( in_sta, in_end-in_sta+1 );
	}
	str_src.Replace( "&gt;", ">" );
	str_src.Replace( "&lt;", "<" );
	str_src.Replace( "&amp;", "&" );
	str_src.Replace( "&quot;", "\"" );
	str_src.Replace( "&nbsp;", " " );
}

void RenameFile(
	const char *chp_filename_src,
	const char *chp_filename_dst)
{
	CString cstr_src;
	CString cstr_dst;
	cstr_src = chp_filename_src;
	cstr_dst = chp_filename_dst;
	try {
		CFile::Remove(cstr_dst);
	} catch (CFileException* pEx) {
		pEx->Delete();
	}
	try {
		CFile::Rename(cstr_src, cstr_dst);
	} catch (CFileException* pEx) {
		pEx->Delete();
	}
}

void RemoveFile(
	const char *chp_filename)
{
	CString cstr_filename;
	cstr_filename = chp_filename;
	try {
		CFile::Remove(cstr_filename);
	} catch (CFileException* pEx) {
		pEx->Delete();
	}
}

BOOL CopyDirectory(
	const char *chp_src,
	const char *chp_dst)
{
	CString cstr_find;
	WIN32_FIND_DATA st_find;
	HANDLE hFind;

	// fBNg쐬Ă
	MakeDirectory(chp_dst);

	cstr_find = chp_src;
	cstr_find += "\\*.*";
	hFind = ::FindFirstFile(cstr_find, &st_find);
	if (hFind == INVALID_HANDLE_VALUE) {
		// t@CȂ
		return FALSE;
	}

	do {
		if (wcscmp(st_find.cFileName, _T(".")) == 0 || wcscmp(st_find.cFileName, _T("..")) == 0) continue;

		if (st_find.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
			// ċA
			CYoString str_src = chp_src;
			str_src += "\\";
			str_src += A(st_find.cFileName);

			CYoString str_dst = chp_dst;
			str_dst += "\\";
			str_dst += A(st_find.cFileName);
			CopyDirectory(str_src, str_dst);
		} else {
			// t@CRs[
			CString cstr_filename_src;
			cstr_filename_src = chp_src;
			cstr_filename_src += _T("\\");
			cstr_filename_src += st_find.cFileName;

			CString cstr_filename_dst;
			cstr_filename_dst = chp_dst;
			cstr_filename_dst += _T("\\");
			cstr_filename_dst += st_find.cFileName;

			::CopyFile(cstr_filename_src, cstr_filename_dst, FALSE);
		}
	} while (FindNextFile(hFind, &st_find));
	::FindClose(hFind);
	return TRUE;
}

BOOL RemoveDirectory(
	const char *chp_dir)
{
	CString cstr_find;
	WIN32_FIND_DATA st_find;
	HANDLE hFind;

	cstr_find = chp_dir;
	cstr_find += "\\*.*";
	hFind = ::FindFirstFile(cstr_find, &st_find);
	if (hFind == INVALID_HANDLE_VALUE) {
		return FALSE;
	}

	do {
		if (wcscmp(st_find.cFileName, _T(".")) == 0 || wcscmp(st_find.cFileName, _T("..")) == 0) continue;

		if (st_find.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
			// ċA
			CYoString str_dir = chp_dir;
			str_dir += "\\";
			str_dir += A(st_find.cFileName);
			RemoveDirectory(str_dir);
		} else {
			// t@C폜
			CYoString str_filename;
			str_filename = chp_dir;
			str_filename += "\\";
			str_filename += A(st_find.cFileName);
			RemoveFile(str_filename);
		}
	} while (FindNextFile(hFind, &st_find));
	::FindClose(hFind);
	CString cstr_dir;
	cstr_dir = chp_dir;
	return ::RemoveDirectory(cstr_dir);
}

BOOL StringToClipboard(
	const TCHAR *lpszText)
{
	if (OpenClipboard(AfxGetMainWnd()->m_hWnd) == FALSE) {
		return FALSE;
	}
	if (EmptyClipboard() == FALSE) {
		CloseClipboard();
		return FALSE;
	}

	HANDLE hMem;
	if ((hMem = GlobalAlloc(GHND, sizeof(TCHAR) * lstrlen(lpszText) + sizeof(TCHAR) * 1)) == NULL) {
		CloseClipboard();
		return FALSE;
	}

	TCHAR *buf;
	if ((buf = (TCHAR*)GlobalLock(hMem)) == NULL) {
		GlobalFree(hMem);
		CloseClipboard();
		return FALSE;
	}
	CopyMemory(buf, lpszText, sizeof(TCHAR) * lstrlen(lpszText));

	*(buf + lstrlen(lpszText)) = TEXT('\0');
	GlobalUnlock(hMem);
#ifdef UNICODE
	SetClipboardData(CF_UNICODETEXT, hMem);
#else
	SetClipboardData(CF_TEXT, hMem);
#endif

	CloseClipboard();
	return TRUE;
}

int Atoi(
	const char *chp_num)
{
	CYoString str_num = chp_num;
	str_num.Replace("O", "0");
	str_num.Replace("P", "1");
	str_num.Replace("Q", "2");
	str_num.Replace("R", "3");
	str_num.Replace("S", "4");
	str_num.Replace("T", "5");
	str_num.Replace("U", "6");
	str_num.Replace("V", "7");
	str_num.Replace("W", "8");
	str_num.Replace("X", "9");
	return str_num.Atoi();
}