#include "stdafx.h"
#include "YoRegex.h"
#include "q2chwmCommon.h"
#include "q2chwmBbsSubject.h"

Cq2chwmBbsSubjectManager::Cq2chwmBbsSubjectManager(
	const char *chp_url)
{
	CYoRegex cRegex;
	if (cRegex.Match("([^/.]+)\\.machibbs\\.com.*|([^/.]+)\\.machi\\.to.*", chp_url) >= 0) {
		m_pBbsSubject = new Cq2chwmBbsSubjectMachi();
	} else if (cRegex.Match("jbbs\\.livedoor\\.jp.*", chp_url) >= 0) {
		m_pBbsSubject = new Cq2chwmBbsSubjectLivedoor();
	} else {
		m_pBbsSubject = new Cq2chwmBbsSubject();
	}
}

Cq2chwmBbsSubjectManager::~Cq2chwmBbsSubjectManager()
{
	if (m_pBbsSubject != NULL) delete m_pBbsSubject;
}

Cq2chwmBbsSubject::Cq2chwmBbsSubject()
{
	m_chp_aid = NULL;
	m_chp_aname = NULL;
	m_chp_count = NULL;
	m_chp_bname = NULL;
	m_chp_burl = NULL;
}

Cq2chwmBbsSubject::~Cq2chwmBbsSubject()
{
}

/*!
 * \brief
 * subject.txt1sp[X.
 * chp_line͊eڂƂ\0ŋ؂(const char*łȂƂɒ)
 *
 * \param chp_line
 * subject.txt̍s.
 * 
 * \returns
 * I: ERR_NONE ُI: ERR_NONEȊO.
 * 
 */
BOOL Cq2chwmBbsSubject::Parse(
	char *chp_line)
{
	// K\gȂ(K\ł1/4炢̏xōς)
	{
		char *chp_aid;
		char *chp_aname;
		char *chp_count;
		char *chp_tmp;
		
		// ID擾
		chp_aid = (char*)chp_line;
		chp_tmp = strchr(chp_line, '.');
		if (chp_tmp == NULL) return ERR_FILE_FORMAT;
		*chp_tmp = 0x00;

		// Xbh擾
		chp_tmp++;
		chp_aname = strchr(chp_tmp, '>');
		if (chp_aname == NULL) return ERR_FILE_FORMAT;
		chp_aname++;
		chp_tmp = strrchr(chp_aname, ' ');
		if (chp_tmp == NULL) return ERR_FILE_FORMAT;
		*chp_tmp = 0x00;

		// JEg擾
		chp_tmp++;
		if (*chp_tmp != '(') return ERR_FILE_FORMAT;
		chp_count = chp_tmp + 1;
		chp_tmp = strchr(chp_count, ')');
		if (chp_tmp == NULL) return ERR_FILE_FORMAT;
		*chp_tmp = 0x00;

		chp_tmp++;

		// oϐɃZbg
		SetArticleName(chp_aname);
		SetArticleId(chp_aid);
		SetCount(chp_count);

		if (*chp_tmp != 0x00) {
			// Q˂錟gtH[}bg
			char *chp_bname;
			char *chp_burl;

			// URL擾
			chp_burl = strchr(chp_tmp, '>');
			if (chp_burl == NULL) return ERR_FILE_FORMAT;
			chp_burl++;
			chp_tmp = strchr(chp_burl, '<');
			if (chp_tmp == NULL) return ERR_FILE_FORMAT;
			*chp_tmp = 0x00;

			// 擾
			chp_tmp++;
			chp_bname = strchr(chp_tmp, '>');
			if (chp_bname == NULL) return ERR_FILE_FORMAT;
			chp_bname++;

			// ID擾
			{
				CYoRegex cRegex("http://[^/]+/([^/]+)/");
				if (cRegex.Match(chp_burl) >= 0) {
					SetBoardId(cRegex.Get(1));
				}
			}

			// AURLoϐɃZbg
			SetBoardName(chp_bname);
			SetBoardUrl(chp_burl);
		}
	}

	/* K\
	{
		static CYoRegex cRegex("^(([0-9]+)\\..+)<>(.+) \\(([0-9]+)\\)", CYoRegex::SJIS);
		static CYoRegex cRegexEx("<>(.+?)<>(.+)$", CYoRegex::SJIS);
		if (cRegex.Match(cha_buff) >= 0) {
			CYoString str_tmp_aid = cRegex.Get(2);
			CYoString str_tmp_aname = cRegex.Get(3);
			str_tmp_aname.Trim();
			CYoString str_tmp_count = cRegex.Get(4);
			CYoString str_tmp_bname = str_bname;
			CYoString str_tmp_burl = str_burl;
			// ʏtH[}bg
			if (cRegexEx.Match(cha_buff, strlen(cRegex.Get(0))) >= 0) {
				// Q˂錟gtH[}bg
				str_tmp_bname = cRegexEx.Get(2);
				str_tmp_burl = cRegexEx.Get(1);
			}
			Cq2chwmSubjectItem *pItem = new Cq2chwmSubjectItem(in_index, str_tmp_aname, str_tmp_aid, str_tmp_bname, str_tmp_burl, str_tmp_count);
			Add(pItem);
		} else {
			// tH[}bgG[
			return ERR_FILE_FORMAT;
		}
	}
	*/
	return TRUE;
}

/*
 * [ID].cgi,[X^C]([JEg])
 */
BOOL Cq2chwmBbsSubjectMachi::Parse(
	char *chp_line)
{
	char *chp_aid;
	char *chp_aname;
	char *chp_count;
	char *chp_tmp;

	// ID擾
	chp_aid = chp_line;
	chp_tmp = strchr(chp_aid, '.');
	if (chp_tmp == NULL) return FALSE;
	*chp_tmp = 0x00;

	// Xbh擾
	chp_tmp++;
	chp_tmp = strchr(chp_tmp, ',');
	if (chp_tmp == NULL) return FALSE;
	chp_tmp++;
	chp_aname = chp_tmp;
	chp_tmp = strrchr(chp_aname, '(');
	if (chp_tmp == NULL) return FALSE;
	*chp_tmp = 0x00;

	// JEg擾
	chp_tmp++;
	chp_count = chp_tmp;
	chp_tmp = strrchr(chp_count, ')');
	if (chp_tmp == NULL) return FALSE;
	*chp_tmp = 0x00;

	// oϐɃZbg
	SetArticleId(chp_aid);
	SetArticleName(chp_aname);
	SetCount(chp_count);

	return TRUE;
}

/*
 * [ID].cgi,[X^C]([JEg])
 */
BOOL Cq2chwmBbsSubjectLivedoor::Parse(
	char *chp_line)
{
	char *chp_aid;
	char *chp_aname;
	char *chp_count;
	char *chp_tmp;

	// ID擾
	chp_aid = chp_line;
	chp_tmp = strchr(chp_aid, '.');
	if (chp_tmp == NULL) return FALSE;
	*chp_tmp = 0x00;

	// Xbh擾
	chp_tmp++;
	chp_tmp = strchr(chp_tmp, ',');
	if (chp_tmp == NULL) return FALSE;
	chp_tmp++;
	chp_aname = chp_tmp;
	chp_tmp = strrchr(chp_aname, '(');
	if (chp_tmp == NULL) return FALSE;
	*chp_tmp = 0x00;

	// JEg擾
	chp_tmp++;
	chp_count = chp_tmp;
	chp_tmp = strrchr(chp_count, ')');
	if (chp_tmp == NULL) return FALSE;
	*chp_tmp = 0x00;

	// oϐɃZbg
	m_str_aname = chp_aname;
	m_str_aname.ConvertKCodeEx(CYoString::EUCTOSJIS);
	SetArticleId(chp_aid);
	SetArticleName(m_str_aname);
	SetCount(chp_count);

	return TRUE;
}
