#include "stdafx.h"
#include "q2chwmCommon.h"
#include "q2chwmConfig.h"
#include "q2chwmMessage.h"

/*
 * ANSI->WIDE
 */
CString W(
	const char *chp_string)
{
	CString str_ret;
	int in_len = MultiByteToWideChar(CP_ACP, 0, chp_string, -1, NULL,0);
	if (in_len == 0) return CString();
	wchar_t *wchp_string = (wchar_t*)malloc(sizeof(wchar_t) * in_len);
	MultiByteToWideChar(CP_ACP, 0, chp_string, -1, wchp_string, in_len);
	str_ret = wchp_string;
	free(wchp_string);
	return str_ret;
}

/*
 * WIDE -> ANSI
 */
CYoString A(
	const wchar_t *wchp_string)
{
	CYoString str_ret;
	int in_len = WideCharToMultiByte(CP_ACP, 0, wchp_string, -1, NULL, 0, NULL, NULL);
	if (in_len == 0) return CYoString();
	char *chp_string = (char*)malloc(sizeof(char) * in_len);
	WideCharToMultiByte(CP_ACP, 0, wchp_string, -1, chp_string, in_len, NULL, NULL);
	str_ret = chp_string;
	free(chp_string);
	return str_ret;
}

CYoString UrlToPath(
	const char *chp_url)
{
	if (chp_url == NULL) return CYoString();
	const char *chp_tmp = strstr(chp_url, "://");
	if (chp_tmp == NULL) return CYoString();
	chp_tmp += 3;
	CYoString str_ret = Cq2chwmConfig::GetInstance()->GetRootDirectory();
	if (*((const char*)str_ret + str_ret.Length() - 1) != '\\') str_ret += "\\";
	str_ret += chp_tmp;
	str_ret.Replace("/", "\\");
	if (*((const char*)str_ret + str_ret.Length() - 1) == '\\') str_ret.Remove(str_ret.Length() - 1);
	return str_ret;
}

CYoString UrlToImagePath(
	const char *chp_url)
{
	// [[gfBNg]\.img\[gqURLURLGR[h].[gq]Ƃt@CpX쐬
	if (chp_url == NULL) return CYoString();
	const char *chp_tmp = strstr(chp_url, "://");
	if (chp_tmp == NULL) return CYoString();
	chp_tmp += 3;
	CYoString str_ret = Cq2chwmConfig::GetInstance()->GetRootDirectory();
	if (*((const char*)str_ret + str_ret.Length() - 1) != '\\') str_ret += "\\";

	// TufBNgt
	str_ret += ".img\\";

	// gqURLURLGR[h
	const char *chp_ext = strrchr(chp_url, '.');

	// t@CɎgpłȂ܂łgqƂĈ
	if (chp_ext != NULL &&
		(
		strrchr(chp_ext, '\\') != NULL ||
		strrchr(chp_ext, '/') != NULL ||
		strrchr(chp_ext, ':') != NULL ||
		strrchr(chp_ext, '*') != NULL ||
		strrchr(chp_ext, '?') != NULL ||
		strrchr(chp_ext, '"') != NULL ||
		strrchr(chp_ext, '<') != NULL ||
		strrchr(chp_ext, '>') != NULL ||
		strrchr(chp_ext, '|') != NULL
		))
	{
		chp_ext = NULL;
	}

	CYoString str_filename;
	if (chp_ext != NULL) {
		str_filename.StrnCpy(chp_tmp, chp_ext - chp_tmp);
	} else {
		str_filename = chp_tmp;
	}
	str_filename.UrlEncode();
	str_ret += str_filename;

	// gqt
	if (chp_ext != NULL) {
		str_ret += chp_ext;
	}
	if (*((const char*)str_ret + str_ret.Length() - 1) == '\\') str_ret.Remove(str_ret.Length() - 1);
	return str_ret;
}

BOOL ExistFile(
	const char *chp_filename,
	ULONGLONG *ullp_length,
	FILETIME *stp_modify)
{
	CString cstr_filename;
	cstr_filename = chp_filename;
	if (ullp_length == NULL && stp_modify == NULL) {
		// t@CTCYƍXVKvȂ΁A݃`FbNɃRXg̒ႻGetFileAttributesg
		return ::GetFileAttributes(cstr_filename) == -1 ? FALSE : TRUE;
	}

	WIN32_FIND_DATA st_find;
	HANDLE hFind = ::FindFirstFile(cstr_filename, &st_find);
	if (hFind != INVALID_HANDLE_VALUE) {
		if (ullp_length != NULL) *ullp_length = (st_find.nFileSizeHigh * MAXDWORD) + st_find.nFileSizeLow;
		if (stp_modify != NULL) *stp_modify = st_find.ftLastWriteTime;
		::FindClose(hFind);
		return TRUE;
	}
	return FALSE;
}

BOOL MakeDirectory(
	const char *chp_dir)
{
	CString cstr_dir;
	cstr_dir = chp_dir;
	WIN32_FIND_DATA st_find;
	HANDLE hFind = ::FindFirstFile(cstr_dir, &st_find);
	if (hFind == INVALID_HANDLE_VALUE) {
		const char *chp_tmp = strrchr(chp_dir, '\\');
		if( chp_tmp != NULL ){
			CYoString str_dir;
			str_dir.StrnCpy( chp_dir, chp_tmp-chp_dir);
			MakeDirectory(str_dir);
		}
		if (::CreateDirectory(cstr_dir, NULL) == FALSE) {
			return FALSE;
		}
	} else {
		::FindClose(hFind);
	}

	return TRUE;
}

CYoString GetBaseName(
	const char *chp_filename)
{
	if (chp_filename == NULL) return CYoString();
	const char *chp_tmp = strrchr(chp_filename, '\\');
	if (chp_tmp == NULL) return CYoString();
	CYoString str_ret;
	str_ret.StrnCpy(chp_filename, chp_tmp - chp_filename);
	return str_ret;
}

BOOL CleanFileTime(
	const char *chp_filename)
{
	CString cstr_filename;
	cstr_filename = chp_filename;
	// 1970/1/1 00:00:00FILETIME
	FILETIME st_time = {3577643008, 27111902};
	HANDLE hFile = ::CreateFile(cstr_filename, GENERIC_WRITE, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hFile == INVALID_HANDLE_VALUE) return FALSE;
	::SetFileTime(hFile, NULL, NULL, &st_time);
	::CloseHandle(hFile);
	return TRUE;
}

//! eEBhEPostMessage
/*!
 * XbhGUI𑀍삷Ƃ͕KCxgg
 * \param pEvent 
 * \return void 
 */
void PostCustomMessage(
	HWND hWnd,
	Cq2chwmMessage *pMessage)
{
	// bZ[W2chNJƂɃ^uɃXbh͂ȂƂ邽
	// SendMessageȂƃ_
	//::PostMessage(hWnd, pMessage->GetMessage(), 0, (LPARAM)pMessage);
	::SendMessage(hWnd, pMessage->GetMessage(), 0, (LPARAM)pMessage);
}

CYoString ConvertGmtTime(
	FILETIME *stp_modify)
{
	static const char *chpa_week[] = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
	static const char *chpa_month[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
	CYoString str_ret;
	SYSTEMTIME st_system;
	::FileTimeToSystemTime(stp_modify , &st_system);
	// Thu, 19 Jan 2006 04:27:55 GMT 
	str_ret.Format("%s, %d %s %d %02d:%02d:%02d GMT",
		chpa_week[st_system.wDayOfWeek],		// j
		st_system.wDay,							// 
		chpa_month[st_system.wMonth - 1],		// 
		st_system.wYear,						// N
		st_system.wHour,						// 
		st_system.wMinute,						// 
		st_system.wSecond);						// b

	return str_ret;
}

void ErrorMessageBox(
	const char *chp_err,
	HWND hWnd)
{
	CString cstr_msg;
	cstr_msg = chp_err;
	if (hWnd == NULL) {
		AfxMessageBox(cstr_msg, MB_OK|MB_ICONSTOP);
	} else {
		::MessageBox(hWnd, cstr_msg, _T(APP_NAME), MB_OK|MB_ICONSTOP);
	}
}

void ErrorMessageBox(
	int in_err,
	HWND hWnd)
{
	CYoString str_msg;
	switch(in_err){
	case ERR_NONE:
	case ERR_CANCELED:
		// G[Ƃ͂Ȃ
		break;
	case ERR_HTTP_CONNECT:
		str_msg = "ڑG[";
		break;
	case ERR_HTTP_GET:
		str_msg = "HTTPG[(GET)";
		break;
	case ERR_HTTP_RECV:
		str_msg = "HTTPG[(RECV)";
		break;
	case ERR_HTTP_NOTMODIFIED:
		// G[Ƃ͂Ȃ
		break;
	case ERR_HTTP_LOCATION:
		str_msg = "Xbh܂ł";
		break;
	case ERR_HTTP_ABONE:
		// ꂪԂ邱Ƃ͂Ȃ
		_ASSERT(1);
		break;

	case ERR_FILE_OPEN:
		str_msg = "t@CI[vG[";
		break;
	case ERR_FILE_FORMAT:
		str_msg = "t@CtH[}bgG[";
		break;
	case ERR_FILE_CONVERT:
		str_msg = "ERR_FILE_WRITE_CONVERT";
		break;
	case ERR_FILE_WRITE:
		str_msg = "t@C݃G[";
		break;

	case ERR_CONF_BROWSER:
		str_msg = "uEUݒ肵Ă";
		break;

	case ERR_PARAM:
		str_msg = "VXeG[";
		break;
	case ERR_MESSAGE:
		str_msg = "{͂Ă";
		break;
	case ERR_SUBJECT:
		str_msg = "Xbh͂Ă";
		break;

	case ERR_DOLIB_AUTH:
		str_msg = "F؃G[";
		break;

	case ERR_JBBS_BBS_NOT_FOUND:
		str_msg = "ERR_JBBS_BBS_NOT_FOUND";
		break;
	case ERR_JBBS_KEY_NOT_FOUND:
		str_msg = "ERR_JBBS_KEY_NOT_FOUND";
		break;
	case ERR_JBBS_THREAD_NOT_FOUND:
		str_msg = "ERR_JBBS_THREAD_NOT_FOUND";
		break;
	case ERR_JBBS_STORAGE_IN:
		str_msg = "ERR_JBBS_STORAGE_IN";
		break;
	case ERR_JBBS_SYSTEM:
		str_msg = "ERR_JBBS_SYSTEM";
		break;
	default:
		_ASSERT(1);
	}

	CString cstr_msg;
	cstr_msg = str_msg;
	if (hWnd == NULL) {
		AfxMessageBox(cstr_msg, MB_OK|MB_ICONSTOP);
	} else {
		::MessageBox(hWnd, cstr_msg, _T(APP_NAME), MB_OK|MB_ICONSTOP);
	}
}

void MessageLoop(DWORD dw_msec)
{
//	DWORD dw_time = ::GetTickCount();
//	do {
		MSG msg;
		while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) {
			TranslateMessage((LPMSG)&msg);
			DispatchMessage((LPMSG)&msg);
		}
//	} while ((::GetTickCount() - dw_time) >= dw_msec);
}

void HtmlToText(
	CYoString &str_src)
{
	str_src.Replace( "<br>", LF );
	int in_sta;
	int in_end;
	while( (in_sta = str_src.Find("<")) >= 0 ){
		in_end = str_src.Find( ">", in_sta );
		if( in_end == -1 ){
			break;
		}
		str_src.Remove( in_sta, in_end-in_sta+1 );
	}
	str_src.Replace( "&gt;", ">" );
	str_src.Replace( "&lt;", "<" );
	str_src.Replace( "&amp;", "&" );
	str_src.Replace( "&quot;", "\"" );
	str_src.Replace( "&nbsp;", " " );
}

void TextToHtml(
	CYoString &str_src)
{
	str_src.Replace( LF, "<br>" );
	str_src.Replace( "&", "&amp;" );
	str_src.Replace( ">", "&gt;" );
	str_src.Replace( "<", "&lt;" );
	str_src.Replace( "\"", "&quot;" );
	str_src.Replace( " ", "&nbsp;" );
}

BOOL RenameFile(
	const char *chp_filename_src,
	const char *chp_filename_dst)
{
	CString cstr_src;
	CString cstr_dst;
	cstr_src = chp_filename_src;
	cstr_dst = chp_filename_dst;
	try {
		CFile::Remove(cstr_dst);
	} catch (CFileException* pEx) {
		pEx->Delete();
	}
	try {
		CFile::Rename(cstr_src, cstr_dst);
	} catch (CFileException* pEx) {
		pEx->Delete();
		return FALSE;
	}
	return TRUE;
}

BOOL RemoveFile(
	const char *chp_filename)
{
	CString cstr_filename;
	cstr_filename = chp_filename;
	try {
		CFile::Remove(cstr_filename);
	} catch (CFileException* pEx) {
		pEx->Delete();
		return FALSE;
	}
	return TRUE;
}

BOOL CopyDirectory(
	const char *chp_src,
	const char *chp_dst)
{
	CString cstr_find;
	WIN32_FIND_DATA st_find;
	HANDLE hFind;

	// fBNg쐬Ă
	MakeDirectory(chp_dst);

	cstr_find = chp_src;
	cstr_find += "\\*.*";
	hFind = ::FindFirstFile(cstr_find, &st_find);
	if (hFind == INVALID_HANDLE_VALUE) {
		// t@CȂ
		return FALSE;
	}

	do {
		if (wcscmp(st_find.cFileName, _T(".")) == 0 || wcscmp(st_find.cFileName, _T("..")) == 0) continue;

		if (st_find.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
			// ċA
			CYoString str_src = chp_src;
			str_src += "\\";
			str_src += A(st_find.cFileName);

			CYoString str_dst = chp_dst;
			str_dst += "\\";
			str_dst += A(st_find.cFileName);
			CopyDirectory(str_src, str_dst);
		} else {
			// t@CRs[
			CString cstr_filename_src;
			cstr_filename_src = chp_src;
			cstr_filename_src += _T("\\");
			cstr_filename_src += st_find.cFileName;

			CString cstr_filename_dst;
			cstr_filename_dst = chp_dst;
			cstr_filename_dst += _T("\\");
			cstr_filename_dst += st_find.cFileName;

			::CopyFile(cstr_filename_src, cstr_filename_dst, FALSE);
		}
	} while (FindNextFile(hFind, &st_find));
	::FindClose(hFind);
	return TRUE;
}

BOOL RemoveDirectory(
	const char *chp_dir)
{
	CString cstr_dir;
	cstr_dir = chp_dir;
	CString cstr_find;
	WIN32_FIND_DATA st_find;
	HANDLE hFind;

	cstr_find = chp_dir;
	cstr_find += "\\*.*";
	hFind = ::FindFirstFile(cstr_find, &st_find);
	if (hFind == INVALID_HANDLE_VALUE) {
		if (::GetLastError() == 18) {
			// fBNg̏ꍇ
			return ::RemoveDirectory(cstr_dir);
		}
		return FALSE;
	}

	do {
		if (wcscmp(st_find.cFileName, _T(".")) == 0 || wcscmp(st_find.cFileName, _T("..")) == 0) continue;

		if (st_find.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
			// ċA
			CYoString str_dir = chp_dir;
			str_dir += "\\";
			str_dir += A(st_find.cFileName);
			if (RemoveDirectory(str_dir) == FALSE) {
				break;
			}
		} else {
			// t@C폜
			CYoString str_filename;
			str_filename = chp_dir;
			str_filename += "\\";
			str_filename += A(st_find.cFileName);
			if (RemoveFile(str_filename) == FALSE) {
				break;
			}
		}
	} while (FindNextFile(hFind, &st_find));
	::FindClose(hFind);
	return ::RemoveDirectory(cstr_dir);
}

BOOL StringToClipboard(
	const TCHAR *lpszText)
{
	if (OpenClipboard(AfxGetMainWnd()->m_hWnd) == FALSE) {
		return FALSE;
	}
	if (EmptyClipboard() == FALSE) {
		CloseClipboard();
		return FALSE;
	}

	HANDLE hMem;
	if ((hMem = GlobalAlloc(GHND, sizeof(TCHAR) * lstrlen(lpszText) + sizeof(TCHAR) * 1)) == NULL) {
		CloseClipboard();
		return FALSE;
	}

	TCHAR *buf;
	if ((buf = (TCHAR*)GlobalLock(hMem)) == NULL) {
		GlobalFree(hMem);
		CloseClipboard();
		return FALSE;
	}
	CopyMemory(buf, lpszText, sizeof(TCHAR) * lstrlen(lpszText));

	*(buf + lstrlen(lpszText)) = TEXT('\0');
	GlobalUnlock(hMem);
#ifdef UNICODE
	SetClipboardData(CF_UNICODETEXT, hMem);
#else
	SetClipboardData(CF_TEXT, hMem);
#endif

	CloseClipboard();
	return TRUE;
}

int Atoi(
	const char *chp_num)
{
	CYoString str_num = chp_num;
	str_num.Replace("O", "0");
	str_num.Replace("P", "1");
	str_num.Replace("Q", "2");
	str_num.Replace("R", "3");
	str_num.Replace("S", "4");
	str_num.Replace("T", "5");
	str_num.Replace("U", "6");
	str_num.Replace("V", "7");
	str_num.Replace("W", "8");
	str_num.Replace("X", "9");
	return str_num.Atoi();
}

void ChangeSip(
	HWND hWnd,
	DWORD dwCode)
{
	HIMC hIMC;
	DWORD dwConversion;
	DWORD dwSentence;
	hIMC = ::ImmGetContext(hWnd);
	::ImmGetConversionStatus(hIMC, &dwConversion, &dwSentence);
	::ImmSetConversionStatus(hIMC, dwCode, dwSentence);
	::ImmReleaseContext(hWnd, hIMC);
}

void SipOff(
	HWND hWnd)
{
	::ImmAssociateContext(hWnd, NULL) ;
//	ChangeSip(hWnd, IME_CMODE_ALPHANUMERIC);
}

void SipOn(
	HWND hWnd)
{
	ChangeSip(hWnd, IME_CMODE_FULLSHAPE|IME_CMODE_NATIVE);
}

BOOL GetClipBoardText(
	HWND hWnd,
	CString &cstr_text)
{
	if (::OpenClipboard(hWnd) == 0) {
		return FALSE;
	}
	HANDLE hClip;
	TCHAR *p;

#ifdef UNICODE
	hClip = ::GetClipboardData(CF_UNICODETEXT);
#else
	hClip = GetClipboardData(CF_TEXT);
#endif
	p = (TCHAR*)GlobalLock(hClip);
	if (p == NULL) {
		::CloseClipboard();
		return FALSE;
	}
	cstr_text = p;
	GlobalUnlock(hClip);
	::CloseClipboard();
	return TRUE;
}

CYoString ConvertZenkaku(
	int in_num)
{
	CYoString str_num = in_num;
	str_num.Replace("0", "O");
	str_num.Replace("1", "P");
	str_num.Replace("2", "Q");
	str_num.Replace("3", "R");
	str_num.Replace("4", "S");
	str_num.Replace("5", "T");
	str_num.Replace("6", "U");
	str_num.Replace("7", "V");
	str_num.Replace("8", "W");
	str_num.Replace("9", "X");
	return str_num;
}

const wchar_t *GetId(
	wchar_t *lpszId,
	DWORD *lpdwSize,
	const wchar_t* lpszText)
{
	while (*lpszText != 0 && *lpszText != _T('\r') && *lpszText != _T('\n')) {
		if (_tcsncmp(lpszText, _T("ID:"), 3) != 0) {
			lpszText++;
			continue;
		} else {
			lpszText += 3;

			// pXy[X΂
			while (*lpszText == _T(' ')) lpszText++;
			const wchar_t *lpszRet = lpszText;
			if (*lpszText == _T('?')) return NULL;
			DWORD dwIndex = 0;
			while (dwIndex < (*lpdwSize - 1) && *lpszText != 0 && *lpszText != _T(' ') && *lpszText != _T('\r') && *lpszText != _T('\n')) {
				lpszId[dwIndex++] = *lpszText;
				lpszText++;
			}
			lpszId[dwIndex] = 0;
			*lpdwSize = dwIndex;
			return lpszRet;
		}
	}
	return NULL;
}

const wchar_t *GetRefer(
	wchar_t *lpszNumber,
	DWORD *lpdwSize,
	const wchar_t *lpszText)
{
	while (*lpszText != 0) {
		if (*lpszText == _T('>') || *lpszText == _T('')) {
			lpszText++;
			const wchar_t *lpszRet = lpszText;
			DWORD dwIndex = 0;
			while (dwIndex < (*lpdwSize - 1) &&
				((*lpszText >= _T('0') && *lpszText <= _T('9')) ||
				(*lpszText >= _T('O') && *lpszText <= _T('X'))))
			{
				lpszNumber[dwIndex++] = *lpszText;
				lpszText++;
			}
			if (dwIndex > 0) {
				lpszNumber[dwIndex] = 0;
				*lpdwSize = dwIndex;
				return lpszRet;
			}
		} else {
			lpszText++;
		}
	}
	return NULL;
}

const wchar_t *GetNumber(
	wchar_t *lpszNumber,
	DWORD *lpdwSize,
	const wchar_t *lpszText)
{
	if (*lpszText == _T('[')) {
		lpszText++;
		const wchar_t *lpszRet = lpszText;
		DWORD dwIndex = 0;
		while (dwIndex < (*lpdwSize - 1) &&
			((*lpszText >= _T('0') && *lpszText <= _T('9')) ||
			(*lpszText >= _T('O') && *lpszText <= _T('X'))))
		{
			lpszNumber[dwIndex++] = *lpszText;
			lpszText++;
		}
		if (dwIndex > 0) {
			lpszNumber[dwIndex] = 0;
			*lpdwSize = dwIndex;
			return lpszRet;
		}
	}
	return NULL;
}

const wchar_t *GetLink(
	wchar_t *lpszLink,
	DWORD *lpdwSize,
	const wchar_t *lpszText)
{
	while (*lpszText != 0 && *lpszText != _T('\r') && *lpszText != _T('\n')) {
		if (*lpszText == _T('>') || *lpszText == _T('')) {
			lpszText++;
			const wchar_t *lpszRet = lpszText;
			DWORD dwLength = 0;
			while (*lpszText >= _T('0') && *lpszText <= _T('9') ||
				*lpszText >= _T('O') && *lpszText <= _T('X'))
			{
				dwLength++;
				lpszText++;
			}
			if (dwLength > 0) {
				while (*(lpszRet - 1) == _T('>') || *(lpszRet - 1) == _T('')) {
					dwLength++;
					lpszRet--;
				}
				if (dwLength > *lpdwSize - 1) {
					_tcsncpy(lpszLink, lpszRet, *lpdwSize - 1);
					lpszLink[*lpdwSize - 1] = 0;
					*lpdwSize = *lpdwSize - 1;
				} else {
					_tcsncpy(lpszLink, lpszRet, dwLength);
					lpszLink[dwLength] = 0;
					*lpdwSize = dwLength;
				}
				return lpszRet;
			}
		} else if (*lpszText == _T(':') && *(lpszText + 1) == _T('/') && *(lpszText + 2) == _T('/')) {
			lpszText += 3;
			const wchar_t *lpszRet = lpszText;
			DWORD dwLength = 0;
			while (*lpszText >= _T('!') && *lpszText <= _T('~')) {
				dwLength++;
				lpszText++;
			}
			if (dwLength > 0) {
				lpszRet -= 3;
				dwLength += 3;
				while (*(lpszRet - 1) >= _T('a') && *(lpszRet - 1) <= _T('z')) {
					dwLength++;
					lpszRet--;
				}
				if (dwLength > *lpdwSize - 1) {
					_tcsncpy(lpszLink, lpszRet, *lpdwSize - 1);
					lpszLink[*lpdwSize - 1] = 0;
					*lpdwSize = *lpdwSize - 1;
				} else {
					_tcsncpy(lpszLink, lpszRet, dwLength);
					lpszLink[dwLength] = 0;
					*lpdwSize = dwLength;
				}
				return lpszRet;
			}
		} else {
			lpszText++;
		}
	}
	return NULL;
}

/*
 * V[gJbg@\邽߂
 * j[𓮓IɕύXǍ
 */

void ReplaceMenu(
	CMenu *pMenu,
	BOOL bo_number)
{
	if(pMenu==NULL)	return;

	static LPCTSTR lpszShortCut[] = {
		_T("&1"), _T("&2"), _T("&3"), _T("&4"), _T("&5"), _T("&6"), _T("&7"), _T("&8"), _T("&9"), _T("&0"), _T("&*"), _T("&#")
	};
	BOOL bo_isnumbered;
	int in_num = 0;
	for (DWORD i = 0; i < pMenu->GetMenuItemCount(); i++) {
		if (in_num >= sizeof(lpszShortCut) / sizeof(lpszShortCut[0])) break;
		CString cstr_menu;
		pMenu->GetMenuString(i, cstr_menu, MF_BYPOSITION);

		//	Ōォ3ڂ_T("\t")Ȃ琔tƔf
		bo_isnumbered = FALSE;
		if (cstr_menu.Right(3).Left(1) == _T("\t")) {
			bo_isnumbered = TRUE;
		}

		TCHAR szBuff[MAX_PATH];
		_tcscpy(szBuff, cstr_menu);

		if (cstr_menu.GetLength() != 0) {
			if (bo_number) {	//	tɂ
				if (bo_isnumbered == FALSE) {
					_tcscat(szBuff, _T("\t"));
					_tcscat(szBuff, lpszShortCut[in_num++]);
				}
			} else {		//	Ȃ
				if (bo_isnumbered == TRUE) {
					_tcscpy(szBuff, cstr_menu.Left(cstr_menu.GetLength() - 3));
				}
			}
			MENUITEMINFO info;
			info.cbSize = sizeof(info);
			info.fMask = MIIM_TYPE;
			info.fType = MFT_STRING;
			info.cch = _tcslen(szBuff);
			info.dwTypeData = szBuff;
			pMenu->SetMenuItemInfo(i, &info, MF_BYPOSITION);

			CMenu *subMenu = pMenu->GetSubMenu(i);
			if (subMenu != NULL) {
				ReplaceMenu(subMenu,bo_number);
			}
		}
	}
	AfxGetMainWnd()->DrawMenuBar();
}

CYoString GetCompleteUrl(
	const char *chp_url)
{
	CYoString str_ret;
	if (strncmp(chp_url, "http", 4) == 0) {
		str_ret = chp_url;
	} else if (strncmp(chp_url, "ttp", 3) == 0) {
		str_ret.Format("h%s", chp_url);
	} else if (strncmp(chp_url, "tp", 2) == 0) {
		str_ret.Format("ht%s", chp_url);
	} else if (strncmp(chp_url, "p", 1) == 0) {
		str_ret.Format("htt%s", chp_url);
	} else {
		return str_ret;
	}
	return str_ret;
}

CString CreateRegexPattern(
	const wchar_t *wchp_pat)
{
	static LPCTSTR lpszChars[] = {
		_T("\\"), _T("."), _T("^"), _T("$"), _T("["), _T("]"), _T("*"), _T("+"), _T("?"), _T("|"), _T("("), _T(")")
	};
	CString cstr_ret = wchp_pat;
	for (int i = 0; i < _countof(lpszChars); i++) {
		CString cstr_after;
		cstr_after = _T("\\");
		cstr_after += lpszChars[i];
		cstr_ret.Replace(lpszChars[i], cstr_after);
	}
	cstr_ret.Replace(_T("\n"), _T("\\n"));
	return cstr_ret;
}

BOOL ExecuteBrowser(
	const wchar_t *lpszUrl)
{
	CYoString str_url = A(lpszUrl);
	str_url = GetCompleteUrl(str_url);
	CString cstr_url;
	cstr_url = str_url;
	CString cstr_image;
	cstr_image = Cq2chwmConfig::GetInstance()->GetBrowser();
	return Execute(cstr_image, cstr_url);
}

BOOL Execute(
	const wchar_t *lpszImage,
	const wchar_t *lpszArg)
{
	PROCESS_INFORMATION pi;
	CString cstr_image;
	cstr_image = lpszImage;
	BOOL bo_ret;
#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
	bo_ret = ::CreateProcess(lpszImage, lpszArg, NULL, NULL, FALSE, 0, NULL, NULL, NULL, &pi);
#else
	STARTUPINFO si;
	ZeroMemory(&si, sizeof(si));
	si.cb = sizeof(si);
	if (*lpszArg != 0x00) cstr_image.AppendFormat(_T(" \"%s\""), lpszArg);
	LPWSTR wchp_image = cstr_image.GetBuffer(cstr_image.GetLength() + 1);
	bo_ret = ::CreateProcess(NULL, wchp_image, NULL, NULL, FALSE, 0, NULL, NULL, &si, &pi);
	cstr_image.ReleaseBuffer();
#endif
	return bo_ret;
}
