// q2chwmListView.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmListView.h"
#include "q2chwmConfig.h"

// Cq2chwmListView

//IMPLEMENT_DYNCREATE(Cq2chwmListView, CListView)

Cq2chwmListView::Cq2chwmListView()
{
	m_pImage = new CImageList();
	m_pImage->Create(16, 16, ILC_COLOR8|ILC_MASK, 0, 4);
	m_pImage->SetBkColor(CLR_NONE);
	m_pImage->Add(AfxGetApp()->LoadIcon(IDI_NORMAL));
	m_pImage->Add(AfxGetApp()->LoadIcon(IDI_NETWORK));
	m_pImage->Add(AfxGetApp()->LoadIcon(IDI_BOOKMARK));
	m_pImage->Add(AfxGetApp()->LoadIcon(IDI_NEW));
	m_pImage->Add(AfxGetApp()->LoadIcon(IDI_NEW_THREAD));

	m_pFont = NULL;
	m_in_sortcol = 0;;
	m_bo_sortasc = TRUE;

	m_bFullRowSel = FALSE;
	m_bClientWidthSel = TRUE;
	m_cxClient = 0;
	m_cxStateImageOffset = 0;
	m_clrText = Cq2chwmConfig::GetInstance()->GetColorFore();//::GetSysColor(COLOR_WINDOWTEXT);
	m_clrTextBk = Cq2chwmConfig::GetInstance()->GetColorBack();//::GetSysColor(COLOR_WINDOW);
	m_clrBkgnd = Cq2chwmConfig::GetInstance()->GetColorBack();//::GetSysColor(COLOR_WINDOW);
	m_clrText = RGB(255, 0, 0);
	m_clrActiveText = Cq2chwmConfig::GetInstance()->GetColorActive();
	m_clrActiveTextBk = Cq2chwmConfig::GetInstance()->GetColorBack();
}

Cq2chwmListView::~Cq2chwmListView()
{
	m_pImage->DeleteImageList();
	delete m_pImage;
	if (m_pFont != NULL) delete m_pFont;
}

BEGIN_MESSAGE_MAP(Cq2chwmListView, CListView)
//	ON_NOTIFY_REFLECT(NM_CUSTOMDRAW, OnCustomDraw)
	ON_WM_SIZE()
	ON_WM_PAINT()
	ON_WM_SETFOCUS()
	ON_WM_KILLFOCUS()
	ON_WM_CREATE()
	ON_NOTIFY_REFLECT(NM_RETURN, &Cq2chwmBookmarkView::OnNMReturn)
	ON_NOTIFY_REFLECT(NM_CLICK, &Cq2chwmBookmarkView::OnNMClick)
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_GOBOTTOM, &Cq2chwmListView::OnGobottom)
	ON_COMMAND(ID_GOTOP, &Cq2chwmListView::OnGotop)
	ON_NOTIFY_REFLECT(LVN_COLUMNCLICK, &Cq2chwmListView::OnLvnColumnclick)
	ON_NOTIFY_REFLECT(LVN_GETDISPINFO, &Cq2chwmListView::OnLvnGetdispinfo)
	ON_WM_CHAR()
	ON_MESSAGE(WM_SETFONT, OnSetFont)
	ON_WM_MEASUREITEM_REFLECT()
	ON_WM_ERASEBKGND()
END_MESSAGE_MAP()


// Cq2chwmListView ff

#ifdef _DEBUG
void Cq2chwmListView::AssertValid() const
{
	CListView::AssertValid();
}

#ifndef _WIN32_WCE
void Cq2chwmListView::Dump(CDumpContext& dc) const
{
	CListView::Dump(dc);
}
#endif
#endif //_DEBUG


// Cq2chwmListView bZ[W nh
BOOL Cq2chwmListView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
//	cs.style |= LVS_REPORT|LVS_OWNERDATA|LVS_SHOWSELALWAYS;
//	cs.style |= LVS_REPORT|LVS_OWNERDRAWFIXED;
	cs.style |= WS_HSCROLL|LVS_REPORT|LVS_SINGLESEL|LVS_SHOWSELALWAYS|LVS_OWNERDATA|LVS_OWNERDRAWFIXED;
	m_bFullRowSel = TRUE;

	return CListView::PreCreateWindow(cs);
}

int Cq2chwmListView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CListView::OnCreate(lpCreateStruct) == -1)
		return -1;

	// TODO:  ɓȍ쐬R[hǉĂB
	GetListCtrl().SetImageList(m_pImage, LVSIL_STATE);

	// IMEIt
	SipOff(m_hWnd);

	return 0;
}

void Cq2chwmListView::OnNMReturn(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	OnListClicked();
	*pResult = 0;
}

void Cq2chwmListView::OnNMClick(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	OnListClicked();
	*pResult = 0;
}

void Cq2chwmListView::SetFont(
	const char *chp_name,
	int in_size,
	BOOL bo_bold)
{
	CString cstr_name;
	cstr_name = chp_name;
	LOGFONT lf;
	memset(&lf, 0x00, sizeof(lf));
	_tcscpy_s(lf.lfFaceName, LF_FACESIZE, cstr_name);
	lf.lfHeight = -::MulDiv(in_size, ::GetDeviceCaps(GetDC()->m_hDC, LOGPIXELSY), 72);
	lf.lfWeight = bo_bold == TRUE ? FW_BOLD : FW_NORMAL;
	lf.lfCharSet = DEFAULT_CHARSET;

	if (m_pFont != NULL) delete m_pFont;
	m_pFont = new CFont();
	m_pFont->CreateFontIndirect(&lf);
	GetListCtrl().SetFont(m_pFont);
}

void Cq2chwmListView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	TRACE(_T("Cq2chwmListView::OnKeyDown: %02x(%d)\n"), nChar, nChar);
	if (Cq2chwmConfig::GetInstance()->IsKeyCancel(nChar)) {
		AfxGetMainWnd()->SendMessage(WM_USER_CANCEL, 0, 0);
	} else if (Cq2chwmConfig::GetInstance()->IsKeyViewBack(nChar)) {
		AfxGetMainWnd()->SendMessage(WM_USER_VIEWBACK, 0, 0);
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyViewForward(nChar)) {
		AfxGetMainWnd()->SendMessage(WM_USER_VIEWFORWARD, 0, 0);
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyBottom(nChar)) {
		GoBottom();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyTop(nChar)) {
		GoTop();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyFind2ch(nChar)) {
		AfxGetMainWnd()->SendMessage(WM_COMMAND, ID_FIND2CH, 0);
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyMenu(nChar)) {
		AfxGetMainWnd()->SendMessage(WM_USER_POPUPMENU);
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyPageUp(nChar)) {
		GetListCtrl().SendMessage(WM_KEYDOWN, VK_PRIOR);
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyPageDown(nChar)) {
		GetListCtrl().SendMessage(WM_KEYDOWN, VK_NEXT);
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyChangeView(nChar)) {
		((Cq2chwmApp*)AfxGetApp())->PopupViewMenu();
		return;
	};

	CListView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void Cq2chwmListView::GoTop()
{
	POSITION pos = GetListCtrl().GetFirstSelectedItemPosition();
	if (pos != NULL) GetListCtrl().SetItemState((int)pos - 1, 0, LVIS_FOCUSED|LVIS_SELECTED);
	GetListCtrl().EnsureVisible(0, FALSE);
	GetListCtrl().SetItemState(0, LVIS_FOCUSED|LVIS_SELECTED, LVIS_FOCUSED|LVIS_SELECTED);
}

void Cq2chwmListView::GoBottom()
{
	POSITION pos = GetListCtrl().GetFirstSelectedItemPosition();
	if (pos != NULL) GetListCtrl().SetItemState((int)pos - 1, 0, LVIS_FOCUSED|LVIS_SELECTED);
	GetListCtrl().EnsureVisible(GetListCtrl().GetItemCount() - 1, FALSE);
	GetListCtrl().SetItemState(GetListCtrl().GetItemCount() - 1, LVIS_FOCUSED|LVIS_SELECTED, LVIS_FOCUSED|LVIS_SELECTED);
}

void Cq2chwmListView::OnGobottom()
{
	// TODO: ɃR}h nh R[hǉ܂B
	GoBottom();
}

void Cq2chwmListView::OnGotop()
{
	// TODO: ɃR}h nh R[hǉ܂B
	GoTop();
}

void Cq2chwmListView::OnLvnColumnclick(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	if (pNMLV->iSubItem == m_in_sortcol) {
		m_bo_sortasc = m_bo_sortasc == TRUE ? FALSE : TRUE;
	} else {
		m_bo_sortasc = TRUE;
	}
	m_in_sortcol = pNMLV->iSubItem;
	SortItems(m_in_sortcol, m_bo_sortasc);
	*pResult = 0;
}

void Cq2chwmListView::OnLvnGetdispinfo(NMHDR *pNMHDR, LRESULT *pResult)
{
	NMLVDISPINFO *pDispInfo = reinterpret_cast<NMLVDISPINFO*>(pNMHDR);
	// TODO: ɃRg[ʒmnh R[hǉ܂B
//	TRACE(_T("Cq2chwmListView::OnLvnGetdispinfo: %d, %d\n"), pDispInfo->item.iItem, pDispInfo->item.iSubItem);

	if (pDispInfo->item.mask & LVIF_TEXT) {
		GetItemText(pDispInfo->item.pszText, pDispInfo->item.cchTextMax, pDispInfo->item.iItem, pDispInfo->item.iSubItem);
	}
	if (pDispInfo->item.mask & LVIF_IMAGE) {
		//TRACE(_T("Cq2chwmListView::OnLvnGetdispinfo: LVIF_IMAGE\n"));
	}
	if (pDispInfo->item.mask & LVIF_PARAM) {
		//TRACE(_T("Cq2chwmListView::OnLvnGetdispinfo: LVIF_PARAM\n"));
	}
	//TRACE(_T("Cq2chwmListView::OnLvnGetdispinfo: %d\n"), pDispInfo->item.mask);
	*pResult = 0;
}

void Cq2chwmListView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	// L[Ō@\
	//CListViewEx::OnChar(nChar, nRepCnt, nFlags);
}

COLORREF Cq2chwmListView::GetForeColor(
	int iRow)
{
	Cq2chwmListItem *pItem = GetItem(iRow);
	if (pItem->GetSearch() == TRUE) {
		return Cq2chwmConfig::GetInstance()->GetColorSearch();
	}
	return Cq2chwmConfig::GetInstance()->GetColorFore();
}

COLORREF Cq2chwmListView::GetBackColor(
	int iRow)
{
	Cq2chwmListItem *pItem = GetItem(iRow);
	if (pItem->GetCache() == TRUE) {
		return Cq2chwmConfig::GetInstance()->GetColorCache();
	} else 	if (pItem->GetNew() == TRUE) {
		return Cq2chwmConfig::GetInstance()->GetColorNew();
	} else if (pItem->GetError() == TRUE) {
		return Cq2chwmConfig::GetInstance()->GetColorError();
	}
	return Cq2chwmConfig::GetInstance()->GetColorBack();
}

int Cq2chwmListView::GetState(
	int iRow)
{
	Cq2chwmListItem *pItem = GetItem(iRow);
	return (int)pItem->GetState();
}

#define OFFSET_FIRST    2
#define OFFSET_OTHER    6

void Cq2chwmListView::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct)
{
	CListCtrl& ListCtrl=GetListCtrl();
	CDC* pDC = CDC::FromHandle(lpDrawItemStruct->hDC);
	CRect rcItem(lpDrawItemStruct->rcItem);
	UINT uiFlags = ILD_TRANSPARENT;
	CImageList* pImageList;
	int nItem = lpDrawItemStruct->itemID;
	BOOL bFocus = (GetFocus() == this);
	COLORREF clrTextSave = 0;
	COLORREF clrBkSave = 0;
	COLORREF clrImage = m_clrBkgnd;
	_TCHAR szBuff[MAX_PATH + 1] = {0};
	LPCTSTR pszText;

// get item data

	LV_ITEM lvi;
	lvi.mask = LVIF_IMAGE|LVIF_STATE;
	lvi.iItem = nItem;
	lvi.iSubItem = 0;
	lvi.stateMask = 0xFFFF;
	if (ListCtrl.GetItem(&lvi) == FALSE) {
		PRINTLOG("ListCtrl.GetItem returned FALSE");
		return;
	}

	// CListCtrl::GetItemŋHɃeLXg̎擾Ɏsʂ^ɂȂĂ܂
	// GetItemText\bhŒڃeLXg擾悤ɕύX
	if (GetItemText(szBuff, MAX_PATH, nItem, 0) == FALSE) {
		PRINTLOG("GetItemText returned FALSE");
		return;
	}

	//TRACE(_T("Cq2chwmListView::DrawItem: %d, %s\n"), lpDrawItemStruct->itemID, szBuff);
	BOOL bSelected = (bFocus || (GetStyle() & LVS_SHOWSELALWAYS)) && lvi.state & LVIS_SELECTED;
	bSelected = bSelected || (lvi.state & LVIS_DROPHILITED);

// set colors if item is selected

	CRect rcLabel;
	ListCtrl.GetItemRect(nItem, rcLabel, LVIR_LABEL);

	{
		CRect rcAllLabels;
		ListCtrl.GetItemRect(nItem, rcAllLabels, LVIR_BOUNDS);


		rcAllLabels.left = rcLabel.left;
		if (m_bClientWidthSel && rcAllLabels.right<m_cxClient)
			rcAllLabels.right = m_cxClient;

		if (bSelected)
		{
			clrTextSave = pDC->SetTextColor(m_clrActiveText);
			clrBkSave = pDC->SetBkColor(GetBackColor(nItem));

			CBrush cbr(GetBackColor(nItem));
			pDC->FillRect(rcAllLabels, &cbr);
		}
		else
		{
			clrTextSave = pDC->SetTextColor(GetForeColor(nItem));
			clrBkSave = pDC->SetBkColor(GetBackColor(nItem));
			CBrush cbr(GetBackColor(nItem));
			pDC->FillRect(rcAllLabels, &cbr);
		}
	}

// set color and mask for the icon

	if (lvi.state & LVIS_CUT)
	{
		clrImage = m_clrBkgnd;
		uiFlags |= ILD_BLEND50;
	}
	else if (bSelected)
	{
		clrImage = ::GetSysColor(COLOR_HIGHLIGHT);
		uiFlags |= ILD_BLEND50;
	}

// draw state icon
/*
	UINT nStateImageMask = lvi.state & LVIS_STATEIMAGEMASK;
	if (nStateImageMask)
	{
		int nImage = (nStateImageMask>>12) - 1;
		pImageList = ListCtrl.GetImageList(LVSIL_STATE);
		if (pImageList)
		{
			pImageList->Draw(pDC, nImage,
				CPoint(rcItem.left, rcItem.top), ILD_TRANSPARENT);
		}
	}

// draw normal and overlay icon

	CRect rcIcon;
	ListCtrl.GetItemRect(nItem, rcIcon, LVIR_ICON);

	pImageList = ListCtrl.GetImageList(LVSIL_SMALL);
	if (pImageList)
	{
		UINT nOvlImageMask=lvi.state & LVIS_OVERLAYMASK;
		if (rcItem.left<rcItem.right-1)
		{
			ImageList_DrawEx(pImageList->m_hImageList, lvi.iImage,
					pDC->m_hDC,rcIcon.left,rcIcon.top, 16, 16,
					m_clrBkgnd, clrImage, uiFlags | nOvlImageMask);
		}
	}
*/
	pImageList = ListCtrl.GetImageList(LVSIL_STATE);
	if (pImageList != NULL) {
		RECT rcIcon = rcItem;
		rcIcon.right = rcLabel.left;
		int in_state = GetState(nItem);
		if (in_state & Cq2chwmListItem::STATE_SELECTED) {
			CBrush cbr(GetSysColor(COLOR_HIGHLIGHT));
			pDC->FillRect(&rcIcon, &cbr);
		} else {
			CBrush cbr(GetBackColor(nItem));
			pDC->FillRect(&rcIcon, &cbr);
		}
		int in_left = rcItem.left;
		int in_top = rcItem.top;
		if (in_state & Cq2chwmListItem::STATE_NEW_THREAD) {
			pImageList->Draw(pDC, 4, CPoint(in_left, in_top), ILD_TRANSPARENT);
			if (rcItem.bottom - rcItem.top >= 32) in_top += 16;
		}
		if (in_state & Cq2chwmListItem::STATE_NEW) {
			pImageList->Draw(pDC, 3, CPoint(in_left, in_top), ILD_TRANSPARENT);
			if (rcItem.bottom - rcItem.top >= 32) in_top += 16;
		}
		if (in_state & Cq2chwmListItem::STATE_BOOKMARK) {
			pImageList->Draw(pDC, 2, CPoint(in_left, in_top), ILD_TRANSPARENT);
			if (rcItem.bottom - rcItem.top >= 32) in_top += 16;
		}
		if (in_state & Cq2chwmListItem::STATE_NETWORK) {
			pImageList->Draw(pDC, 1, CPoint(in_left, in_top), ILD_TRANSPARENT);
			if (rcItem.bottom - rcItem.top >= 32) in_top += 16;
		}
	}

// draw item label

	ListCtrl.GetItemRect(nItem, rcItem, LVIR_LABEL);
	rcItem.right -= m_cxStateImageOffset;

	pszText = MakeShortString(pDC, szBuff,
				rcItem.right-rcItem.left, 2*OFFSET_FIRST);

	rcLabel = rcItem;
	rcLabel.left += OFFSET_FIRST;
	rcLabel.right -= OFFSET_FIRST;

	pDC->DrawText(pszText,-1,rcLabel,DT_LEFT | DT_WORDBREAK | DT_NOPREFIX | DT_NOCLIP);

// draw labels for extra columns

	LV_COLUMN lvc;
	lvc.mask = LVCF_FMT | LVCF_WIDTH;

	for(int nColumn = 1; ListCtrl.GetColumn(nColumn, &lvc); nColumn++)
	{
		rcItem.left = rcItem.right;
		rcItem.right += lvc.cx;

		// eLXg̎擾GetItemText\bhœ
		if (GetItemText(szBuff, MAX_PATH, nItem, nColumn) == FALSE) {
			PRINTLOG("GetItemText returned FALSE");
			return;
		}

		if (szBuff[0] == 0x00) {
			continue;
		}

		//pszText = MakeShortString(pDC, szBuff, rcItem.right - rcItem.left, 2*OFFSET_OTHER);
		pszText = szBuff;
		UINT nJustify = DT_LEFT;

		if(pszText == szBuff)
		{
			switch(lvc.fmt & LVCFMT_JUSTIFYMASK)
			{
			case LVCFMT_RIGHT:
				nJustify = DT_RIGHT;
				break;
			case LVCFMT_CENTER:
				nJustify = DT_CENTER;
				break;
			default:
				break;
			}
		}

		rcLabel = rcItem;
		rcLabel.left += OFFSET_OTHER;
		rcLabel.right -= OFFSET_OTHER;
		rcLabel.bottom -= 4;
		pDC->DrawText(pszText, -1, rcLabel, nJustify|DT_WORDBREAK|DT_NOPREFIX);
	}

// draw focus rectangle if item has focus
/*
	if (lvi.state & LVIS_FOCUSED && bFocus)
		pDC->DrawFocusRect(rcAllLabels);
*/
// set original colors if item was selected

	//if (bSelected)
	{
		pDC->SetTextColor(clrTextSave);
		pDC->SetBkColor(clrBkSave);
	}
	//TRACE(_T("Cq2chwmListView::DrawItem: %d end\n"), lpDrawItemStruct->itemID, szBuff);
}

LPCTSTR Cq2chwmListView::MakeShortString(CDC* pDC, LPCTSTR lpszLong, int nColumnLen, int nOffset)
{
	static const _TCHAR szThreeDots[] = _T("");//_T("...");

	int nStringLen = lstrlen(lpszLong);

	if(nStringLen == 0 ||
		(pDC->GetTextExtent(lpszLong, nStringLen).cx + (nOffset * 3)) <= nColumnLen * 2)
	{
		return(lpszLong);
	}

	static _TCHAR szShort[MAX_PATH];

	_tcscpy_s(szShort,MAX_PATH,lpszLong);
	int nAddLen = pDC->GetTextExtent(szThreeDots).cx;

	for(int i = nStringLen - 1; i > 0; i--)
	{
		szShort[i] = 0;
		if((pDC->GetTextExtent(szShort, i).cx + (nOffset * 3) + nAddLen)
			<= nColumnLen * 2)
		{
			break;
		}
	}

	if (lstrlen(lpszLong) > lstrlen(szShort)) {
		_tcscat_s(szShort, MAX_PATH, szThreeDots);
	}
	return(szShort);
}

BOOL Cq2chwmListView::SetFullRowSel(BOOL bFullRowSel)
{
	// no painting during change
//	LockWindowUpdate();

	m_bFullRowSel = bFullRowSel;

	BOOL bRet;

	if (m_bFullRowSel)
		bRet = ModifyStyle(0L, LVS_OWNERDRAWFIXED);
	else
		bRet = ModifyStyle(LVS_OWNERDRAWFIXED, 0L);

	// repaint window if we are not changing view type
	if (bRet && (GetStyle() & LVS_TYPEMASK) == LVS_REPORT)
		Invalidate();

	// repaint changes
//	UnlockWindowUpdate();

	return(bRet);
}

BOOL Cq2chwmListView::GetFullRowSel()
{
	return(m_bFullRowSel);
}

void Cq2chwmListView::RepaintSelectedItems()
{
	CListCtrl& ListCtrl = GetListCtrl();
	CRect rcItem, rcLabel;

// invalidate focused item so it can repaint properly

	int nItem = ListCtrl.GetNextItem(-1, LVNI_FOCUSED);

	if(nItem != -1)
	{
		ListCtrl.GetItemRect(nItem, rcItem, LVIR_BOUNDS);
		ListCtrl.GetItemRect(nItem, rcLabel, LVIR_LABEL);
		rcItem.left = rcLabel.left;

		InvalidateRect(rcItem, FALSE);
	}

// if selected items should not be preserved, invalidate them

	if(!(GetStyle() & LVS_SHOWSELALWAYS))
	{
		for(nItem = ListCtrl.GetNextItem(-1, LVNI_SELECTED);
			nItem != -1; nItem = ListCtrl.GetNextItem(nItem, LVNI_SELECTED))
		{
			ListCtrl.GetItemRect(nItem, rcItem, LVIR_BOUNDS);
			ListCtrl.GetItemRect(nItem, rcLabel, LVIR_LABEL);
			rcItem.left = rcLabel.left;

			InvalidateRect(rcItem, FALSE);
		}
	}

// update changes

	UpdateWindow();
}

LRESULT Cq2chwmListView::OnSetImageList(WPARAM wParam, LPARAM lParam)
{
	OSVERSIONINFO info;
	info.dwOSVersionInfoSize = sizeof(info);
	VERIFY(::GetVersionEx(&info));

	if( (int) wParam == LVSIL_STATE && info.dwMajorVersion < 4)
	{
		int cx, cy;

		if(::ImageList_GetIconSize((HIMAGELIST)lParam, &cx, &cy))
			m_cxStateImageOffset = cx;
		else
			m_cxStateImageOffset = 0;
	}

	return(Default());
}

LRESULT Cq2chwmListView::OnSetTextColor(WPARAM /*wParam*/, LPARAM lParam)
{
	m_clrText = (COLORREF)lParam;
	return(Default());
}

LRESULT Cq2chwmListView::OnSetTextBkColor(WPARAM /*wParam*/, LPARAM lParam)
{
	m_clrTextBk = (COLORREF)lParam;
	return(Default());
}

LRESULT Cq2chwmListView::OnSetBkColor(WPARAM /*wParam*/, LPARAM lParam)
{
	m_clrBkgnd = (COLORREF)lParam;
	return(Default());
}

void Cq2chwmListView::OnSize(UINT nType, int cx, int cy)
{
	m_cxClient = cx;
	CListView::OnSize(nType, cx, cy);
}

void Cq2chwmListView::OnPaint()
{
	if (m_bClientWidthSel &&
		(GetStyle() & LVS_TYPEMASK) == LVS_REPORT &&
		GetFullRowSel())
	{
		CRect rcAllLabels;
		GetListCtrl().GetItemRect(0, rcAllLabels, LVIR_BOUNDS);

		if(rcAllLabels.right < m_cxClient)
		{
			CPaintDC dc(this);

			CRect rcClip;
			dc.GetClipBox(rcClip);

			rcClip.left = min(rcAllLabels.right-1, rcClip.left);
			rcClip.right = m_cxClient;

			InvalidateRect(rcClip, FALSE);
		}
	}

	CListView::OnPaint();
}

void Cq2chwmListView::OnSetFocus(CWnd* pOldWnd)
{
	CListView::OnSetFocus(pOldWnd);

	if(pOldWnd!=NULL && pOldWnd->GetParent()==this)
		return;

	if(m_bFullRowSel && (GetStyle() & LVS_TYPEMASK)==LVS_REPORT)
		RepaintSelectedItems();
}

void Cq2chwmListView::OnKillFocus(CWnd* pNewWnd)
{
	CListView::OnKillFocus(pNewWnd);

	if(pNewWnd != NULL && pNewWnd->GetParent() == this)
		return;

	if(m_bFullRowSel && (GetStyle() & LVS_TYPEMASK) == LVS_REPORT)
		RepaintSelectedItems();
}

void Cq2chwmListView::CopyInformation()
{
	// Rs[񐶐
	Cq2chwmListItem *pItem = GetSelectedItem();
	if (pItem == NULL) return;

	// 
	CYoRegex cRegex("://([^/]+)/([^/]+)/([0-9]+)", CYoRegex::SJIS, TRUE);
	CYoString str_host;
	CYoString str_bid;
	CYoString str_aid;
	if (cRegex.Match(pItem->GetArticleUrl()) >= 0) {
		str_host = cRegex.Get(1);
		str_bid = cRegex.Get(2);
		str_aid = cRegex.Get(3);
	}
	CYoString str_text;
	str_text.Format("%s\r\nhttp://%s/test/read.cgi/%s/%s\r\n", pItem->GetArticleName(), (const char*)str_host, (const char*)str_bid, (const char*)str_aid);
	CString cstr_text;
	cstr_text = (const char*)str_text;
	StringToClipboard(cstr_text);
}

void Cq2chwmListView::ResetSearchState()
{
	for (int i = 0; i < GetListCtrl().GetItemCount(); i++) {
		Cq2chwmListItem *pItem = GetItem(i);
		pItem->SetSearch(FALSE);
	}
}

void Cq2chwmListView::MeasureItem(LPMEASUREITEMSTRUCT lpMeasureItemStruct)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	LOGFONT lf;
	GetFont()->GetLogFont(&lf);
	if (Cq2chwmConfig::GetInstance()->GetListSingleLine() == TRUE) {
		lpMeasureItemStruct->itemHeight = abs(lf.lfHeight) + 4 + Cq2chwmConfig::GetInstance()->GetListMargin();
	} else {
		lpMeasureItemStruct->itemHeight = abs(lf.lfHeight) * 2 + 4 + Cq2chwmConfig::GetInstance()->GetListMargin();
	}
}

LRESULT Cq2chwmListView::OnSetFont(WPARAM wParam, LPARAM lParam)
{
	LRESULT res =  Default();

	CRect rc;
	GetWindowRect( &rc );

	WINDOWPOS wp;
	wp.hwnd = m_hWnd;
	wp.cx = rc.Width();
	wp.cy = rc.Height();
	wp.flags = SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOOWNERZORDER | SWP_NOZORDER;
	SendMessage( WM_WINDOWPOSCHANGED, 0, (LPARAM)&wp );

	return res;
}

BOOL Cq2chwmListView::OnEraseBkgnd(CDC* pDC)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
    // ݒ肳ꂽwiFœhԂ
	CBrush cBrush(Cq2chwmConfig::GetInstance()->GetColorBack());
	CBrush* pOldBrush = pDC->SelectObject(&cBrush);
	CRect rect;
	pDC->GetClipBox(&rect);
	pDC->PatBlt(rect.left, rect.top, rect.Width(), rect.Height(), PATCOPY);
	pDC->SelectObject(pOldBrush);
	return TRUE;
	//return CListView::OnEraseBkgnd(pDC);
}
