#pragma once

#include "q2chwmListView.h"
#include "q2chwmSubjectFile.h"
#include "q2chwmCommon.h"

// Cq2chwmSubjectView r[

class Cq2chwmSubjectView : public Cq2chwmListView
{
//	DECLARE_DYNCREATE(Cq2chwmSubjectView)

private:
	Cq2chwmSubjectFile m_cSubjectFile;
	Cq2chwmSubjectFile m_cSubjectFileOld;
	CYoString m_str_filename;
	CYoString m_str_url;
	CYoString m_str_burl;
	CYoString m_str_bname;
	CYoString m_str_bid;
	BOOL m_bo_running;

private:
	void createList();
	void clearList();
	BOOL isFind2ch(){ return m_str_burl.Find("http://.tmp") == 0; }

protected:
	void OnListClicked();
	BOOL GetItemText(LPTSTR wchp_text, int in_size, int in_row, int in_col);

public:
	Cq2chwmSubjectView();           // IŎgp protected RXgN^
	virtual ~Cq2chwmSubjectView();

	BOOL CreateFromFile(const char *chp_bname, const char *chp_burl, const char *chp_bid);
	BOOL CreateFromHttp(const char *chp_bname, const char *chp_burl, const char *chp_bid);
	BOOL CreateFromFindUrl(const char *chp_url);
	void SetFont();
	void AddBookmark();
	inline const char *GetBoardName(){ return m_str_bname; }
	inline const char *GetBoardUrl(){ return m_str_burl; }
	inline const char *GetBoardId(){ return m_str_bid; }
	inline BOOL IsRunning(){ return m_bo_running; }
	void Search(const char *chp_word);
	void Sort();
	void SortItems(int in_col, BOOL bo_asc);
	Cq2chwmListItem *GetSelectedItem();
	Cq2chwmListItem *GetItem(int iRow);
	BOOL Reload();

public:
#ifdef _DEBUG
	virtual void AssertValid() const;
#ifndef _WIN32_WCE
	virtual void Dump(CDumpContext& dc) const;
#endif
#endif

protected:
	DECLARE_MESSAGE_MAP()
public:
	virtual void OnInitialUpdate();
public:
	afx_msg void OnDestroy();
public:
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
public:
	afx_msg void OnReload();
public:
	afx_msg void OnAddbookmark();
	afx_msg void OnThread();
	afx_msg void OnSortArticleId();
	afx_msg void OnUpdateSortArticleId(CCmdUI *pCmdUI);
	afx_msg void OnSortArticleName();
	afx_msg void OnUpdateSortArticleName(CCmdUI *pCmdUI);
	afx_msg void OnSortCache();
	afx_msg void OnUpdateSortCache(CCmdUI *pCmdUI);
	afx_msg void OnSortCount();
	afx_msg void OnUpdateSortCount(CCmdUI *pCmdUI);
	afx_msg void OnSortIndex();
	afx_msg void OnUpdateSortIndex(CCmdUI *pCmdUI);
	afx_msg void OnSortNew();
	afx_msg void OnUpdateSortNew(CCmdUI *pCmdUI);
	afx_msg void OnSortSearch();
	afx_msg void OnUpdateSortSearch(CCmdUI *pCmdUI);
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	afx_msg void OnAdjustColumnWidth();
	afx_msg void OnSortCountPerDay();
	afx_msg void OnUpdateSortCountPerDay(CCmdUI *pCmdUI);
	afx_msg void OnUpdateSortBname(CCmdUI *pCmdUI);
	afx_msg void OnSortBname();
};


