// q2chwmDatView.cpp : t@C
//

#include "stdafx.h"
#include "YoFile.h"
#include "YoTime.h"
#include "MainFrm.h"
#include "q2chwm.h"
#include "q2chwmDatView.h"
#include "q2chwmDatFile.h"
#include "q2chwmBbsManager.h"
#include "q2chwmConfig.h"
#include "q2chwmDatCtrl.h"
#include "q2chwmMessageDialog.h"
#include "q2chwmTemplateFile.h"
#include "q2chwmNgFile.h"
#include "q2chwmGrepDialog.h"

// ^u상j[z̃XbhƂ̃j[ID̊Jnԍ
#define ID_DATMENU					50000

// ^u상j[z̃j[̐(ũ^uvAuÕ^uvAu^uv3)
#define DEFAULT_TABMENUCOUNT	3

// ^u상j[z̃XbhƂ̃j[̃X^[gʒu(Zp[^݂̂+1lƂȂ)
#define POSITION_DATMENUSTART	(DEFAULT_TABMENUCOUNT + 1)

// Cq2chwmDatView

IMPLEMENT_DYNCREATE(Cq2chwmDatView, CView)

Cq2chwmDatView::Cq2chwmDatView()
{
	m_pFont = NULL;
	m_pMessageDialog = NULL;
	m_in_font_size = 0;
	m_bo_font_bold = FALSE;
}

Cq2chwmDatView::~Cq2chwmDatView()
{
	if (m_pFont != NULL) delete m_pFont;
	if (m_pMessageDialog != NULL) delete m_pMessageDialog;
}

BEGIN_MESSAGE_MAP(Cq2chwmDatView, CView)
	ON_WM_SIZE()
//	ON_MESSAGE(WM_USER_CUSTOM, OnCustomMessage)
	ON_WM_DESTROY()
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_RELOAD, &Cq2chwmDatView::OnReload)
	ON_MESSAGE(WM_USER_TABCLICKED, OnTabClicked)
	ON_COMMAND(ID_EDIT, &Cq2chwmDatView::OnEdit)
	ON_COMMAND(ID_REPLY, &Cq2chwmDatView::OnReply)
	ON_COMMAND(ID_GOTOP, &Cq2chwmDatView::OnGotop)
	ON_COMMAND(ID_GOBOTTOM, &Cq2chwmDatView::OnGobottom)
	ON_COMMAND(ID_CLOSETAB, &Cq2chwmDatView::OnClosetab)
	ON_COMMAND(ID_NEXTTAB, &Cq2chwmDatView::OnNexttab)
	ON_COMMAND(ID_PREVTAB, &Cq2chwmDatView::OnPrevtab)
	ON_COMMAND(ID_ADDBOOKMARK, &Cq2chwmDatView::OnAddbookmark)
	ON_COMMAND(ID_DELETE, &Cq2chwmDatView::OnDelete)
	ON_COMMAND(ID_LINK_BACK, &Cq2chwmDatView::OnLinkBack)
	ON_COMMAND(ID_LINK_NEXT, &Cq2chwmDatView::OnLinkNext)
	ON_COMMAND(ID_LINK_PREV, &Cq2chwmDatView::OnLinkPrev)
	ON_WM_SHOWWINDOW()
	ON_COMMAND(ID_DISP_RELOAD, &Cq2chwmDatView::OnDispReload)
	ON_COMMAND(ID_DISP_WRAP, &Cq2chwmDatView::OnDispWrap)
	ON_UPDATE_COMMAND_UI(ID_DISP_WRAP, &Cq2chwmDatView::OnUpdateDispWrap)
	ON_COMMAND(ID_DISP_ABONE, &Cq2chwmDatView::OnDispAbone)
	ON_UPDATE_COMMAND_UI(ID_DISP_ABONE, &Cq2chwmDatView::OnUpdateDispAbone)
	ON_COMMAND(ID_ADDTEMPLATE, &Cq2chwmDatView::OnAddTemplate)
	ON_UPDATE_COMMAND_UI(ID_ADDTEMPLATE, &Cq2chwmDatView::OnUpdateAddTemplate)
	ON_COMMAND(ID_ADDNG, &Cq2chwmDatView::OnAddNg)
	ON_UPDATE_COMMAND_UI(ID_ADDNG, &Cq2chwmDatView::OnUpdateAddNg)
	ON_COMMAND(ID_GREP_ID, &Cq2chwmDatView::OnGrepId)
	ON_COMMAND(ID_GREP_NAME, &Cq2chwmDatView::OnGrepName)
	ON_COMMAND(ID_GREP_REFER, &Cq2chwmDatView::OnGrepRefer)
	ON_COMMAND(ID_COPYMESSAGE, &Cq2chwmDatView::OnCopyMessage)
	ON_COMMAND(ID_COPY, &Cq2chwmDatView::OnCopy)
	ON_UPDATE_COMMAND_UI(ID_COPY, &Cq2chwmDatView::OnUpdateCopy)
	ON_COMMAND(ID_REPLY_ALL, &Cq2chwmDatView::OnReplyAll)
	ON_COMMAND(ID_OPEN_BROWSER, &Cq2chwmDatView::OnOpenBrowser)
	ON_UPDATE_COMMAND_UI(ID_OPEN_BROWSER, &Cq2chwmDatView::OnUpdateOpenBrowser)
	ON_UPDATE_COMMAND_UI(ID_DELETE, &Cq2chwmDatView::OnUpdateDelete)
	ON_UPDATE_COMMAND_UI(ID_CLOSETAB, &Cq2chwmDatView::OnUpdateClosetab)
END_MESSAGE_MAP()


// Cq2chwmDatView `

void Cq2chwmDatView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: `R[hɒǉĂB
}


// Cq2chwmDatView ff

#ifdef _DEBUG
void Cq2chwmDatView::AssertValid() const
{
	CView::AssertValid();
}

#ifndef _WIN32_WCE
void Cq2chwmDatView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}
#endif
#endif //_DEBUG


// Cq2chwmDatView bZ[W nh

void Cq2chwmDatView::OnInitialUpdate()
{
	CView::OnInitialUpdate();

	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	m_cTab.Create(WS_BORDER|TCS_FIXEDWIDTH|TCS_BUTTONS|TCS_FLATBUTTONS, CRect(0, 0, 0, 0), this, 0);
	m_cTab.ShowWindow(SW_SHOW);
	//m_cTab.SetPadding(CSize(4, 4));
	SetFont();

	// IMEIt
	SipOff(m_hWnd);
}

void Cq2chwmDatView::OnSize(UINT nType, int cx, int cy)
{
	CView::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	if (cx == 0) return;
	if (m_cTab.m_hWnd != NULL) {
		if (m_cTab.GetItemCount() > 0) {
			resizeCtrl();
		} else {
			m_cTab.ShowWindow(SW_HIDE);
		}
	}
}

Cq2chwmDatCtrl *Cq2chwmDatView::searchCtrl(
	const char *chp_url,
	const char *chp_id,
	int& in_index)
{
	for (int i = 0; i < m_cTab.GetItemCount(); i++) {
		TCITEM st_item;
		st_item.mask = TCIF_PARAM;
		m_cTab.GetItem(i, &st_item);
		Cq2chwmDatCtrl *pCtrl = (Cq2chwmDatCtrl*)st_item.lParam;
		if (strcmp(chp_url, pCtrl->GetBoardUrl()) == 0 && strcmp(chp_id, pCtrl->GetArticleId()) == 0) {
			in_index = i;
			return pCtrl;
		}
	}
	return NULL;
}

void Cq2chwmDatView::hideCtrl()
{
	for (int i = 0; i < m_cTab.GetItemCount(); i++) {
		TCITEM st_item;
		st_item.mask = TCIF_PARAM;
		m_cTab.GetItem(i, &st_item);
		Cq2chwmDatCtrl *pCtrl = (Cq2chwmDatCtrl*)st_item.lParam;
		pCtrl->ShowWindow(SW_HIDE);
	}
}

void Cq2chwmDatView::resizeCtrl()
{
	RECT st_rect;
	RECT st_rect_client;
	RECT st_rect_tab;
	int in_index = m_cTab.GetItemCount() - 1;

	GetParent()->GetWindowRect(&st_rect);
	GetClientRect(&st_rect_client);
	m_cTab.GetItemRect(in_index, &st_rect_tab);
	m_cTab.MoveWindow(0, 0, st_rect.right - st_rect.left, st_rect_tab.bottom);
	m_cTab.ShowWindow(SW_SHOW);

	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		pCtrl->MoveWindow(0, st_rect_tab.bottom - 2, st_rect.right - st_rect.left, st_rect_client.bottom - st_rect_tab.bottom + 2);
	}
	/*
	for (int i = 0; i < m_cTab.GetItemCount(); i++) {
		TCITEM st_item;
		st_item.mask = TCIF_PARAM;
		m_cTab.GetItem(i, &st_item);
		Cq2chwmDatCtrl *pCtrl = (Cq2chwmDatCtrl*)st_item.lParam;
		pCtrl->MoveWindow(0, st_rect_tab.bottom, st_rect.right - st_rect.left, st_rect_client.bottom - st_rect_tab.bottom);
	}
	*/
}

long Cq2chwmDatView::OnCustomMessage(
	WPARAM wParam,
	LPARAM lParam)
{
	Cq2chwmMessage *pMessage = (Cq2chwmMessage*)lParam;
	// DatCtrl̗LɊւ炸Ȃ΂Ȃ
	switch (pMessage->GetType()) {
		case Cq2chwmMessage::TYPE_OPENFILE:
		{
			break;
		}
		case Cq2chwmMessage::TYPE_CLOSEFILE:
		{
			// LZȂt@Ct߂
			if (((CMainFrame*)AfxGetMainWnd())->Canceled() == TRUE) {
				CleanFileTime(pMessage->GetFileName());
			}

			int in_index;
			if (searchCtrl(pMessage->GetBoardUrl(), pMessage->GetArticleId(), in_index) == NULL) {
				// YXbhJĂȂƂ͂infot@CXVĂ
				Cq2chwmCloseFileMessage *pCloseFileMessage = (Cq2chwmCloseFileMessage*)pMessage;
				if (pCloseFileMessage->GetWriteSize() > 0) {
					// VtOI
					Cq2chwmInfoFile cInfo;
					cInfo.Create(pCloseFileMessage->GetBoardUrl(), pCloseFileMessage->GetArticleId());
					cInfo.SetCount(Cq2chwmDatFile::Count(pCloseFileMessage->GetFileName()));
					cInfo.SetNew(TRUE);
					cInfo.Write();
				}
			}
			break;
		}
		case Cq2chwmMessage::TYPE_WRITEFILE:
			break;
		case Cq2chwmMessage::TYPE_RELOADFILE:
			break;
		case Cq2chwmMessage::TYPE_CLOSETAB:
			break;
		case Cq2chwmMessage::TYPE_READURL:
			if (IsRunning() == TRUE) {
				Cq2chwmReadUrlMessage *pReadUrlMessage = (Cq2chwmReadUrlMessage*)pMessage;
				AfxGetMainWnd()->SendMessage(WM_USER_SETPROGRESS, pReadUrlMessage->GetRecvSize(), pReadUrlMessage->GetRecvMaxSize());
			}
			break;
	};

#ifdef _DEBUG
	CString cstr_url;
	CString cstr_id;
	cstr_url = pMessage->GetBoardUrl();
	cstr_id = pMessage->GetArticleId();
	TRACE(_T("Cq2chwmDatView::OnCustomMessage: type(%d) url(%s) id(%s)\n"), pMessage->GetType(), cstr_url, cstr_id);
#endif

	int in_index;
	Cq2chwmDatCtrl *pCtrl = searchCtrl(pMessage->GetBoardUrl(), pMessage->GetArticleId(), in_index);
	if (pCtrl != NULL) {
		pCtrl->OnCustomMessage(pMessage);

		// ^uɃXbh^Cgǉ
		if (strlen(pCtrl->GetArticleName()) > 0) {
			for (int i = 0; i < m_cTab.GetItemCount(); i++) {
				// pCtrlɑΉ^u
				TCITEM st_item = {0};
				st_item.mask = TCIF_PARAM;
				m_cTab.GetItem(i, &st_item);
				if (pCtrl == (Cq2chwmDatCtrl*)st_item.lParam) {
					// ^ũ^Cg擾
					TCHAR szBuff[1024];
					TCITEM st_item = {0};
					st_item.mask = TCIF_TEXT;
					st_item.pszText = szBuff;
					st_item.cchTextMax = _countof(szBuff);
					m_cTab.GetItem(i, &st_item);
					if (*st_item.pszText == 0) {
						// ^uɃ^CgZbgĂȂpCtrl̃Xbh^CgZbg
						CString cstr_aname;
						cstr_aname = pCtrl->GetArticleName();
						st_item.mask = TCIF_TEXT;
						st_item.pszText = (LPWSTR)(const wchar_t*)cstr_aname;
						st_item.cchTextMax = cstr_aname.GetLength();
						m_cTab.SetItem(in_index, &st_item);
						modifyMenu(in_index, pCtrl->GetArticleName());
					}
					break;
				}
			}
		}
	}

	return 0;
}

BOOL Cq2chwmDatView::CreateFromFile(
	const char *chp_aname,
	const char *chp_aid,
	const char *chp_bname,
	const char *chp_burl,
	const char *chp_bid,
	int in_number)			// Wv惌Xԍ
{
	hideCtrl();
	if (chp_aname == NULL || chp_aid == NULL || chp_bname == NULL || chp_burl == NULL || chp_bid == NULL) return FALSE;

	// łɊJĂ邩`FbN
	{
		int in_index;
		Cq2chwmDatCtrl *pCtrl = searchCtrl(chp_burl, chp_aid, in_index);
		if (pCtrl != NULL) {
			m_cTab.SetCurSel(in_index);
			pCtrl->ShowWindow(SW_SHOW);
			SetWindowText();

			// IC[hȂ玩IɃ[h
			if (Cq2chwmConfig::GetInstance()->GetOnline() == TRUE) {
				OnReload();
			}

			if (in_number > 0) {
				pCtrl->JumpNumber(in_number);
			}

			return TRUE;
		}
	}

	// ^uő吔Ȃ1^u폜
	if (m_cTab.GetItemCount() == Cq2chwmConfig::GetInstance()->GetTabMax()) {
		CloseTab(0);
	}

	// ^uǉ
	CString cstr_aname;
	cstr_aname = chp_aname;
	int in_index = m_cTab.InsertItem(m_cTab.GetItemCount(), cstr_aname);
	if (in_index == -1) return FALSE;
	m_cTab.SetCurSel(in_index);

	Cq2chwmDatCtrl *pCtrl = new Cq2chwmDatCtrl(this, GetParent());
	TCITEM st_item;
	st_item.mask = TCIF_PARAM;
	st_item.lParam = (LPARAM)pCtrl;
	m_cTab.SetItem(in_index, &st_item);
	SetFont();
	resizeCtrl();
	int in_ret = pCtrl->Create(chp_aname, chp_aid, chp_bname, chp_burl, chp_bid);
	if (in_ret != ERR_NONE) {
		ErrorMessageBox(in_ret);
		return FALSE;
	}

	// NŊJꍇ́Achp_name
	if (*chp_aname == 0x00) {
		CString cstr_aname;
		cstr_aname = pCtrl->GetArticleName();
		TCITEM st_item;
		st_item.mask = TCIF_TEXT;
		st_item.pszText = (LPWSTR)(const wchar_t*)cstr_aname;
		st_item.cchTextMax = cstr_aname.GetLength();
		m_cTab.SetItem(in_index, &st_item);

		RECT lpRect;
		GetClientRect(&lpRect);
		m_cTab.MoveWindow(&lpRect, TRUE);
		SetWindowText();
	} else {
		SetWindowText();
	}
	OnTabClicked(0, 0);

	if (in_number > 0) {
		pCtrl->JumpNumber(in_number);
	}

	// j[ǉ
	appendMenu(GetTabCount() - 1, pCtrl->GetArticleName());

	return TRUE;
}

BOOL Cq2chwmDatView::CloseTab(
	int in_index)
{
	if (in_index >= m_cTab.GetItemCount()) return FALSE;

	// ^uƃRg[폜
	{
		TCITEM st_item;
		st_item.mask = TCIF_PARAM;
		m_cTab.GetItem(in_index, &st_item);
		Cq2chwmDatCtrl *pCtrl = (Cq2chwmDatCtrl*)st_item.lParam;

		// `FbN(ȂȂ)
		if (pCtrl->IsRunning() == TRUE) return FALSE;

		CYoString str_filename = pCtrl->GetFileName();
		delete pCtrl;
		m_cTab.DeleteItem(in_index);
		GetParent()->SendMessage(WM_USER_UPDATEBOOKMARK, 0, (LPARAM)(const char*)str_filename);

		// j[폜
		deleteMenu(in_index);
	}

	if (in_index == 0) {
		m_cTab.SetCurSel(0);
	} else {
		m_cTab.SetCurSel(in_index - 1);
	}

	::InvalidateRect(m_hWnd, NULL, TRUE);
	return TRUE;
}

void Cq2chwmDatView::NextTab()
{
	if (m_cTab.GetItemCount() < 2) return;
	int in_cur = m_cTab.GetCurSel() + 1;
	if (in_cur == m_cTab.GetItemCount()) {
		in_cur = 0;
	}
	m_cTab.SetCurSel(in_cur);
	OnTabClicked(0, 0);
	::InvalidateRect(m_hWnd, NULL, TRUE);
}

void Cq2chwmDatView::PrevTab()
{
	if (m_cTab.GetItemCount() < 2) return;
	int in_cur = m_cTab.GetCurSel() - 1;
	if (in_cur < 0) {
		in_cur = m_cTab.GetItemCount() - 1;
	}
	m_cTab.SetCurSel(in_cur);
	OnTabClicked(0, 0);
	::InvalidateRect(m_hWnd, NULL, TRUE);
}

void Cq2chwmDatView::OnDestroy()
{
	for (int i = 0; i < m_cTab.GetItemCount(); i++) {
		TCITEM st_item;
		st_item.mask = TCIF_PARAM;
		m_cTab.GetItem(i, &st_item);
		Cq2chwmDatCtrl *pCtrl = (Cq2chwmDatCtrl*)st_item.lParam;
		delete pCtrl;
	}

	CView::OnDestroy();

	// TODO: ɃbZ[W nh R[hǉ܂B
}

void Cq2chwmDatView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	TRACE(_T("Cq2chwmDatView::OnKeyDown: %02x(%d)\n"), nChar, nChar);
	if (Cq2chwmConfig::GetInstance()->IsKeyCancel(nChar)) {
		GetParent()->SendMessage(WM_USER_CANCEL, 0, 0);
	} else if (Cq2chwmConfig::GetInstance()->IsKeyViewBack(nChar)) {
		GetParent()->SendMessage(WM_USER_VIEWBACK, 0, 0);
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyViewForward(nChar)) {
		GetParent()->SendMessage(WM_USER_VIEWFORWARD, 0, 0);
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyCloseTab(nChar)) {
		OnClosetab();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyNextTab(nChar)) {
		NextTab();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyPrevTab(nChar)) {
		PrevTab();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyAddBookmark(nChar)) {
		AddBookmark();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyReload(nChar)) {
		OnReload();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyDelete(nChar)) {
		Delete();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyEdit(nChar)) {
		OnEdit();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyEditReply(nChar)) {
		OnReply();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyEditReplyAll(nChar)) {
		OnReplyAll();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyPageUp(nChar)) {
		Cq2chwmDatCtrl *pCtrl = currentCtrl();
		if (pCtrl != NULL) {
			pCtrl->SendMessage(WM_KEYDOWN, VK_PRIOR);
		}
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyPageDown(nChar)) {
		Cq2chwmDatCtrl *pCtrl = currentCtrl();
		if (pCtrl != NULL) {
			pCtrl->SendMessage(WM_KEYDOWN, VK_NEXT);
		}
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyChangeView(nChar)) {
		((Cq2chwmApp*)AfxGetApp())->PopupViewMenu();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyCurrentSubject(nChar)) {
		((Cq2chwmApp*)AfxGetApp())->OnViewCurrentSubject();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyToggleAbone(nChar)) {
		OnDispAbone();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyToggleWrap(nChar)) {
		OnDispWrap();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyReopen(nChar)) {
		OnDispReload();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyGrepId(nChar)) {
		OnGrepId();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyGrepName(nChar)) {
		OnGrepName();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyGrepRefer(nChar)) {
		OnGrepRefer();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyCopyMessage(nChar)) {
		OnCopyMessage();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyExecBrowser(nChar)) {
		OnOpenBrowser();
		return;
	} else {
		Cq2chwmDatCtrl *pCtrl = currentCtrl();
		if (pCtrl != NULL) {
			pCtrl->OnKeyDown(nChar, nRepCnt, nFlags);
			return;
		}
	};

	CView::OnKeyDown(nChar, nRepCnt, nFlags);
}

Cq2chwmDatCtrl *Cq2chwmDatView::currentCtrl()
{
	int in_cur = m_cTab.GetCurSel();
	TCITEM st_item = {0};
	st_item.mask = TCIF_PARAM;
	m_cTab.GetItem(in_cur, &st_item);
	return (Cq2chwmDatCtrl*)st_item.lParam;
}

void Cq2chwmDatView::OnReload()
{
	// TODO: ɃR}h nh R[hǉ܂B
	TRACE(_T("Cq2chwmDatView::OnReload\n"));
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		int in_ret = pCtrl->CreateFromHttp();
		if (in_ret != ERR_NONE) {
			const char *chp_err = pCtrl->GetErrorMessage();
			if (strlen(chp_err) == 0) {
				ErrorMessageBox(in_ret);
			} else {
				ErrorMessageBox(chp_err);
			}
		}
	}
}

long Cq2chwmDatView::OnTabClicked(
	WPARAM wParam,
	LPARAM lParam)
{
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		hideCtrl();
		pCtrl->ShowWindow(SW_SHOW);
		SetWindowText();
		resizeCtrl();
	} else {
		SetWindowText();
	}

	return 0;
}

void Cq2chwmDatView::SetFont()
{
	// ^ũtHgݒ
	{
		CString cstr_name;
		cstr_name = Cq2chwmConfig::GetInstance()->GetFontNameTab();
		LOGFONT lf;
		memset(&lf, 0x00, sizeof(lf));
		_tcscpy_s(lf.lfFaceName, LF_FACESIZE, cstr_name);
		lf.lfHeight = Cq2chwmConfig::GetInstance()->GetFontSizeTab() * 10;
		lf.lfWeight = Cq2chwmConfig::GetInstance()->GetFontBoldTab() == TRUE ? FW_BOLD : FW_NORMAL;
		lf.lfCharSet = DEFAULT_CHARSET;

		if (m_pFont != NULL) delete m_pFont;
		m_pFont = new CFont();
		m_pFont->CreatePointFontIndirect(&lf);
		m_cTab.SetFont(m_pFont);

		// ^u̍ČvZ
		RECT r;
		m_cTab.AdjustRect(FALSE, &r);
		m_cTab.MoveWindow(&r, TRUE); 
		resizeCtrl();
	}

	// ^ũTCYݒ
	{
		RECT st_rect_tab;
		m_cTab.GetItemRect(0, &st_rect_tab);
		CSize cSize(Cq2chwmConfig::GetInstance()->GetTabWidth(), st_rect_tab.bottom - st_rect_tab.top);
		m_cTab.SetItemSize(cSize);
	}

	// ArticlẽtHgύXꂽCq2chwmEditCtrl::ClearCacheĂ΂Ȃ΂ȂȂ
	if (m_str_font_name != Cq2chwmConfig::GetInstance()->GetFontNameArticle() ||
		m_in_font_size != Cq2chwmConfig::GetInstance()->GetFontSizeArticle() ||
		m_bo_font_bold != Cq2chwmConfig::GetInstance()->GetFontBoldArticle())
	{
		Cq2chwmEditCtrl::ClearCache();
	}
	m_str_font_name = Cq2chwmConfig::GetInstance()->GetFontNameArticle();
	m_in_font_size = Cq2chwmConfig::GetInstance()->GetFontSizeArticle();
	m_bo_font_bold = Cq2chwmConfig::GetInstance()->GetFontBoldArticle();

	// r[̃tHgݒ
	for (int i = 0; i < m_cTab.GetItemCount(); i++) {
		TCITEM st_item;
		st_item.mask = TCIF_PARAM;
		m_cTab.GetItem(i, &st_item);
		Cq2chwmDatCtrl *pCtrl = (Cq2chwmDatCtrl*)st_item.lParam;
		pCtrl->SetFont(m_str_font_name, m_in_font_size, m_bo_font_bold);
	}
}

void Cq2chwmDatView::AddBookmark()
{
	if (::MessageBox(m_hWnd, _T("ubN}[Nɒǉ܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
		Cq2chwmDatCtrl *pCtrl = currentCtrl();
		if (pCtrl != NULL) {
			CYoString str_bname = pCtrl->GetBoardName();
			if (str_bname.Length() == 0) {
				// ꗗr[擾
				Cq2chwmBoardView *pView = ((Cq2chwmApp*)AfxGetApp())->GetBoardView();
				int in_find = pView->SearchFromId(pCtrl->GetBoardId());
				if (in_find >= 0) {
					str_bname = pView->GetBoardName(in_find);
				}
			}
			pCtrl->Write();
			Cq2chwmBookmarkItem cBookmarkItem(1, pCtrl->GetArticleName(), pCtrl->GetArticleId(), str_bname, pCtrl->GetBoardId(), pCtrl->GetBoardUrl());
			GetParent()->SendMessage(WM_USER_ADDBOOKMARK, 0, (LPARAM)&cBookmarkItem);
		}
	}
}

void Cq2chwmDatView::Delete()
{
	// `FbN(Ȃ폜`^uN[YȂ)
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL && pCtrl->IsRunning() == TRUE) return;

	if (::MessageBox(m_hWnd, _T("̃Xbh폜܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
		Cq2chwmDatCtrl *pCtrl = currentCtrl();
		if (pCtrl != NULL) {
			CYoString str_filename = pCtrl->GetFileName();
			pCtrl->Delete();
			if (CloseTab(m_cTab.GetCurSel()) == TRUE) {
				if (m_cTab.GetItemCount() == 0) {
					// ^u̐0Ȃ߂
					GetParent()->SendMessage(WM_USER_VIEWBACK, 0, 0);
				} else {
					OnTabClicked(0, 0);
				}
			}
			GetParent()->SendMessage(WM_USER_DELETEDATFILE, 0, (LPARAM)(const char*)str_filename);
		}
	}
}

void Cq2chwmDatView::OnEdit()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		if (m_pMessageDialog == NULL ||
			strcmp(m_pMessageDialog->GetBoardUrl(), pCtrl->GetBoardUrl()) != 0 ||
			strcmp(m_pMessageDialog->GetArticleId(), pCtrl->GetArticleId()) != 0)
		{
			// Xbhς蒼
			if (m_pMessageDialog != NULL) delete m_pMessageDialog;
			m_pMessageDialog = new Cq2chwmMessageDialog(pCtrl->GetArticleName(), pCtrl->GetBoardUrl(), pCtrl->GetArticleId());
		}

		m_pMessageDialog->SetName(pCtrl->GetName());
		m_pMessageDialog->SetMail(pCtrl->GetMail());
		if (m_pMessageDialog->DoModal() == IDOK) {
			pCtrl->SetName(m_pMessageDialog->GetName());
			pCtrl->SetMail(m_pMessageDialog->GetMail());
			pCtrl->Write(TRUE);
			Cq2chwmConfig::GetInstance()->AddHistoryName(m_pMessageDialog->GetName());
			if (strcmp(m_pMessageDialog->GetMail(), "sage") != 0) {
				// sage͗ɓȂ
				Cq2chwmConfig::GetInstance()->AddHistoryMail(m_pMessageDialog->GetMail());
			}
			delete m_pMessageDialog;
			m_pMessageDialog = NULL;
			OnReload();
		}
	}
}

void Cq2chwmDatView::GoTop()
{
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		pCtrl->JumpFirstMessage();
	}
}

void Cq2chwmDatView::GoBottom()
{
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		pCtrl->JumpLastMessage();
	}
}

void Cq2chwmDatView::OnReply()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Reply(FALSE);
}

void Cq2chwmDatView::OnGotop()
{
	// TODO: ɃR}h nh R[hǉ܂B
	GoTop();
}

void Cq2chwmDatView::OnGobottom()
{
	// TODO: ɃR}h nh R[hǉ܂B
	GoBottom();
}

void Cq2chwmDatView::OnClosetab()
{
	// TODO: ɃR}h nh R[hǉ܂B
	if (CloseTab(m_cTab.GetCurSel()) == TRUE) {
		if (m_cTab.GetItemCount() == 0) {
			// ^u̐0Ȃ߂
			GetParent()->SendMessage(WM_USER_VIEWBACK, 0, 0);
		} else {
			OnTabClicked(0, 0);
		}
	}
}

void Cq2chwmDatView::OnNexttab()
{
	// TODO: ɃR}h nh R[hǉ܂B
	NextTab();
}

void Cq2chwmDatView::OnPrevtab()
{
	// TODO: ɃR}h nh R[hǉ܂B
	PrevTab();
}

void Cq2chwmDatView::OnAddbookmark()
{
	// TODO: ɃR}h nh R[hǉ܂B
	AddBookmark();
}

void Cq2chwmDatView::OnDelete()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Delete();
}

BOOL Cq2chwmDatView::IsRunning()
{
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		return pCtrl->IsRunning();
	}
	return FALSE;
}

BOOL Cq2chwmDatView::SearchNext(
	const char *chp_word)
{
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl == NULL) return FALSE;
	if (pCtrl->SearchNext(chp_word) == FALSE) {
		::MessageBox(m_hWnd, _T("Ō܂Ō܂"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK|MB_ICONINFORMATION);
		return FALSE;
	}
	return TRUE;
}

BOOL Cq2chwmDatView::SearchPrev(
	const char *chp_word)
{
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl == NULL) return FALSE;
	if (pCtrl->SearchPrev(chp_word) == FALSE) {
		::MessageBox(m_hWnd, _T("Ō܂Ō܂"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK|MB_ICONINFORMATION);
		return FALSE;
	}
	return TRUE;
}

void Cq2chwmDatView::CopyInformation()
{
	// Rs[񐶐
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl == NULL) return;

	// 
	CYoRegex cRegex("://([^/]+)/([^/]+)/([0-9]+)", CYoRegex::SJIS, TRUE);
	CYoString str_host;
	CYoString str_bid;
	CYoString str_aid;
	if (cRegex.Match(pCtrl->GetArticleUrl()) >= 0) {
		str_host = cRegex.Get(1);
		str_bid = cRegex.Get(2);
		str_aid = cRegex.Get(3);
	}
	CYoString str_text;
	str_text.Format("%s\r\nhttp://%s/test/read.cgi/%s/%s/%d-\r\n",
		pCtrl->GetArticleName(), (const char*)str_host, (const char*)str_bid, (const char*)str_aid, pCtrl->GetCurrentMessageNumber());
	CString cstr_text;
	cstr_text = (const char*)str_text;
	StringToClipboard(cstr_text);
}

BOOL Cq2chwmDatView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	cs.style &= ~WS_BORDER;
	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
	return CView::PreCreateWindow(cs);
}

void Cq2chwmDatView::SetWindowText()
{
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		CString cstr_text;
		cstr_text = pCtrl->GetArticleName();
		AfxGetMainWnd()->SetWindowText(cstr_text);
	} else {
		AfxGetMainWnd()->SetWindowText(_T(""));
	}
}

void Cq2chwmDatView::OnLinkBack()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		pCtrl->JumpBack();
	}
}

void Cq2chwmDatView::OnLinkNext()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		pCtrl->JumpNextLink();
	}
}

void Cq2chwmDatView::OnLinkPrev()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		pCtrl->JumpPrevLink();
	}
}

void Cq2chwmDatView::OnShowWindow(BOOL bShow, UINT nStatus)
{
	CView::OnShowWindow(bShow, nStatus);

	// TODO: ɃbZ[W nh R[hǉ܂B
	if (bShow == FALSE) {
		for (int i = 0; i < m_cTab.GetItemCount(); i++) {
			TCITEM st_item;
			st_item.mask = TCIF_PARAM;
			m_cTab.GetItem(i, &st_item);
			Cq2chwmDatCtrl *pCtrl = (Cq2chwmDatCtrl*)st_item.lParam;
			pCtrl->Write();
			GetParent()->SendMessage(WM_USER_UPDATEBOOKMARK, 0, (LPARAM)pCtrl->GetFileName());
		}
	}
}

const char *Cq2chwmDatView::GetCurrentBoardUrl()
{
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl == NULL) return NULL;
	return pCtrl->GetBoardUrl();
}

const char *Cq2chwmDatView::GetCurrentBoardName()
{
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl == NULL) return NULL;
	return pCtrl->GetBoardName();
}

const char *Cq2chwmDatView::GetCurrentBoardId()
{
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl == NULL) return NULL;
	return pCtrl->GetBoardId();
}

const char *Cq2chwmDatView::GetCurrentArticleId()
{
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl == NULL) return NULL;
	return pCtrl->GetArticleId();
}

const char *Cq2chwmDatView::GetCurrentArticleName()
{
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl == NULL) return NULL;
	return pCtrl->GetArticleName();
}

const char *Cq2chwmDatView::GetCurrentMessageText()
{
	// XbhZ[tႠ܂
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl == NULL) return NULL;
	static CYoString str_message;
	CString cstr_message;
	pCtrl->GetCurrentMessageText(cstr_message, TRUE);
	str_message = A(cstr_message);
	return str_message;
}

void Cq2chwmDatView::OnDispReload()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl == NULL) return;
	pCtrl->Write();
	pCtrl->Reload();
}

void Cq2chwmDatView::OnDispWrap()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl == NULL) return;
	pCtrl->SetWrap(!pCtrl->GetWrap());
}

void Cq2chwmDatView::OnUpdateDispWrap(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl == NULL) return;
	pCmdUI->SetCheck(pCtrl->GetWrap());
}

void Cq2chwmDatView::OnDispAbone()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl == NULL) return;
	pCtrl->Write();
	pCtrl->SetTransParentAbone(!pCtrl->GetTransParentAbone());
}

void Cq2chwmDatView::OnUpdateDispAbone(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl == NULL) return;
	pCmdUI->SetCheck(pCtrl->GetTransParentAbone());
}

void Cq2chwmDatView::OnAddTemplate()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl == NULL) return;
	CString cstr_text;
	if (pCtrl->GetSelectedString(cstr_text) == TRUE) {
		cstr_text.Replace(_T("\n"), _T("\\n"));
	}
	CYoString str_text = A(cstr_text);
	Cq2chwmTemplateFile::GetInstance()->InsertTemplate(str_text);
	if (Cq2chwmTemplateFile::GetInstance()->Write() == TRUE) {
		::MessageBox(m_hWnd, _T("^ɒǉ܂"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK|MB_ICONINFORMATION);
	}
}

void Cq2chwmDatView::OnUpdateAddTemplate(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl == NULL) return;
	CString cstr_text;
	pCmdUI->Enable(pCtrl->GetSelectedString(cstr_text));
}

void Cq2chwmDatView::OnAddNg()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl == NULL) return;
	CString cstr_text;
	if (pCtrl->GetSelectedString(cstr_text) == TRUE) {
		// NG[h͉s폜
		cstr_text.Replace(_T("\n"), _T(""));
	}
	CYoString str_text = A(cstr_text);
	Cq2chwmNgFile::GetInstance()->InsertNg(pCtrl->GetArticleUrl(), str_text);
	if (Cq2chwmNgFile::GetInstance()->Write() == TRUE) {
		::MessageBox(m_hWnd, _T("NG[hɒǉ܂"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK|MB_ICONINFORMATION);
	}
}

void Cq2chwmDatView::OnUpdateAddNg(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl == NULL) return;
	CString cstr_text;
	pCmdUI->Enable(pCtrl->GetSelectedString(cstr_text));
}

void Cq2chwmDatView::OnGrepId()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl == NULL) return;

	// ID擾
	CString cstr_current_id;
	if (pCtrl->GetMessageId(pCtrl->GetCurrentMessageNumber(), cstr_current_id) == FALSE) return;
	pCtrl->GrepId(cstr_current_id);
}

void Cq2chwmDatView::OnGrepName()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl == NULL) return;

	// O擾
	CString cstr_current_name;
	if (pCtrl->GetMessageName(pCtrl->GetCurrentMessageNumber(), cstr_current_name) == FALSE) return;
	pCtrl->GrepName(cstr_current_name);
}

void Cq2chwmDatView::OnGrepRefer()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl == NULL) return;

	// JgXԍ擾
	int in_number = pCtrl->GetCurrentMessageNumber();
	pCtrl->GrepRefer(in_number);
}

void Cq2chwmDatView::OnCopyMessage()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		pCtrl->CopyMessage(pCtrl->GetCurrentMessageNumber());
	}
}

void Cq2chwmDatView::OnCopy()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		pCtrl->Copy();
	}
}

void Cq2chwmDatView::OnUpdateCopy(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl == NULL) return;
	CString cstr_text;
	pCmdUI->Enable(pCtrl->GetSelectedString(cstr_text));
}

void Cq2chwmDatView::OnReplyAll()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Reply(TRUE);
}

void Cq2chwmDatView::Reply(
	BOOL bo_message)
{
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		// bZ[WZbg
		CYoString str_text;
		str_text.Format(">>%d\r\n", pCtrl->GetCurrentMessageNumber());
		if (bo_message == TRUE) {
			CString cstr_message;
			pCtrl->GetCurrentMessageText(cstr_message);
			cstr_message.Trim();
			cstr_message.Replace(_T("\r\n"), _T("\r\n>"));
			cstr_message.Insert(0, _T(">"));
			str_text += A(cstr_message);
		}

		if (m_pMessageDialog == NULL ||
			strcmp(m_pMessageDialog->GetBoardUrl(), pCtrl->GetBoardUrl()) != 0 ||
			strcmp(m_pMessageDialog->GetArticleId(), pCtrl->GetArticleId()) != 0)
		{
			// Xbhς蒼
			if (m_pMessageDialog != NULL) delete m_pMessageDialog;
			m_pMessageDialog = new Cq2chwmMessageDialog(pCtrl->GetArticleName(), pCtrl->GetBoardUrl(), pCtrl->GetArticleId());
		}

		m_pMessageDialog->SetName(pCtrl->GetName());
		m_pMessageDialog->SetMail(pCtrl->GetMail());
		m_pMessageDialog->SetMessage(str_text);
		if (m_pMessageDialog->DoModal() == IDOK) {
			pCtrl->SetName(m_pMessageDialog->GetName());
			pCtrl->SetMail(m_pMessageDialog->GetMail());
			pCtrl->Write(TRUE);
			Cq2chwmConfig::GetInstance()->AddHistoryName(m_pMessageDialog->GetName());
			if (strcmp(m_pMessageDialog->GetMail(), "sage") != 0) {
				// sage͗ɓȂ
				Cq2chwmConfig::GetInstance()->AddHistoryMail(m_pMessageDialog->GetMail());
			}
			delete m_pMessageDialog;
			m_pMessageDialog = NULL;
			OnReload();
		}
	}
}

void Cq2chwmDatView::JumpNumber(
	int in_number)
{
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		pCtrl->JumpNumber(in_number, TRUE);
	}
}

void Cq2chwmDatView::InvalidateRect(
	LPCRECT lpRect,
	BOOL bErase)
{
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		pCtrl->InvalidateRect(lpRect, bErase);
	}
	CView::InvalidateRect(lpRect, bErase);
}

void Cq2chwmDatView::OnOpenBrowser()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		CString cstr_text;
		pCtrl->GetSelectedString(cstr_text);
		((CMainFrame*)AfxGetMainWnd())->OpenBrowser(cstr_text);
	}
}

void Cq2chwmDatView::OnUpdateOpenBrowser(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl == NULL) return;
	CString cstr_text;
	pCmdUI->Enable(pCtrl->GetSelectedString(cstr_text));
}

void Cq2chwmDatView::OnUpdateDelete(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl == NULL) return;
	pCmdUI->Enable(pCtrl->IsRunning() == FALSE);
}

void Cq2chwmDatView::OnUpdateClosetab(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl == NULL) return;
	pCmdUI->Enable(pCtrl->IsRunning() == FALSE);
}

BOOL Cq2chwmDatView::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	if (nID >= (UINT)ID_DATMENU && nID < (UINT)ID_DATMENU + GetTabCount()) {
		if (nCode == CN_COMMAND) {
			m_cTab.SetCurSel(nID - ID_DATMENU);
			OnTabClicked(0, 0);
			::InvalidateRect(m_hWnd, NULL, TRUE);
		} else if (nCode == CN_UPDATE_COMMAND_UI) {
			CCmdUI* pCmdUI = (CCmdUI*)pExtra;
			pCmdUI->Enable(TRUE);
			pCmdUI->SetCheck(nID == ID_DATMENU + m_cTab.GetCurSel());
		}
		return TRUE;
	}
	return CView::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

void Cq2chwmDatView::OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	if (pActivateView != pDeactiveView) {
		TRACE(_T("Cq2chwmDatView::OnActivateView: [%d][%08x][%08x]\n"), bActivate, pActivateView, pDeactiveView);
		if (bActivate == TRUE) {
			createMenu();
		} else {
			clearMenu();
		}
	}
	CView::OnActivateView(bActivate, pActivateView, pDeactiveView);
}

/*
 * ^u상j[z̃XbhƂ̃j[ǉ
 * \param in_index 0n܂CfbNXl
 * \param chp_name j[
 */
void Cq2chwmDatView::appendMenu(
	int in_index,
	const char *chp_name)
{
#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
	HMENU hMenu = ((CMainFrame*)AfxGetMainWnd())->GetMenu(1);
	CMenu *pSubMenu= CMenu::FromHandle(hMenu);
#else
	CMenu *pMenu = AfxGetMainWnd()->GetMenu();
	CMenu *pSubMenu = pMenu->GetSubMenu(1);
#endif
	CMenu *pTabSubMenu = pSubMenu->GetSubMenu(1);
	if (pTabSubMenu->GetMenuItemCount() == 3) {
		pTabSubMenu->AppendMenu(MF_SEPARATOR);
	}

	CString cstr_name;
	cstr_name = chp_name;
	pTabSubMenu->AppendMenu(MF_STRING, ID_DATMENU + in_index, cstr_name);
	AfxGetMainWnd()->DrawMenuBar();
}

/*
 * ^u상j[z̃XbhƂ̃j[폜
 * \param in_index 0n܂CfbNXl
 */
void Cq2chwmDatView::deleteMenu(
	int in_index)
{
#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
	HMENU hMenu = ((CMainFrame*)AfxGetMainWnd())->GetMenu(1);
	CMenu *pSubMenu= CMenu::FromHandle(hMenu);
#else
	CMenu *pMenu = AfxGetMainWnd()->GetMenu();
	CMenu *pSubMenu = pMenu->GetSubMenu(1);
#endif
	CMenu *pTabSubMenu = pSubMenu->GetSubMenu(1);
	pTabSubMenu->DeleteMenu(POSITION_DATMENUSTART + in_index, MF_BYPOSITION);
	for (int i = POSITION_DATMENUSTART + in_index; i < (int)pTabSubMenu->GetMenuItemCount(); i++) {
		// j[IDUȂ
		CString cstr_name;
		pTabSubMenu->GetMenuString(i, cstr_name, MF_BYPOSITION);
		pTabSubMenu->ModifyMenu(i, MF_BYPOSITION|MF_STRING, ID_DATMENU + i - POSITION_DATMENUSTART, cstr_name);
	}
	AfxGetMainWnd()->DrawMenuBar();
}

/*
 * ^u상j[z̃XbhƂ̃j[ƃZp[^Sč폜
 */
void Cq2chwmDatView::clearMenu()
{
#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
	HMENU hMenu = ((CMainFrame*)AfxGetMainWnd())->GetMenu(1);
	CMenu *pSubMenu= CMenu::FromHandle(hMenu);
#else
	CMenu *pMenu = AfxGetMainWnd()->GetMenu();
	CMenu *pSubMenu = pMenu->GetSubMenu(1);
#endif
	CMenu *pTabSubMenu = pSubMenu->GetSubMenu(1);
	while (pTabSubMenu->GetMenuItemCount() > 3) {
		pTabSubMenu->DeleteMenu(DEFAULT_TABMENUCOUNT, MF_BYPOSITION);
	}
}

/*
 * ^u상j[z̃XbhƂ̃j[݊JĂXbh̓eō쐬
 */
void Cq2chwmDatView::createMenu()
{
	clearMenu();
	for (int i = 0; i < GetTabCount(); i++) {
		TCITEM st_item;
		st_item.mask = TCIF_PARAM;
		m_cTab.GetItem(i, &st_item);
		Cq2chwmDatCtrl *pCtrl = (Cq2chwmDatCtrl*)st_item.lParam;
		appendMenu(i, pCtrl->GetArticleName());
	}
}

/*
 * ^u상j[z̃XbhƂ̃j[ύX
 * \param in_index 0n܂CfbNXl
 * \param chp_name j[
 */
void Cq2chwmDatView::modifyMenu(
	int in_index,
	const char *chp_name)
{
#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
	HMENU hMenu = ((CMainFrame*)AfxGetMainWnd())->GetMenu(1);
	CMenu *pSubMenu= CMenu::FromHandle(hMenu);
#else
	CMenu *pMenu = AfxGetMainWnd()->GetMenu();
	CMenu *pSubMenu = pMenu->GetSubMenu(1);
#endif
	CMenu *pTabSubMenu = pSubMenu->GetSubMenu(1);
	if (pTabSubMenu->GetMenuItemCount() == 3) {
		pTabSubMenu->AppendMenu(MF_SEPARATOR);
	}

	CString cstr_name;
	cstr_name = chp_name;
	pTabSubMenu->ModifyMenu(POSITION_DATMENUSTART + in_index, MF_BYPOSITION|MF_STRING, ID_DATMENU + in_index, cstr_name);
	AfxGetMainWnd()->DrawMenuBar();
}
