#include "StdAfx.h"
#include "ServiceFunc.h"


/* Defines */
#define COREDLL_DLLNAME				_T("coredll.dll")
#define GETSERVICEHANDLE_FUNC_NAME	"GetServiceHandle"
#define ACTIVATESERVICE_FUNC_NAME	"ActivateService"
#define DEREGISTERSERVICE_FUNC_NAME	"DeregisterService"

/* Typedefs */
typedef HANDLE (WINAPI * PFNACTIVATESERVICE)(LPCWSTR, DWORD);
typedef BOOL   (WINAPI * PFNDEREGISTERSERVICE)(HANDLE);
typedef HANDLE (WINAPI * PFNGETSERVICEHANDLE)(LPWSTR, LPWSTR, DWORD);

typedef struct _SERVICEFUNCENTRY {
	PFNACTIVATESERVICE		pfnActivateService;
	PFNDEREGISTERSERVICE	pfnDeregisterService;
	PFNGETSERVICEHANDLE		pfnGetServiceHandle;
} SERVICEFUNCENTRY;


/* Global Variables */
static SERVICEFUNCENTRY	gs_ServiceFuncEntry;
static BOOL				gs_bServiceFuncInit = FALSE;

///////////////////////////////////////////////////////////

BOOL
SF_Init()
{
	BOOL					bRet;
	HMODULE					hModule					= NULL;
	PFNACTIVATESERVICE		pfnActivateService		= NULL;
	PFNDEREGISTERSERVICE	pfnDeregisterService	= NULL;
	PFNGETSERVICEHANDLE		pfnGetServiceHandle		= NULL;

	bRet = FALSE;

	if (gs_bServiceFuncInit) {
		// ς
		return TRUE;
	}

	memset(&gs_ServiceFuncEntry, 0, sizeof(gs_ServiceFuncEntry));

	hModule = GetModuleHandle(COREDLL_DLLNAME);
	if (hModule != NULL) {

#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
		pfnActivateService		= (PFNACTIVATESERVICE)   GetProcAddress(hModule, _T(ACTIVATESERVICE_FUNC_NAME));
		pfnDeregisterService	= (PFNDEREGISTERSERVICE) GetProcAddress(hModule, _T(DEREGISTERSERVICE_FUNC_NAME));
		pfnGetServiceHandle		= (PFNGETSERVICEHANDLE)  GetProcAddress(hModule, _T(GETSERVICEHANDLE_FUNC_NAME));
#else
		pfnActivateService		= (PFNACTIVATESERVICE)   GetProcAddress(hModule, ACTIVATESERVICE_FUNC_NAME);
		pfnDeregisterService	= (PFNDEREGISTERSERVICE) GetProcAddress(hModule, DEREGISTERSERVICE_FUNC_NAME);
		pfnGetServiceHandle		= (PFNGETSERVICEHANDLE)  GetProcAddress(hModule, GETSERVICEHANDLE_FUNC_NAME);
#endif

		if (pfnActivateService   != NULL &&
			pfnDeregisterService != NULL &&
			pfnGetServiceHandle  != NULL ) {

			gs_ServiceFuncEntry.pfnActivateService		= pfnActivateService;
			gs_ServiceFuncEntry.pfnDeregisterService	= pfnDeregisterService;
			gs_ServiceFuncEntry.pfnGetServiceHandle		= pfnGetServiceHandle;

			gs_bServiceFuncInit = TRUE;
			bRet = TRUE;
		}
	}

	return bRet;
}


BOOL
SF_Term()
{
	BOOL	bRet = FALSE;

	if (gs_bServiceFuncInit) {
		gs_bServiceFuncInit = FALSE;
		bRet = TRUE;
	}

	return bRet;
}


HANDLE
SF_ActivateService(
	LPWSTR	szServiceName,
	DWORD	dwReserved
)
{
	HANDLE	hService = INVALID_HANDLE_VALUE;

	if (gs_bServiceFuncInit) {
		hService = (* (gs_ServiceFuncEntry.pfnActivateService))(szServiceName, dwReserved);
	}
	return hService;
}


BOOL
SF_DeregisterService(
	HANDLE	hService
)
{
	BOOL	bRet = FALSE;

	if (gs_bServiceFuncInit) {
		bRet = (* (gs_ServiceFuncEntry.pfnDeregisterService))(hService);
	}

	return bRet;
}


HANDLE
SF_GetServiceHandle(
	LPWSTR	szPrefix,
	LPWSTR	szDllName,
	DWORD	pdwDllBuf
)
{
	HANDLE	hService = INVALID_HANDLE_VALUE;

	if (gs_bServiceFuncInit) {
		hService = (* (gs_ServiceFuncEntry.pfnGetServiceHandle))(szPrefix, szDllName, pdwDllBuf);
	}

	return hService;
}
