#pragma once

#ifdef WIN32
#include "afxcview.h"
#endif
#include "q2chwmCommon.h"
#include "YoCommon.h"
#include "YoHttpClient.h"
#include "q2chwmImage.h"

// Cq2chwmImageView r[

class Cq2chwmGetImageInfo
{
private:
	CYoString m_str_url;
	CYoString m_str_message;
	int m_in_ret;

public:
	Cq2chwmGetImageInfo(int in_ret, const char *chp_url, const char *chp_message)
	{
		m_in_ret = in_ret;
		m_str_url = chp_url;
		m_str_message = chp_message;
	}
	inline const char *GetUrl(){ return m_str_url; }
	inline const char *GetMessage(){ return m_str_message; }
	inline int GetCode(){ return m_in_ret; }
};

class Cq2chwmImageView : public CScrollView
{
	DECLARE_DYNCREATE(Cq2chwmImageView)

private:
	Cq2chwmImage m_cImage;
	CWnd *m_pParent;
	CString m_cstr_error;
	CYoString m_str_url;
	CYoString m_str_filename;
	BOOL m_bo_fit;
	CMapStringToPtr m_cMapUrl;		// URLi[
	CYoMutex m_cMutex;

private:
	static UINT __cdecl ThreadHttpGetProc(LPVOID vop_user);
	BOOL setSize();
	static CRect getAdjustRect(const CSize sizeImage, const CSize sizeHint);
	void setErrorMessage(const char *chp_func, DWORD dwLine, DWORD dwError, LPCTSTR lpszFormat, ...);
	CSize getViewSize();
	void addUrl(const char *chp_url);
	void removeUrl(const char *chp_url);
	BOOL existsUrl(const char *chp_url);

public:
	Cq2chwmImageView();           // IŎgp protected RXgN^
	virtual ~Cq2chwmImageView();
	BOOL HttpGet(const char *chp_url, BOOL bo_force = FALSE);
	BOOL CreateImage(const char *chp_url);
	BOOL IsRunning(){ return (m_cMapUrl.GetCount() > 0); }
	void SetErrorMessage(const char *chp_message) { m_cImage.Destroy(); m_cstr_error = chp_message; }

#ifdef _DEBUG
	virtual void AssertValid() const;
#ifndef _WIN32_WCE
	virtual void Dump(CDumpContext& dc) const;
#endif
#endif

protected:
	virtual void OnDraw(CDC* pDC);      // ̃r[`悷邽߂ɃI[o[Ch܂B
public:
	virtual void OnInitialUpdate();     // \z 1 
public:
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);

	DECLARE_MESSAGE_MAP()
	afx_msg void OnReload();
	afx_msg void OnDelete();
	afx_msg void OnUpdateDelete(CCmdUI *pCmdUI);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
};
